package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallPolicyPriorUsed invokes the cloudfw.DescribeVpcFirewallPolicyPriorUsed API synchronously
func (client *Client) DescribeVpcFirewallPolicyPriorUsed(request *DescribeVpcFirewallPolicyPriorUsedRequest) (response *DescribeVpcFirewallPolicyPriorUsedResponse, err error) {
	response = CreateDescribeVpcFirewallPolicyPriorUsedResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallPolicyPriorUsedWithChan invokes the cloudfw.DescribeVpcFirewallPolicyPriorUsed API asynchronously
func (client *Client) DescribeVpcFirewallPolicyPriorUsedWithChan(request *DescribeVpcFirewallPolicyPriorUsedRequest) (<-chan *DescribeVpcFirewallPolicyPriorUsedResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallPolicyPriorUsedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallPolicyPriorUsed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallPolicyPriorUsedWithCallback invokes the cloudfw.DescribeVpcFirewallPolicyPriorUsed API asynchronously
func (client *Client) DescribeVpcFirewallPolicyPriorUsedWithCallback(request *DescribeVpcFirewallPolicyPriorUsedRequest, callback func(response *DescribeVpcFirewallPolicyPriorUsedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallPolicyPriorUsedResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallPolicyPriorUsed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallPolicyPriorUsedRequest is the request struct for api DescribeVpcFirewallPolicyPriorUsed
type DescribeVpcFirewallPolicyPriorUsedRequest struct {
	*requests.RpcRequest
	SourceIp      string `position:"Query" name:"SourceIp"`
	Lang          string `position:"Query" name:"Lang"`
	VpcFirewallId string `position:"Query" name:"VpcFirewallId"`
}

// DescribeVpcFirewallPolicyPriorUsedResponse is the response struct for api DescribeVpcFirewallPolicyPriorUsed
type DescribeVpcFirewallPolicyPriorUsedResponse struct {
	*responses.BaseResponse
	End       int    `json:"End" xml:"End"`
	Start     int    `json:"Start" xml:"Start"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeVpcFirewallPolicyPriorUsedRequest creates a request to invoke DescribeVpcFirewallPolicyPriorUsed API
func CreateDescribeVpcFirewallPolicyPriorUsedRequest() (request *DescribeVpcFirewallPolicyPriorUsedRequest) {
	request = &DescribeVpcFirewallPolicyPriorUsedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallPolicyPriorUsed", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallPolicyPriorUsedResponse creates a response to parse from DescribeVpcFirewallPolicyPriorUsed response
func CreateDescribeVpcFirewallPolicyPriorUsedResponse() (response *DescribeVpcFirewallPolicyPriorUsedResponse) {
	response = &DescribeVpcFirewallPolicyPriorUsedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
