package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainResolve invokes the cloudfw.DescribeDomainResolve API synchronously
func (client *Client) DescribeDomainResolve(request *DescribeDomainResolveRequest) (response *DescribeDomainResolveResponse, err error) {
	response = CreateDescribeDomainResolveResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainResolveWithChan invokes the cloudfw.DescribeDomainResolve API asynchronously
func (client *Client) DescribeDomainResolveWithChan(request *DescribeDomainResolveRequest) (<-chan *DescribeDomainResolveResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainResolveResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainResolve(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainResolveWithCallback invokes the cloudfw.DescribeDomainResolve API asynchronously
func (client *Client) DescribeDomainResolveWithCallback(request *DescribeDomainResolveRequest, callback func(response *DescribeDomainResolveResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainResolveResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainResolve(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainResolveRequest is the request struct for api DescribeDomainResolve
type DescribeDomainResolveRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	Domain    string `position:"Query" name:"Domain"`
	IpVersion string `position:"Query" name:"IpVersion"`
	Lang      string `position:"Query" name:"Lang"`
}

// DescribeDomainResolveResponse is the response struct for api DescribeDomainResolve
type DescribeDomainResolveResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResolveResult ResolveResult `json:"ResolveResult" xml:"ResolveResult"`
}

// CreateDescribeDomainResolveRequest creates a request to invoke DescribeDomainResolve API
func CreateDescribeDomainResolveRequest() (request *DescribeDomainResolveRequest) {
	request = &DescribeDomainResolveRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeDomainResolve", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainResolveResponse creates a response to parse from DescribeDomainResolve response
func CreateDescribeDomainResolveResponse() (response *DescribeDomainResolveResponse) {
	response = &DescribeDomainResolveResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
