package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCompanyTemplate invokes the cloudesl.UpdateCompanyTemplate API synchronously
func (client *Client) UpdateCompanyTemplate(request *UpdateCompanyTemplateRequest) (response *UpdateCompanyTemplateResponse, err error) {
	response = CreateUpdateCompanyTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCompanyTemplateWithChan invokes the cloudesl.UpdateCompanyTemplate API asynchronously
func (client *Client) UpdateCompanyTemplateWithChan(request *UpdateCompanyTemplateRequest) (<-chan *UpdateCompanyTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateCompanyTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCompanyTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCompanyTemplateWithCallback invokes the cloudesl.UpdateCompanyTemplate API asynchronously
func (client *Client) UpdateCompanyTemplateWithCallback(request *UpdateCompanyTemplateRequest, callback func(response *UpdateCompanyTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCompanyTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateCompanyTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCompanyTemplateRequest is the request struct for api UpdateCompanyTemplate
type UpdateCompanyTemplateRequest struct {
	*requests.RpcRequest
	ExtraParams     string `position:"Body" name:"ExtraParams"`
	Scene           string `position:"Body" name:"Scene"`
	TemplateVersion string `position:"Body" name:"TemplateVersion"`
	TemplateName    string `position:"Body" name:"TemplateName"`
	TemplateSceneId string `position:"Body" name:"TemplateSceneId"`
	TemplateId      string `position:"Body" name:"TemplateId"`
}

// UpdateCompanyTemplateResponse is the response struct for api UpdateCompanyTemplate
type UpdateCompanyTemplateResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateUpdateCompanyTemplateRequest creates a request to invoke UpdateCompanyTemplate API
func CreateUpdateCompanyTemplateRequest() (request *UpdateCompanyTemplateRequest) {
	request = &UpdateCompanyTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "UpdateCompanyTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCompanyTemplateResponse creates a response to parse from UpdateCompanyTemplate response
func CreateUpdateCompanyTemplateResponse() (response *UpdateCompanyTemplateResponse) {
	response = &UpdateCompanyTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
