package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportEslDevices invokes the cloudesl.ExportEslDevices API synchronously
func (client *Client) ExportEslDevices(request *ExportEslDevicesRequest) (response *ExportEslDevicesResponse, err error) {
	response = CreateExportEslDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// ExportEslDevicesWithChan invokes the cloudesl.ExportEslDevices API asynchronously
func (client *Client) ExportEslDevicesWithChan(request *ExportEslDevicesRequest) (<-chan *ExportEslDevicesResponse, <-chan error) {
	responseChan := make(chan *ExportEslDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportEslDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportEslDevicesWithCallback invokes the cloudesl.ExportEslDevices API asynchronously
func (client *Client) ExportEslDevicesWithCallback(request *ExportEslDevicesRequest, callback func(response *ExportEslDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportEslDevicesResponse
		var err error
		defer close(result)
		response, err = client.ExportEslDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportEslDevicesRequest is the request struct for api ExportEslDevices
type ExportEslDevicesRequest struct {
	*requests.RpcRequest
	ExtraParams      string           `position:"Body" name:"ExtraParams"`
	Language         string           `position:"Body" name:"Language"`
	Type             string           `position:"Body" name:"Type"`
	StoreId          string           `position:"Body" name:"StoreId"`
	EslBarCode       string           `position:"Body" name:"EslBarCode"`
	TypeEncode       string           `position:"Body" name:"TypeEncode"`
	EslStatus        string           `position:"Body" name:"EslStatus"`
	ToBatteryLevel   requests.Integer `position:"Body" name:"ToBatteryLevel"`
	LevelLower       string           `position:"Body" name:"LevelLower"`
	FromBatteryLevel requests.Integer `position:"Body" name:"FromBatteryLevel"`
	LevelOrder       string           `position:"Body" name:"LevelOrder"`
}

// ExportEslDevicesResponse is the response struct for api ExportEslDevices
type ExportEslDevicesResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ErrorMessage    string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success         bool   `json:"Success" xml:"Success"`
	ErrorCode       string `json:"ErrorCode" xml:"ErrorCode"`
	Code            string `json:"Code" xml:"Code"`
	Message         string `json:"Message" xml:"Message"`
	DynamicMessage  string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode     string `json:"DynamicCode" xml:"DynamicCode"`
	DownloadAddress string `json:"DownloadAddress" xml:"DownloadAddress"`
}

// CreateExportEslDevicesRequest creates a request to invoke ExportEslDevices API
func CreateExportEslDevicesRequest() (request *ExportEslDevicesRequest) {
	request = &ExportEslDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "ExportEslDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateExportEslDevicesResponse creates a response to parse from ExportEslDevices response
func CreateExportEslDevicesResponse() (response *ExportEslDevicesResponse) {
	response = &ExportEslDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
