package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLayout invokes the cloudesl.DeleteLayout API synchronously
func (client *Client) DeleteLayout(request *DeleteLayoutRequest) (response *DeleteLayoutResponse, err error) {
	response = CreateDeleteLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLayoutWithChan invokes the cloudesl.DeleteLayout API asynchronously
func (client *Client) DeleteLayoutWithChan(request *DeleteLayoutRequest) (<-chan *DeleteLayoutResponse, <-chan error) {
	responseChan := make(chan *DeleteLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLayoutWithCallback invokes the cloudesl.DeleteLayout API asynchronously
func (client *Client) DeleteLayoutWithCallback(request *DeleteLayoutRequest, callback func(response *DeleteLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLayoutResponse
		var err error
		defer close(result)
		response, err = client.DeleteLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLayoutRequest is the request struct for api DeleteLayout
type DeleteLayoutRequest struct {
	*requests.RpcRequest
	LayoutId string `position:"Body" name:"LayoutId"`
}

// DeleteLayoutResponse is the response struct for api DeleteLayout
type DeleteLayoutResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateDeleteLayoutRequest creates a request to invoke DeleteLayout API
func CreateDeleteLayoutRequest() (request *DeleteLayoutRequest) {
	request = &DeleteLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DeleteLayout", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLayoutResponse creates a response to parse from DeleteLayout response
func CreateDeleteLayoutResponse() (response *DeleteLayoutResponse) {
	response = &DeleteLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
