package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportVnStatisticalData invokes the cloudcallcenter.ExportVnStatisticalData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/exportvnstatisticaldata.html
func (client *Client) ExportVnStatisticalData(request *ExportVnStatisticalDataRequest) (response *ExportVnStatisticalDataResponse, err error) {
	response = CreateExportVnStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// ExportVnStatisticalDataWithChan invokes the cloudcallcenter.ExportVnStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/exportvnstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportVnStatisticalDataWithChan(request *ExportVnStatisticalDataRequest) (<-chan *ExportVnStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *ExportVnStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportVnStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportVnStatisticalDataWithCallback invokes the cloudcallcenter.ExportVnStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/exportvnstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportVnStatisticalDataWithCallback(request *ExportVnStatisticalDataRequest, callback func(response *ExportVnStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportVnStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.ExportVnStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportVnStatisticalDataRequest is the request struct for api ExportVnStatisticalData
type ExportVnStatisticalDataRequest struct {
	*requests.RpcRequest
	BeginTimeLeftRange  requests.Integer `position:"Query" name:"BeginTimeLeftRange"`
	ExportType          string           `position:"Query" name:"ExportType"`
	TimeUnit            string           `position:"Query" name:"TimeUnit"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	BeginTimeRightRange requests.Integer `position:"Query" name:"BeginTimeRightRange"`
}

// ExportVnStatisticalDataResponse is the response struct for api ExportVnStatisticalData
type ExportVnStatisticalDataResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ExportTaskId string `json:"ExportTaskId" xml:"ExportTaskId"`
}

// CreateExportVnStatisticalDataRequest creates a request to invoke ExportVnStatisticalData API
func CreateExportVnStatisticalDataRequest() (request *ExportVnStatisticalDataRequest) {
	request = &ExportVnStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ExportVnStatisticalData", "", "")
	request.Method = requests.GET
	return
}

// CreateExportVnStatisticalDataResponse creates a response to parse from ExportVnStatisticalData response
func CreateExportVnStatisticalDataResponse() (response *ExportVnStatisticalDataResponse) {
	response = &ExportVnStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
