package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPredictiveNameList invokes the cloudcallcenter.AddPredictiveNameList API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addpredictivenamelist.html
func (client *Client) AddPredictiveNameList(request *AddPredictiveNameListRequest) (response *AddPredictiveNameListResponse, err error) {
	response = CreateAddPredictiveNameListResponse()
	err = client.DoAction(request, response)
	return
}

// AddPredictiveNameListWithChan invokes the cloudcallcenter.AddPredictiveNameList API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addpredictivenamelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddPredictiveNameListWithChan(request *AddPredictiveNameListRequest) (<-chan *AddPredictiveNameListResponse, <-chan error) {
	responseChan := make(chan *AddPredictiveNameListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPredictiveNameList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPredictiveNameListWithCallback invokes the cloudcallcenter.AddPredictiveNameList API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addpredictivenamelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddPredictiveNameListWithCallback(request *AddPredictiveNameListRequest, callback func(response *AddPredictiveNameListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPredictiveNameListResponse
		var err error
		defer close(result)
		response, err = client.AddPredictiveNameList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPredictiveNameListRequest is the request struct for api AddPredictiveNameList
type AddPredictiveNameListRequest struct {
	*requests.RpcRequest
	Description  string    `position:"Query" name:"Description"`
	JobsJson     *[]string `position:"Body" name:"JobsJson"  type:"Repeated"`
	JobFilePath  string    `position:"Query" name:"JobFilePath"`
	InstanceId   string    `position:"Query" name:"InstanceId"`
	SkillGroupId string    `position:"Query" name:"SkillGroupId"`
	StrategyJson string    `position:"Query" name:"StrategyJson"`
	Name         string    `position:"Query" name:"Name"`
	JobGroupId   string    `position:"Query" name:"JobGroupId"`
}

// AddPredictiveNameListResponse is the response struct for api AddPredictiveNameList
type AddPredictiveNameListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAddPredictiveNameListRequest creates a request to invoke AddPredictiveNameList API
func CreateAddPredictiveNameListRequest() (request *AddPredictiveNameListRequest) {
	request = &AddPredictiveNameListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AddPredictiveNameList", "", "")
	request.Method = requests.POST
	return
}

// CreateAddPredictiveNameListResponse creates a response to parse from AddPredictiveNameList response
func CreateAddPredictiveNameListResponse() (response *AddPredictiveNameListResponse) {
	response = &AddPredictiveNameListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
