package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceDropConnections invokes the cloudapi.DescribeInstanceDropConnections API synchronously
func (client *Client) DescribeInstanceDropConnections(request *DescribeInstanceDropConnectionsRequest) (response *DescribeInstanceDropConnectionsResponse, err error) {
	response = CreateDescribeInstanceDropConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceDropConnectionsWithChan invokes the cloudapi.DescribeInstanceDropConnections API asynchronously
func (client *Client) DescribeInstanceDropConnectionsWithChan(request *DescribeInstanceDropConnectionsRequest) (<-chan *DescribeInstanceDropConnectionsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceDropConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceDropConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceDropConnectionsWithCallback invokes the cloudapi.DescribeInstanceDropConnections API asynchronously
func (client *Client) DescribeInstanceDropConnectionsWithCallback(request *DescribeInstanceDropConnectionsRequest, callback func(response *DescribeInstanceDropConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceDropConnectionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceDropConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceDropConnectionsRequest is the request struct for api DescribeInstanceDropConnections
type DescribeInstanceDropConnectionsRequest struct {
	*requests.RpcRequest
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SbcName       string `position:"Query" name:"SbcName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceDropConnectionsResponse is the response struct for api DescribeInstanceDropConnections
type DescribeInstanceDropConnectionsResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	InstanceDropConnections InstanceDropConnections `json:"InstanceDropConnections" xml:"InstanceDropConnections"`
}

// CreateDescribeInstanceDropConnectionsRequest creates a request to invoke DescribeInstanceDropConnections API
func CreateDescribeInstanceDropConnectionsRequest() (request *DescribeInstanceDropConnectionsRequest) {
	request = &DescribeInstanceDropConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceDropConnections", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceDropConnectionsResponse creates a response to parse from DescribeInstanceDropConnections response
func CreateDescribeInstanceDropConnectionsResponse() (response *DescribeInstanceDropConnectionsResponse) {
	response = &DescribeInstanceDropConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
