package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroupLatency invokes the cloudapi.DescribeGroupLatency API synchronously
func (client *Client) DescribeGroupLatency(request *DescribeGroupLatencyRequest) (response *DescribeGroupLatencyResponse, err error) {
	response = CreateDescribeGroupLatencyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupLatencyWithChan invokes the cloudapi.DescribeGroupLatency API asynchronously
func (client *Client) DescribeGroupLatencyWithChan(request *DescribeGroupLatencyRequest) (<-chan *DescribeGroupLatencyResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupLatencyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroupLatency(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupLatencyWithCallback invokes the cloudapi.DescribeGroupLatency API asynchronously
func (client *Client) DescribeGroupLatencyWithCallback(request *DescribeGroupLatencyRequest, callback func(response *DescribeGroupLatencyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupLatencyResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroupLatency(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupLatencyRequest is the request struct for api DescribeGroupLatency
type DescribeGroupLatencyRequest struct {
	*requests.RpcRequest
	StageName     string `position:"Query" name:"StageName"`
	GroupId       string `position:"Query" name:"GroupId"`
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeGroupLatencyResponse is the response struct for api DescribeGroupLatency
type DescribeGroupLatencyResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	LatencyPacket LatencyPacket `json:"LatencyPacket" xml:"LatencyPacket"`
}

// CreateDescribeGroupLatencyRequest creates a request to invoke DescribeGroupLatency API
func CreateDescribeGroupLatencyRequest() (request *DescribeGroupLatencyRequest) {
	request = &DescribeGroupLatencyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeGroupLatency", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGroupLatencyResponse creates a response to parse from DescribeGroupLatency response
func CreateDescribeGroupLatencyResponse() (response *DescribeGroupLatencyResponse) {
	response = &DescribeGroupLatencyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
