package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestoreCapacity invokes the cloud_siem.RestoreCapacity API synchronously
func (client *Client) RestoreCapacity(request *RestoreCapacityRequest) (response *RestoreCapacityResponse, err error) {
	response = CreateRestoreCapacityResponse()
	err = client.DoAction(request, response)
	return
}

// RestoreCapacityWithChan invokes the cloud_siem.RestoreCapacity API asynchronously
func (client *Client) RestoreCapacityWithChan(request *RestoreCapacityRequest) (<-chan *RestoreCapacityResponse, <-chan error) {
	responseChan := make(chan *RestoreCapacityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestoreCapacity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestoreCapacityWithCallback invokes the cloud_siem.RestoreCapacity API asynchronously
func (client *Client) RestoreCapacityWithCallback(request *RestoreCapacityRequest, callback func(response *RestoreCapacityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestoreCapacityResponse
		var err error
		defer close(result)
		response, err = client.RestoreCapacity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestoreCapacityRequest is the request struct for api RestoreCapacity
type RestoreCapacityRequest struct {
	*requests.RpcRequest
}

// RestoreCapacityResponse is the response struct for api RestoreCapacity
type RestoreCapacityResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestoreCapacityRequest creates a request to invoke RestoreCapacity API
func CreateRestoreCapacityRequest() (request *RestoreCapacityRequest) {
	request = &RestoreCapacityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "RestoreCapacity", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestoreCapacityResponse creates a response to parse from RestoreCapacity response
func CreateRestoreCapacityResponse() (response *RestoreCapacityResponse) {
	response = &RestoreCapacityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
