package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlertSourceWithEvent invokes the cloud_siem.DescribeAlertSourceWithEvent API synchronously
func (client *Client) DescribeAlertSourceWithEvent(request *DescribeAlertSourceWithEventRequest) (response *DescribeAlertSourceWithEventResponse, err error) {
	response = CreateDescribeAlertSourceWithEventResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertSourceWithEventWithChan invokes the cloud_siem.DescribeAlertSourceWithEvent API asynchronously
func (client *Client) DescribeAlertSourceWithEventWithChan(request *DescribeAlertSourceWithEventRequest) (<-chan *DescribeAlertSourceWithEventResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertSourceWithEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlertSourceWithEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertSourceWithEventWithCallback invokes the cloud_siem.DescribeAlertSourceWithEvent API asynchronously
func (client *Client) DescribeAlertSourceWithEventWithCallback(request *DescribeAlertSourceWithEventRequest, callback func(response *DescribeAlertSourceWithEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertSourceWithEventResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlertSourceWithEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertSourceWithEventRequest is the request struct for api DescribeAlertSourceWithEvent
type DescribeAlertSourceWithEventRequest struct {
	*requests.RpcRequest
	IncidentUuid string `position:"Body" name:"IncidentUuid"`
}

// DescribeAlertSourceWithEventResponse is the response struct for api DescribeAlertSourceWithEvent
type DescribeAlertSourceWithEventResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAlertSourceWithEventRequest creates a request to invoke DescribeAlertSourceWithEvent API
func CreateDescribeAlertSourceWithEventRequest() (request *DescribeAlertSourceWithEventRequest) {
	request = &DescribeAlertSourceWithEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAlertSourceWithEvent", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertSourceWithEventResponse creates a response to parse from DescribeAlertSourceWithEvent response
func CreateDescribeAlertSourceWithEventResponse() (response *DescribeAlertSourceWithEventResponse) {
	response = &DescribeAlertSourceWithEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
