package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartEditContactFlow invokes the ccc.StartEditContactFlow API synchronously
func (client *Client) StartEditContactFlow(request *StartEditContactFlowRequest) (response *StartEditContactFlowResponse, err error) {
	response = CreateStartEditContactFlowResponse()
	err = client.DoAction(request, response)
	return
}

// StartEditContactFlowWithChan invokes the ccc.StartEditContactFlow API asynchronously
func (client *Client) StartEditContactFlowWithChan(request *StartEditContactFlowRequest) (<-chan *StartEditContactFlowResponse, <-chan error) {
	responseChan := make(chan *StartEditContactFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartEditContactFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartEditContactFlowWithCallback invokes the ccc.StartEditContactFlow API asynchronously
func (client *Client) StartEditContactFlowWithCallback(request *StartEditContactFlowRequest, callback func(response *StartEditContactFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartEditContactFlowResponse
		var err error
		defer close(result)
		response, err = client.StartEditContactFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartEditContactFlowRequest is the request struct for api StartEditContactFlow
type StartEditContactFlowRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// StartEditContactFlowResponse is the response struct for api StartEditContactFlow
type StartEditContactFlowResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateStartEditContactFlowRequest creates a request to invoke StartEditContactFlow API
func CreateStartEditContactFlowRequest() (request *StartEditContactFlowRequest) {
	request = &StartEditContactFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "StartEditContactFlow", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartEditContactFlowResponse creates a response to parse from StartEditContactFlow response
func CreateStartEditContactFlowResponse() (response *StartEditContactFlowResponse) {
	response = &StartEditContactFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
