package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPhoneNumberToSkillGroups invokes the ccc.AddPhoneNumberToSkillGroups API synchronously
func (client *Client) AddPhoneNumberToSkillGroups(request *AddPhoneNumberToSkillGroupsRequest) (response *AddPhoneNumberToSkillGroupsResponse, err error) {
	response = CreateAddPhoneNumberToSkillGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// AddPhoneNumberToSkillGroupsWithChan invokes the ccc.AddPhoneNumberToSkillGroups API asynchronously
func (client *Client) AddPhoneNumberToSkillGroupsWithChan(request *AddPhoneNumberToSkillGroupsRequest) (<-chan *AddPhoneNumberToSkillGroupsResponse, <-chan error) {
	responseChan := make(chan *AddPhoneNumberToSkillGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPhoneNumberToSkillGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPhoneNumberToSkillGroupsWithCallback invokes the ccc.AddPhoneNumberToSkillGroups API asynchronously
func (client *Client) AddPhoneNumberToSkillGroupsWithCallback(request *AddPhoneNumberToSkillGroupsRequest, callback func(response *AddPhoneNumberToSkillGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPhoneNumberToSkillGroupsResponse
		var err error
		defer close(result)
		response, err = client.AddPhoneNumberToSkillGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPhoneNumberToSkillGroupsRequest is the request struct for api AddPhoneNumberToSkillGroups
type AddPhoneNumberToSkillGroupsRequest struct {
	*requests.RpcRequest
	Number           string `position:"Query" name:"Number"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SkillGroupIdList string `position:"Query" name:"SkillGroupIdList"`
}

// AddPhoneNumberToSkillGroupsResponse is the response struct for api AddPhoneNumberToSkillGroups
type AddPhoneNumberToSkillGroupsResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateAddPhoneNumberToSkillGroupsRequest creates a request to invoke AddPhoneNumberToSkillGroups API
func CreateAddPhoneNumberToSkillGroupsRequest() (request *AddPhoneNumberToSkillGroupsRequest) {
	request = &AddPhoneNumberToSkillGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AddPhoneNumberToSkillGroups", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPhoneNumberToSkillGroupsResponse creates a response to parse from AddPhoneNumberToSkillGroups response
func CreateAddPhoneNumberToSkillGroupsResponse() (response *AddPhoneNumberToSkillGroupsResponse) {
	response = &AddPhoneNumberToSkillGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
