package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterVpnAttachments invokes the cbn.ListTransitRouterVpnAttachments API synchronously
func (client *Client) ListTransitRouterVpnAttachments(request *ListTransitRouterVpnAttachmentsRequest) (response *ListTransitRouterVpnAttachmentsResponse, err error) {
	response = CreateListTransitRouterVpnAttachmentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterVpnAttachmentsWithChan invokes the cbn.ListTransitRouterVpnAttachments API asynchronously
func (client *Client) ListTransitRouterVpnAttachmentsWithChan(request *ListTransitRouterVpnAttachmentsRequest) (<-chan *ListTransitRouterVpnAttachmentsResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterVpnAttachmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterVpnAttachments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterVpnAttachmentsWithCallback invokes the cbn.ListTransitRouterVpnAttachments API asynchronously
func (client *Client) ListTransitRouterVpnAttachmentsWithCallback(request *ListTransitRouterVpnAttachmentsRequest, callback func(response *ListTransitRouterVpnAttachmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterVpnAttachmentsResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterVpnAttachments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterVpnAttachmentsRequest is the request struct for api ListTransitRouterVpnAttachments
type ListTransitRouterVpnAttachmentsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	CenId                     string                                `position:"Query" name:"CenId"`
	NextToken                 string                                `position:"Query" name:"NextToken"`
	Tag                       *[]ListTransitRouterVpnAttachmentsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount      string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string                                `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer                      `position:"Query" name:"OwnerId"`
	TransitRouterId           string                                `position:"Query" name:"TransitRouterId"`
	ResourceType              string                                `position:"Query" name:"ResourceType"`
	Version                   string                                `position:"Query" name:"Version"`
	TransitRouterAttachmentId string                                `position:"Query" name:"TransitRouterAttachmentId"`
	MaxResults                requests.Integer                      `position:"Query" name:"MaxResults"`
}

// ListTransitRouterVpnAttachmentsTag is a repeated param struct in ListTransitRouterVpnAttachmentsRequest
type ListTransitRouterVpnAttachmentsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListTransitRouterVpnAttachmentsResponse is the response struct for api ListTransitRouterVpnAttachments
type ListTransitRouterVpnAttachmentsResponse struct {
	*responses.BaseResponse
	NextToken                string                    `json:"NextToken" xml:"NextToken"`
	RequestId                string                    `json:"RequestId" xml:"RequestId"`
	TotalCount               int                       `json:"TotalCount" xml:"TotalCount"`
	MaxResults               int                       `json:"MaxResults" xml:"MaxResults"`
	TransitRouterAttachments []TransitRouterAttachment `json:"TransitRouterAttachments" xml:"TransitRouterAttachments"`
}

// CreateListTransitRouterVpnAttachmentsRequest creates a request to invoke ListTransitRouterVpnAttachments API
func CreateListTransitRouterVpnAttachmentsRequest() (request *ListTransitRouterVpnAttachmentsRequest) {
	request = &ListTransitRouterVpnAttachmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterVpnAttachments", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterVpnAttachmentsResponse creates a response to parse from ListTransitRouterVpnAttachments response
func CreateListTransitRouterVpnAttachmentsResponse() (response *ListTransitRouterVpnAttachmentsResponse) {
	response = &ListTransitRouterVpnAttachmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
