package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterVpcAttachments invokes the cbn.ListTransitRouterVpcAttachments API synchronously
func (client *Client) ListTransitRouterVpcAttachments(request *ListTransitRouterVpcAttachmentsRequest) (response *ListTransitRouterVpcAttachmentsResponse, err error) {
	response = CreateListTransitRouterVpcAttachmentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterVpcAttachmentsWithChan invokes the cbn.ListTransitRouterVpcAttachments API asynchronously
func (client *Client) ListTransitRouterVpcAttachmentsWithChan(request *ListTransitRouterVpcAttachmentsRequest) (<-chan *ListTransitRouterVpcAttachmentsResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterVpcAttachmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterVpcAttachments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterVpcAttachmentsWithCallback invokes the cbn.ListTransitRouterVpcAttachments API asynchronously
func (client *Client) ListTransitRouterVpcAttachmentsWithCallback(request *ListTransitRouterVpcAttachmentsRequest, callback func(response *ListTransitRouterVpcAttachmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterVpcAttachmentsResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterVpcAttachments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterVpcAttachmentsRequest is the request struct for api ListTransitRouterVpcAttachments
type ListTransitRouterVpcAttachmentsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	CenId                     string                                `position:"Query" name:"CenId"`
	NextToken                 string                                `position:"Query" name:"NextToken"`
	Tag                       *[]ListTransitRouterVpcAttachmentsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount      string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string                                `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer                      `position:"Query" name:"OwnerId"`
	TransitRouterId           string                                `position:"Query" name:"TransitRouterId"`
	ResourceType              string                                `position:"Query" name:"ResourceType"`
	Version                   string                                `position:"Query" name:"Version"`
	TransitRouterAttachmentId string                                `position:"Query" name:"TransitRouterAttachmentId"`
	VpcId                     string                                `position:"Query" name:"VpcId"`
	MaxResults                requests.Integer                      `position:"Query" name:"MaxResults"`
	OrderType                 string                                `position:"Query" name:"OrderType"`
	Status                    string                                `position:"Query" name:"Status"`
}

// ListTransitRouterVpcAttachmentsTag is a repeated param struct in ListTransitRouterVpcAttachmentsRequest
type ListTransitRouterVpcAttachmentsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListTransitRouterVpcAttachmentsResponse is the response struct for api ListTransitRouterVpcAttachments
type ListTransitRouterVpcAttachmentsResponse struct {
	*responses.BaseResponse
	NextToken                string                    `json:"NextToken" xml:"NextToken"`
	RequestId                string                    `json:"RequestId" xml:"RequestId"`
	TotalCount               int                       `json:"TotalCount" xml:"TotalCount"`
	MaxResults               int                       `json:"MaxResults" xml:"MaxResults"`
	TransitRouterAttachments []TransitRouterAttachment `json:"TransitRouterAttachments" xml:"TransitRouterAttachments"`
}

// CreateListTransitRouterVpcAttachmentsRequest creates a request to invoke ListTransitRouterVpcAttachments API
func CreateListTransitRouterVpcAttachmentsRequest() (request *ListTransitRouterVpcAttachmentsRequest) {
	request = &ListTransitRouterVpcAttachmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterVpcAttachments", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterVpcAttachmentsResponse creates a response to parse from ListTransitRouterVpcAttachments response
func CreateListTransitRouterVpcAttachmentsResponse() (response *ListTransitRouterVpcAttachmentsResponse) {
	response = &ListTransitRouterVpcAttachmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
