package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataCenter invokes the cassandra.DeleteDataCenter API synchronously
func (client *Client) DeleteDataCenter(request *DeleteDataCenterRequest) (response *DeleteDataCenterResponse, err error) {
	response = CreateDeleteDataCenterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataCenterWithChan invokes the cassandra.DeleteDataCenter API asynchronously
func (client *Client) DeleteDataCenterWithChan(request *DeleteDataCenterRequest) (<-chan *DeleteDataCenterResponse, <-chan error) {
	responseChan := make(chan *DeleteDataCenterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataCenter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataCenterWithCallback invokes the cassandra.DeleteDataCenter API asynchronously
func (client *Client) DeleteDataCenterWithCallback(request *DeleteDataCenterRequest, callback func(response *DeleteDataCenterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataCenterResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataCenter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataCenterRequest is the request struct for api DeleteDataCenter
type DeleteDataCenterRequest struct {
	*requests.RpcRequest
	DataCenterId string `position:"Query" name:"DataCenterId"`
	ClusterId    string `position:"Query" name:"ClusterId"`
}

// DeleteDataCenterResponse is the response struct for api DeleteDataCenter
type DeleteDataCenterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDataCenterRequest creates a request to invoke DeleteDataCenter API
func CreateDeleteDataCenterRequest() (request *DeleteDataCenterRequest) {
	request = &DeleteDataCenterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DeleteDataCenter", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDataCenterResponse creates a response to parse from DeleteDataCenter response
func CreateDeleteDataCenterResponse() (response *DeleteDataCenterResponse) {
	response = &DeleteDataCenterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
