package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProductAmortizedCostByAmortizationPeriod invokes the bssopenapi.DescribeProductAmortizedCostByAmortizationPeriod API synchronously
func (client *Client) DescribeProductAmortizedCostByAmortizationPeriod(request *DescribeProductAmortizedCostByAmortizationPeriodRequest) (response *DescribeProductAmortizedCostByAmortizationPeriodResponse, err error) {
	response = CreateDescribeProductAmortizedCostByAmortizationPeriodResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProductAmortizedCostByAmortizationPeriodWithChan invokes the bssopenapi.DescribeProductAmortizedCostByAmortizationPeriod API asynchronously
func (client *Client) DescribeProductAmortizedCostByAmortizationPeriodWithChan(request *DescribeProductAmortizedCostByAmortizationPeriodRequest) (<-chan *DescribeProductAmortizedCostByAmortizationPeriodResponse, <-chan error) {
	responseChan := make(chan *DescribeProductAmortizedCostByAmortizationPeriodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProductAmortizedCostByAmortizationPeriod(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProductAmortizedCostByAmortizationPeriodWithCallback invokes the bssopenapi.DescribeProductAmortizedCostByAmortizationPeriod API asynchronously
func (client *Client) DescribeProductAmortizedCostByAmortizationPeriodWithCallback(request *DescribeProductAmortizedCostByAmortizationPeriodRequest, callback func(response *DescribeProductAmortizedCostByAmortizationPeriodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProductAmortizedCostByAmortizationPeriodResponse
		var err error
		defer close(result)
		response, err = client.DescribeProductAmortizedCostByAmortizationPeriod(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProductAmortizedCostByAmortizationPeriodRequest is the request struct for api DescribeProductAmortizedCostByAmortizationPeriod
type DescribeProductAmortizedCostByAmortizationPeriodRequest struct {
	*requests.RpcRequest
	ProductDetail       string           `position:"Body" name:"ProductDetail"`
	ProductCode         string           `position:"Body" name:"ProductCode"`
	BillOwnerIdList     *[]string        `position:"Body" name:"BillOwnerIdList"  type:"Repeated"`
	SubscriptionType    string           `position:"Body" name:"SubscriptionType"`
	BillingCycle        string           `position:"Body" name:"BillingCycle"`
	CostUnitCode        string           `position:"Body" name:"CostUnitCode"`
	ConsumePeriodFilter *[]string        `position:"Body" name:"ConsumePeriodFilter"  type:"Repeated"`
	NextToken           string           `position:"Body" name:"NextToken"`
	BillUserIdList      *[]string        `position:"Body" name:"BillUserIdList"  type:"Repeated"`
	MaxResults          requests.Integer `position:"Body" name:"MaxResults"`
}

// DescribeProductAmortizedCostByAmortizationPeriodResponse is the response struct for api DescribeProductAmortizedCostByAmortizationPeriod
type DescribeProductAmortizedCostByAmortizationPeriodResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeProductAmortizedCostByAmortizationPeriodRequest creates a request to invoke DescribeProductAmortizedCostByAmortizationPeriod API
func CreateDescribeProductAmortizedCostByAmortizationPeriodRequest() (request *DescribeProductAmortizedCostByAmortizationPeriodRequest) {
	request = &DescribeProductAmortizedCostByAmortizationPeriodRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeProductAmortizedCostByAmortizationPeriod", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProductAmortizedCostByAmortizationPeriodResponse creates a response to parse from DescribeProductAmortizedCostByAmortizationPeriod response
func CreateDescribeProductAmortizedCostByAmortizationPeriodResponse() (response *DescribeProductAmortizedCostByAmortizationPeriodResponse) {
	response = &DescribeProductAmortizedCostByAmortizationPeriodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
