package bpstudio

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplication invokes the bpstudio.ListApplication API synchronously
func (client *Client) ListApplication(request *ListApplicationRequest) (response *ListApplicationResponse, err error) {
	response = CreateListApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationWithChan invokes the bpstudio.ListApplication API asynchronously
func (client *Client) ListApplicationWithChan(request *ListApplicationRequest) (<-chan *ListApplicationResponse, <-chan error) {
	responseChan := make(chan *ListApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationWithCallback invokes the bpstudio.ListApplication API asynchronously
func (client *Client) ListApplicationWithCallback(request *ListApplicationRequest, callback func(response *ListApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationResponse
		var err error
		defer close(result)
		response, err = client.ListApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationRequest is the request struct for api ListApplication
type ListApplicationRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	NextToken       requests.Integer `position:"Body" name:"NextToken"`
	MaxResults      requests.Integer `position:"Body" name:"MaxResults"`
	Keyword         string           `position:"Body" name:"Keyword"`
	OrderType       requests.Integer `position:"Body" name:"OrderType"`
	Status          string           `position:"Body" name:"Status"`
}

// ListApplicationResponse is the response struct for api ListApplication
type ListApplicationResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Message    string `json:"Message" xml:"Message"`
	NextToken  int    `json:"NextToken" xml:"NextToken"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Code       int    `json:"Code" xml:"Code"`
	Data       []Item `json:"Data" xml:"Data"`
}

// CreateListApplicationRequest creates a request to invoke ListApplication API
func CreateListApplicationRequest() (request *ListApplicationRequest) {
	request = &ListApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BPStudio", "2021-09-31", "ListApplication", "bpstudio", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListApplicationResponse creates a response to parse from ListApplication response
func CreateListApplicationResponse() (response *ListApplicationResponse) {
	response = &ListApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
