package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorIp invokes the beian.QueryAccessorIp API synchronously
func (client *Client) QueryAccessorIp(request *QueryAccessorIpRequest) (response *QueryAccessorIpResponse, err error) {
	response = CreateQueryAccessorIpResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorIpWithChan invokes the beian.QueryAccessorIp API asynchronously
func (client *Client) QueryAccessorIpWithChan(request *QueryAccessorIpRequest) (<-chan *QueryAccessorIpResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorIpWithCallback invokes the beian.QueryAccessorIp API asynchronously
func (client *Client) QueryAccessorIpWithCallback(request *QueryAccessorIpRequest, callback func(response *QueryAccessorIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorIpResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorIpRequest is the request struct for api QueryAccessorIp
type QueryAccessorIpRequest struct {
	*requests.RpcRequest
	Ip     string `position:"Query" name:"Ip"`
	Caller string `position:"Query" name:"Caller"`
}

// QueryAccessorIpResponse is the response struct for api QueryAccessorIp
type QueryAccessorIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateQueryAccessorIpRequest creates a request to invoke QueryAccessorIp API
func CreateQueryAccessorIpRequest() (request *QueryAccessorIpRequest) {
	request = &QueryAccessorIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorIp", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorIpResponse creates a response to parse from QueryAccessorIp response
func CreateQueryAccessorIpResponse() (response *QueryAccessorIpResponse) {
	response = &QueryAccessorIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
