package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DuplexDecision invokes the avatar.DuplexDecision API synchronously
func (client *Client) DuplexDecision(request *DuplexDecisionRequest) (response *DuplexDecisionResponse, err error) {
	response = CreateDuplexDecisionResponse()
	err = client.DoAction(request, response)
	return
}

// DuplexDecisionWithChan invokes the avatar.DuplexDecision API asynchronously
func (client *Client) DuplexDecisionWithChan(request *DuplexDecisionRequest) (<-chan *DuplexDecisionResponse, <-chan error) {
	responseChan := make(chan *DuplexDecisionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DuplexDecision(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DuplexDecisionWithCallback invokes the avatar.DuplexDecision API asynchronously
func (client *Client) DuplexDecisionWithCallback(request *DuplexDecisionRequest, callback func(response *DuplexDecisionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DuplexDecisionResponse
		var err error
		defer close(result)
		response, err = client.DuplexDecision(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DuplexDecisionRequest is the request struct for api DuplexDecision
type DuplexDecisionRequest struct {
	*requests.RpcRequest
	InterruptType  requests.Integer            `position:"Query" name:"InterruptType"`
	CustomKeywords *[]string                   `position:"Query" name:"CustomKeywords"  type:"Json"`
	SessionId      string                      `position:"Query" name:"SessionId"`
	DialogStatus   string                      `position:"Query" name:"DialogStatus"`
	DialogContext  DuplexDecisionDialogContext `position:"Query" name:"DialogContext"  type:"Struct"`
	CallTime       requests.Integer            `position:"Query" name:"CallTime"`
	AppId          string                      `position:"Query" name:"AppId"`
	TenantId       requests.Integer            `position:"Query" name:"TenantId"`
	Text           string                      `position:"Query" name:"Text"`
	BizRequestId   string                      `position:"Query" name:"BizRequestId"`
}

// DuplexDecisionDialogContext is a repeated param struct in DuplexDecisionRequest
type DuplexDecisionDialogContext struct {
	Histories       *[]DuplexDecisionDialogContextHistoriesItem `name:"Histories" type:"Repeated"`
	CurUtteranceIdx string                                      `name:"CurUtteranceIdx"`
}

// DuplexDecisionDialogContextHistoriesItem is a repeated param struct in DuplexDecisionRequest
type DuplexDecisionDialogContextHistoriesItem struct {
	Robot string `name:"Robot"`
	User  string `name:"User"`
}

// DuplexDecisionResponse is the response struct for api DuplexDecision
type DuplexDecisionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDuplexDecisionRequest creates a request to invoke DuplexDecision API
func CreateDuplexDecisionRequest() (request *DuplexDecisionRequest) {
	request = &DuplexDecisionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "DuplexDecision", "", "")
	request.Method = requests.POST
	return
}

// CreateDuplexDecisionResponse creates a response to parse from DuplexDecision response
func CreateDuplexDecisionResponse() (response *DuplexDecisionResponse) {
	response = &DuplexDecisionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
