package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPrometheusInstance invokes the arms.GetPrometheusInstance API synchronously
func (client *Client) GetPrometheusInstance(request *GetPrometheusInstanceRequest) (response *GetPrometheusInstanceResponse, err error) {
	response = CreateGetPrometheusInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetPrometheusInstanceWithChan invokes the arms.GetPrometheusInstance API asynchronously
func (client *Client) GetPrometheusInstanceWithChan(request *GetPrometheusInstanceRequest) (<-chan *GetPrometheusInstanceResponse, <-chan error) {
	responseChan := make(chan *GetPrometheusInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPrometheusInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPrometheusInstanceWithCallback invokes the arms.GetPrometheusInstance API asynchronously
func (client *Client) GetPrometheusInstanceWithCallback(request *GetPrometheusInstanceRequest, callback func(response *GetPrometheusInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPrometheusInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetPrometheusInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPrometheusInstanceRequest is the request struct for api GetPrometheusInstance
type GetPrometheusInstanceRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetPrometheusInstanceResponse is the response struct for api GetPrometheusInstance
type GetPrometheusInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetPrometheusInstanceRequest creates a request to invoke GetPrometheusInstance API
func CreateGetPrometheusInstanceRequest() (request *GetPrometheusInstanceRequest) {
	request = &GetPrometheusInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetPrometheusInstance", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPrometheusInstanceResponse creates a response to parse from GetPrometheusInstance response
func CreateGetPrometheusInstanceResponse() (response *GetPrometheusInstanceResponse) {
	response = &GetPrometheusInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
