package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCmsExporter invokes the arms.DeleteCmsExporter API synchronously
func (client *Client) DeleteCmsExporter(request *DeleteCmsExporterRequest) (response *DeleteCmsExporterResponse, err error) {
	response = CreateDeleteCmsExporterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCmsExporterWithChan invokes the arms.DeleteCmsExporter API asynchronously
func (client *Client) DeleteCmsExporterWithChan(request *DeleteCmsExporterRequest) (<-chan *DeleteCmsExporterResponse, <-chan error) {
	responseChan := make(chan *DeleteCmsExporterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCmsExporter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCmsExporterWithCallback invokes the arms.DeleteCmsExporter API asynchronously
func (client *Client) DeleteCmsExporterWithCallback(request *DeleteCmsExporterRequest, callback func(response *DeleteCmsExporterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCmsExporterResponse
		var err error
		defer close(result)
		response, err = client.DeleteCmsExporter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCmsExporterRequest is the request struct for api DeleteCmsExporter
type DeleteCmsExporterRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DeleteCmsExporterResponse is the response struct for api DeleteCmsExporter
type DeleteCmsExporterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteCmsExporterRequest creates a request to invoke DeleteCmsExporter API
func CreateDeleteCmsExporterRequest() (request *DeleteCmsExporterRequest) {
	request = &DeleteCmsExporterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteCmsExporter", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCmsExporterResponse creates a response to parse from DeleteCmsExporter response
func CreateDeleteCmsExporterResponse() (response *DeleteCmsExporterResponse) {
	response = &DeleteCmsExporterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
