package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestParam invokes the amp.TestParam API synchronously
func (client *Client) TestParam(request *TestParamRequest) (response *TestParamResponse, err error) {
	response = CreateTestParamResponse()
	err = client.DoAction(request, response)
	return
}

// TestParamWithChan invokes the amp.TestParam API asynchronously
func (client *Client) TestParamWithChan(request *TestParamRequest) (<-chan *TestParamResponse, <-chan error) {
	responseChan := make(chan *TestParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestParamWithCallback invokes the amp.TestParam API asynchronously
func (client *Client) TestParamWithCallback(request *TestParamRequest, callback func(response *TestParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestParamResponse
		var err error
		defer close(result)
		response, err = client.TestParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestParamRequest is the request struct for api TestParam
type TestParamRequest struct {
	*requests.RoaRequest
	Param string `position:"Query" name:"Param"`
}

// TestParamResponse is the response struct for api TestParam
type TestParamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateTestParamRequest creates a request to invoke TestParam API
func CreateTestParamRequest() (request *TestParamRequest) {
	request = &TestParamRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "TestParam", "/test/param", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestParamResponse creates a response to parse from TestParam response
func CreateTestParamResponse() (response *TestParamResponse) {
	response = &TestParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
