package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAPI invokes the amp.CreateAPI API synchronously
func (client *Client) CreateAPI(request *CreateAPIRequest) (response *CreateAPIResponse, err error) {
	response = CreateCreateAPIResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAPIWithChan invokes the amp.CreateAPI API asynchronously
func (client *Client) CreateAPIWithChan(request *CreateAPIRequest) (<-chan *CreateAPIResponse, <-chan error) {
	responseChan := make(chan *CreateAPIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAPI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAPIWithCallback invokes the amp.CreateAPI API asynchronously
func (client *Client) CreateAPIWithCallback(request *CreateAPIRequest, callback func(response *CreateAPIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAPIResponse
		var err error
		defer close(result)
		response, err = client.CreateAPI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAPIRequest is the request struct for api CreateAPI
type CreateAPIRequest struct {
	*requests.RoaRequest
	CustomizeConfig string `position:"Body" name:"customize_config"`
}

// CreateAPIResponse is the response struct for api CreateAPI
type CreateAPIResponse struct {
	*responses.BaseResponse
	IntanceId string `json:"IntanceId" xml:"IntanceId"`
}

// CreateCreateAPIRequest creates a request to invoke CreateAPI API
func CreateCreateAPIRequest() (request *CreateAPIRequest) {
	request = &CreateAPIRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "CreateAPI", "/[acd]", "ServiceCode", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateAPIResponse creates a response to parse from CreateAPI response
func CreateCreateAPIResponse() (response *CreateAPIResponse) {
	response = &CreateAPIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
