package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWsCustomizedSeaGeneral invokes the alinlp.GetWsCustomizedSeaGeneral API synchronously
func (client *Client) GetWsCustomizedSeaGeneral(request *GetWsCustomizedSeaGeneralRequest) (response *GetWsCustomizedSeaGeneralResponse, err error) {
	response = CreateGetWsCustomizedSeaGeneralResponse()
	err = client.DoAction(request, response)
	return
}

// GetWsCustomizedSeaGeneralWithChan invokes the alinlp.GetWsCustomizedSeaGeneral API asynchronously
func (client *Client) GetWsCustomizedSeaGeneralWithChan(request *GetWsCustomizedSeaGeneralRequest) (<-chan *GetWsCustomizedSeaGeneralResponse, <-chan error) {
	responseChan := make(chan *GetWsCustomizedSeaGeneralResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWsCustomizedSeaGeneral(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWsCustomizedSeaGeneralWithCallback invokes the alinlp.GetWsCustomizedSeaGeneral API asynchronously
func (client *Client) GetWsCustomizedSeaGeneralWithCallback(request *GetWsCustomizedSeaGeneralRequest, callback func(response *GetWsCustomizedSeaGeneralResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWsCustomizedSeaGeneralResponse
		var err error
		defer close(result)
		response, err = client.GetWsCustomizedSeaGeneral(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWsCustomizedSeaGeneralRequest is the request struct for api GetWsCustomizedSeaGeneral
type GetWsCustomizedSeaGeneralRequest struct {
	*requests.RpcRequest
	Language    string `position:"Body" name:"Language"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetWsCustomizedSeaGeneralResponse is the response struct for api GetWsCustomizedSeaGeneral
type GetWsCustomizedSeaGeneralResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWsCustomizedSeaGeneralRequest creates a request to invoke GetWsCustomizedSeaGeneral API
func CreateGetWsCustomizedSeaGeneralRequest() (request *GetWsCustomizedSeaGeneralRequest) {
	request = &GetWsCustomizedSeaGeneralRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWsCustomizedSeaGeneral", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWsCustomizedSeaGeneralResponse creates a response to parse from GetWsCustomizedSeaGeneral response
func CreateGetWsCustomizedSeaGeneralResponse() (response *GetWsCustomizedSeaGeneralResponse) {
	response = &GetWsCustomizedSeaGeneralResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
