package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSaSeaEcom invokes the alinlp.GetSaSeaEcom API synchronously
func (client *Client) GetSaSeaEcom(request *GetSaSeaEcomRequest) (response *GetSaSeaEcomResponse, err error) {
	response = CreateGetSaSeaEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetSaSeaEcomWithChan invokes the alinlp.GetSaSeaEcom API asynchronously
func (client *Client) GetSaSeaEcomWithChan(request *GetSaSeaEcomRequest) (<-chan *GetSaSeaEcomResponse, <-chan error) {
	responseChan := make(chan *GetSaSeaEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSaSeaEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSaSeaEcomWithCallback invokes the alinlp.GetSaSeaEcom API asynchronously
func (client *Client) GetSaSeaEcomWithCallback(request *GetSaSeaEcomRequest, callback func(response *GetSaSeaEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSaSeaEcomResponse
		var err error
		defer close(result)
		response, err = client.GetSaSeaEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSaSeaEcomRequest is the request struct for api GetSaSeaEcom
type GetSaSeaEcomRequest struct {
	*requests.RpcRequest
	Language    string `position:"Body" name:"Language"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetSaSeaEcomResponse is the response struct for api GetSaSeaEcom
type GetSaSeaEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetSaSeaEcomRequest creates a request to invoke GetSaSeaEcom API
func CreateGetSaSeaEcomRequest() (request *GetSaSeaEcomRequest) {
	request = &GetSaSeaEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetSaSeaEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSaSeaEcomResponse creates a response to parse from GetSaSeaEcom response
func CreateGetSaSeaEcomResponse() (response *GetSaSeaEcomResponse) {
	response = &GetSaSeaEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
