package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAclEntries invokes the alb.ListAclEntries API synchronously
func (client *Client) ListAclEntries(request *ListAclEntriesRequest) (response *ListAclEntriesResponse, err error) {
	response = CreateListAclEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAclEntriesWithChan invokes the alb.ListAclEntries API asynchronously
func (client *Client) ListAclEntriesWithChan(request *ListAclEntriesRequest) (<-chan *ListAclEntriesResponse, <-chan error) {
	responseChan := make(chan *ListAclEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAclEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAclEntriesWithCallback invokes the alb.ListAclEntries API asynchronously
func (client *Client) ListAclEntriesWithCallback(request *ListAclEntriesRequest, callback func(response *ListAclEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAclEntriesResponse
		var err error
		defer close(result)
		response, err = client.ListAclEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAclEntriesRequest is the request struct for api ListAclEntries
type ListAclEntriesRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	AclId      string           `position:"Query" name:"AclId"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAclEntriesResponse is the response struct for api ListAclEntries
type ListAclEntriesResponse struct {
	*responses.BaseResponse
	MaxResults int        `json:"MaxResults" xml:"MaxResults"`
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	AclEntries []AclEntry `json:"AclEntries" xml:"AclEntries"`
}

// CreateListAclEntriesRequest creates a request to invoke ListAclEntries API
func CreateListAclEntriesRequest() (request *ListAclEntriesRequest) {
	request = &ListAclEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListAclEntries", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAclEntriesResponse creates a response to parse from ListAclEntries response
func CreateListAclEntriesResponse() (response *ListAclEntriesResponse) {
	response = &ListAclEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
