package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteListener invokes the alb.DeleteListener API synchronously
func (client *Client) DeleteListener(request *DeleteListenerRequest) (response *DeleteListenerResponse, err error) {
	response = CreateDeleteListenerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteListenerWithChan invokes the alb.DeleteListener API asynchronously
func (client *Client) DeleteListenerWithChan(request *DeleteListenerRequest) (<-chan *DeleteListenerResponse, <-chan error) {
	responseChan := make(chan *DeleteListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteListenerWithCallback invokes the alb.DeleteListener API asynchronously
func (client *Client) DeleteListenerWithCallback(request *DeleteListenerRequest, callback func(response *DeleteListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteListenerResponse
		var err error
		defer close(result)
		response, err = client.DeleteListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteListenerRequest is the request struct for api DeleteListener
type DeleteListenerRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	ListenerId  string           `position:"Query" name:"ListenerId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
}

// DeleteListenerResponse is the response struct for api DeleteListener
type DeleteListenerResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteListenerRequest creates a request to invoke DeleteListener API
func CreateDeleteListenerRequest() (request *DeleteListenerRequest) {
	request = &DeleteListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "DeleteListener", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteListenerResponse creates a response to parse from DeleteListener response
func CreateDeleteListenerResponse() (response *DeleteListenerResponse) {
	response = &DeleteListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
