package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSceneItems invokes the airec.ListSceneItems API synchronously
func (client *Client) ListSceneItems(request *ListSceneItemsRequest) (response *ListSceneItemsResponse, err error) {
	response = CreateListSceneItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSceneItemsWithChan invokes the airec.ListSceneItems API asynchronously
func (client *Client) ListSceneItemsWithChan(request *ListSceneItemsRequest) (<-chan *ListSceneItemsResponse, <-chan error) {
	responseChan := make(chan *ListSceneItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSceneItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSceneItemsWithCallback invokes the airec.ListSceneItems API asynchronously
func (client *Client) ListSceneItemsWithCallback(request *ListSceneItemsRequest, callback func(response *ListSceneItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSceneItemsResponse
		var err error
		defer close(result)
		response, err = client.ListSceneItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSceneItemsRequest is the request struct for api ListSceneItems
type ListSceneItemsRequest struct {
	*requests.RoaRequest
	SelectionRuleId string           `position:"Query" name:"selectionRuleId"`
	InstanceId      string           `position:"Path" name:"instanceId"`
	Size            requests.Integer `position:"Query" name:"size"`
	QueryCount      requests.Integer `position:"Query" name:"queryCount"`
	SceneId         string           `position:"Path" name:"sceneId"`
	OperationRuleId string           `position:"Query" name:"operationRuleId"`
	PreviewType     string           `position:"Query" name:"previewType"`
	Page            requests.Integer `position:"Query" name:"page"`
}

// ListSceneItemsResponse is the response struct for api ListSceneItems
type ListSceneItemsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"requestId" xml:"requestId"`
	Code      string                 `json:"code" xml:"code"`
	Message   string                 `json:"message" xml:"message"`
	Result    ResultInListSceneItems `json:"result" xml:"result"`
}

// CreateListSceneItemsRequest creates a request to invoke ListSceneItems API
func CreateListSceneItemsRequest() (request *ListSceneItemsRequest) {
	request = &ListSceneItemsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListSceneItems", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/items", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSceneItemsResponse creates a response to parse from ListSceneItems response
func CreateListSceneItemsResponse() (response *ListSceneItemsResponse) {
	response = &ListSceneItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
