package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFilteringAlgorithm invokes the airec.DescribeFilteringAlgorithm API synchronously
func (client *Client) DescribeFilteringAlgorithm(request *DescribeFilteringAlgorithmRequest) (response *DescribeFilteringAlgorithmResponse, err error) {
	response = CreateDescribeFilteringAlgorithmResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFilteringAlgorithmWithChan invokes the airec.DescribeFilteringAlgorithm API asynchronously
func (client *Client) DescribeFilteringAlgorithmWithChan(request *DescribeFilteringAlgorithmRequest) (<-chan *DescribeFilteringAlgorithmResponse, <-chan error) {
	responseChan := make(chan *DescribeFilteringAlgorithmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFilteringAlgorithm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFilteringAlgorithmWithCallback invokes the airec.DescribeFilteringAlgorithm API asynchronously
func (client *Client) DescribeFilteringAlgorithmWithCallback(request *DescribeFilteringAlgorithmRequest, callback func(response *DescribeFilteringAlgorithmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFilteringAlgorithmResponse
		var err error
		defer close(result)
		response, err = client.DescribeFilteringAlgorithm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFilteringAlgorithmRequest is the request struct for api DescribeFilteringAlgorithm
type DescribeFilteringAlgorithmRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"instanceId"`
	AlgorithmId string `position:"Path" name:"algorithmId"`
}

// DescribeFilteringAlgorithmResponse is the response struct for api DescribeFilteringAlgorithm
type DescribeFilteringAlgorithmResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"requestId" xml:"requestId"`
	Result    ResultInDescribeFilteringAlgorithm `json:"result" xml:"result"`
}

// CreateDescribeFilteringAlgorithmRequest creates a request to invoke DescribeFilteringAlgorithm API
func CreateDescribeFilteringAlgorithmRequest() (request *DescribeFilteringAlgorithmRequest) {
	request = &DescribeFilteringAlgorithmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeFilteringAlgorithm", "/v2/openapi/instances/[instanceId]/filtering-algorithms/[algorithmId]", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeFilteringAlgorithmResponse creates a response to parse from DescribeFilteringAlgorithm response
func CreateDescribeFilteringAlgorithmResponse() (response *DescribeFilteringAlgorithmResponse) {
	response = &DescribeFilteringAlgorithmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
