package aigen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateCosplayImage invokes the aigen.GenerateCosplayImage API synchronously
func (client *Client) GenerateCosplayImage(request *GenerateCosplayImageRequest) (response *GenerateCosplayImageResponse, err error) {
	response = CreateGenerateCosplayImageResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateCosplayImageWithChan invokes the aigen.GenerateCosplayImage API asynchronously
func (client *Client) GenerateCosplayImageWithChan(request *GenerateCosplayImageRequest) (<-chan *GenerateCosplayImageResponse, <-chan error) {
	responseChan := make(chan *GenerateCosplayImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateCosplayImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateCosplayImageWithCallback invokes the aigen.GenerateCosplayImage API asynchronously
func (client *Client) GenerateCosplayImageWithCallback(request *GenerateCosplayImageRequest, callback func(response *GenerateCosplayImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateCosplayImageResponse
		var err error
		defer close(result)
		response, err = client.GenerateCosplayImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateCosplayImageRequest is the request struct for api GenerateCosplayImage
type GenerateCosplayImageRequest struct {
	*requests.RpcRequest
	TemplateImageUrl string           `position:"Body" name:"TemplateImageUrl"`
	FaceImageUrl     string           `position:"Body" name:"FaceImageUrl"`
	Async            requests.Boolean `position:"Body" name:"Async"`
	Style            requests.Integer `position:"Body" name:"Style"`
}

// GenerateCosplayImageResponse is the response struct for api GenerateCosplayImage
type GenerateCosplayImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateCosplayImageRequest creates a request to invoke GenerateCosplayImage API
func CreateGenerateCosplayImageRequest() (request *GenerateCosplayImageRequest) {
	request = &GenerateCosplayImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aigen", "2024-01-11", "GenerateCosplayImage", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateCosplayImageResponse creates a response to parse from GenerateCosplayImage response
func CreateGenerateCosplayImageResponse() (response *GenerateCosplayImageResponse) {
	response = &GenerateCosplayImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
