package aicontent

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Personalizedtxt2imgQueryImageAsset invokes the aicontent.Personalizedtxt2imgQueryImageAsset API synchronously
func (client *Client) Personalizedtxt2imgQueryImageAsset(request *Personalizedtxt2imgQueryImageAssetRequest) (response *Personalizedtxt2imgQueryImageAssetResponse, err error) {
	response = CreatePersonalizedtxt2imgQueryImageAssetResponse()
	err = client.DoAction(request, response)
	return
}

// Personalizedtxt2imgQueryImageAssetWithChan invokes the aicontent.Personalizedtxt2imgQueryImageAsset API asynchronously
func (client *Client) Personalizedtxt2imgQueryImageAssetWithChan(request *Personalizedtxt2imgQueryImageAssetRequest) (<-chan *Personalizedtxt2imgQueryImageAssetResponse, <-chan error) {
	responseChan := make(chan *Personalizedtxt2imgQueryImageAssetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Personalizedtxt2imgQueryImageAsset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Personalizedtxt2imgQueryImageAssetWithCallback invokes the aicontent.Personalizedtxt2imgQueryImageAsset API asynchronously
func (client *Client) Personalizedtxt2imgQueryImageAssetWithCallback(request *Personalizedtxt2imgQueryImageAssetRequest, callback func(response *Personalizedtxt2imgQueryImageAssetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Personalizedtxt2imgQueryImageAssetResponse
		var err error
		defer close(result)
		response, err = client.Personalizedtxt2imgQueryImageAsset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Personalizedtxt2imgQueryImageAssetRequest is the request struct for api Personalizedtxt2imgQueryImageAsset
type Personalizedtxt2imgQueryImageAssetRequest struct {
	*requests.RoaRequest
	ImageId      string `position:"Query" name:"imageId"`
	ModelId      string `position:"Query" name:"modelId"`
	EncodeFormat string `position:"Query" name:"encodeFormat"`
	PromptId     string `position:"Query" name:"promptId"`
}

// Personalizedtxt2imgQueryImageAssetResponse is the response struct for api Personalizedtxt2imgQueryImageAsset
type Personalizedtxt2imgQueryImageAssetResponse struct {
	*responses.BaseResponse
}

// CreatePersonalizedtxt2imgQueryImageAssetRequest creates a request to invoke Personalizedtxt2imgQueryImageAsset API
func CreatePersonalizedtxt2imgQueryImageAssetRequest() (request *Personalizedtxt2imgQueryImageAssetRequest) {
	request = &Personalizedtxt2imgQueryImageAssetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AiContent", "20240611", "Personalizedtxt2imgQueryImageAsset", "/api/v1/personalizedtxt2img/queryImageAsset", "", "")
	request.Method = requests.GET
	return
}

// CreatePersonalizedtxt2imgQueryImageAssetResponse creates a response to parse from Personalizedtxt2imgQueryImageAsset response
func CreatePersonalizedtxt2imgQueryImageAssetResponse() (response *Personalizedtxt2imgQueryImageAssetResponse) {
	response = &Personalizedtxt2imgQueryImageAssetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
