package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateExperimentBasicInfo invokes the ahas_openapi.UpdateExperimentBasicInfo API synchronously
func (client *Client) UpdateExperimentBasicInfo(request *UpdateExperimentBasicInfoRequest) (response *UpdateExperimentBasicInfoResponse, err error) {
	response = CreateUpdateExperimentBasicInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateExperimentBasicInfoWithChan invokes the ahas_openapi.UpdateExperimentBasicInfo API asynchronously
func (client *Client) UpdateExperimentBasicInfoWithChan(request *UpdateExperimentBasicInfoRequest) (<-chan *UpdateExperimentBasicInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateExperimentBasicInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateExperimentBasicInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateExperimentBasicInfoWithCallback invokes the ahas_openapi.UpdateExperimentBasicInfo API asynchronously
func (client *Client) UpdateExperimentBasicInfoWithCallback(request *UpdateExperimentBasicInfoRequest, callback func(response *UpdateExperimentBasicInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateExperimentBasicInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateExperimentBasicInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateExperimentBasicInfoRequest is the request struct for api UpdateExperimentBasicInfo
type UpdateExperimentBasicInfoRequest struct {
	*requests.RpcRequest
	Description  string    `position:"Query" name:"Description"`
	AhasRegionId string    `position:"Query" name:"AhasRegionId"`
	Tags         *[]string `position:"Query" name:"Tags"  type:"Repeated"`
	NameSpace    string    `position:"Query" name:"NameSpace"`
	Name         string    `position:"Query" name:"Name"`
	ExperimentId string    `position:"Query" name:"ExperimentId"`
}

// UpdateExperimentBasicInfoResponse is the response struct for api UpdateExperimentBasicInfo
type UpdateExperimentBasicInfoResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateExperimentBasicInfoRequest creates a request to invoke UpdateExperimentBasicInfo API
func CreateUpdateExperimentBasicInfoRequest() (request *UpdateExperimentBasicInfoRequest) {
	request = &UpdateExperimentBasicInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "UpdateExperimentBasicInfo", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateExperimentBasicInfoResponse creates a response to parse from UpdateExperimentBasicInfo response
func CreateUpdateExperimentBasicInfoResponse() (response *UpdateExperimentBasicInfoResponse) {
	response = &UpdateExperimentBasicInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
