package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateExperiment invokes the ahas_openapi.UpdateExperiment API synchronously
func (client *Client) UpdateExperiment(request *UpdateExperimentRequest) (response *UpdateExperimentResponse, err error) {
	response = CreateUpdateExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateExperimentWithChan invokes the ahas_openapi.UpdateExperiment API asynchronously
func (client *Client) UpdateExperimentWithChan(request *UpdateExperimentRequest) (<-chan *UpdateExperimentResponse, <-chan error) {
	responseChan := make(chan *UpdateExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateExperimentWithCallback invokes the ahas_openapi.UpdateExperiment API asynchronously
func (client *Client) UpdateExperimentWithCallback(request *UpdateExperimentRequest, callback func(response *UpdateExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateExperimentResponse
		var err error
		defer close(result)
		response, err = client.UpdateExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateExperimentRequest is the request struct for api UpdateExperiment
type UpdateExperimentRequest struct {
	*requests.RpcRequest
	Description  string    `position:"Query" name:"Description"`
	AhasRegionId string    `position:"Query" name:"AhasRegionId"`
	Tags         *[]string `position:"Query" name:"Tags"  type:"Repeated"`
	Name         string    `position:"Query" name:"Name"`
	NameSpace    string    `position:"Query" name:"NameSpace"`
	Definition   string    `position:"Query" name:"Definition"`
	ExperimentId string    `position:"Query" name:"ExperimentId"`
}

// UpdateExperimentResponse is the response struct for api UpdateExperiment
type UpdateExperimentResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateExperimentRequest creates a request to invoke UpdateExperiment API
func CreateUpdateExperimentRequest() (request *UpdateExperimentRequest) {
	request = &UpdateExperimentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "UpdateExperiment", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateExperimentResponse creates a response to parse from UpdateExperiment response
func CreateUpdateExperimentResponse() (response *UpdateExperimentResponse) {
	response = &UpdateExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
