package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrderInfo invokes the afs.DescribeOrderInfo API synchronously
// api document: https://help.aliyun.com/api/afs/describeorderinfo.html
func (client *Client) DescribeOrderInfo(request *DescribeOrderInfoRequest) (response *DescribeOrderInfoResponse, err error) {
	response = CreateDescribeOrderInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrderInfoWithChan invokes the afs.DescribeOrderInfo API asynchronously
// api document: https://help.aliyun.com/api/afs/describeorderinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrderInfoWithChan(request *DescribeOrderInfoRequest) (<-chan *DescribeOrderInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeOrderInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrderInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrderInfoWithCallback invokes the afs.DescribeOrderInfo API asynchronously
// api document: https://help.aliyun.com/api/afs/describeorderinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrderInfoWithCallback(request *DescribeOrderInfoRequest, callback func(response *DescribeOrderInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrderInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrderInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrderInfoRequest is the request struct for api DescribeOrderInfo
type DescribeOrderInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeOrderInfoResponse is the response struct for api DescribeOrderInfo
type DescribeOrderInfoResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	BizCode    string `json:"BizCode" xml:"BizCode"`
	OrderLevel string `json:"OrderLevel" xml:"OrderLevel"`
	Num        string `json:"Num" xml:"Num"`
	BeginDate  string `json:"BeginDate" xml:"BeginDate"`
	EndDate    string `json:"EndDate" xml:"EndDate"`
}

// CreateDescribeOrderInfoRequest creates a request to invoke DescribeOrderInfo API
func CreateDescribeOrderInfoRequest() (request *DescribeOrderInfoRequest) {
	request = &DescribeOrderInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "DescribeOrderInfo", "afs", "openAPI")
	return
}

// CreateDescribeOrderInfoResponse creates a response to parse from DescribeOrderInfo response
func CreateDescribeOrderInfoResponse() (response *DescribeOrderInfoResponse) {
	response = &DescribeOrderInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
