package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTargetConfig invokes the aegis.DescribeTargetConfig API synchronously
// api document: https://help.aliyun.com/api/aegis/describetargetconfig.html
func (client *Client) DescribeTargetConfig(request *DescribeTargetConfigRequest) (response *DescribeTargetConfigResponse, err error) {
	response = CreateDescribeTargetConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTargetConfigWithChan invokes the aegis.DescribeTargetConfig API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetargetconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTargetConfigWithChan(request *DescribeTargetConfigRequest) (<-chan *DescribeTargetConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeTargetConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTargetConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTargetConfigWithCallback invokes the aegis.DescribeTargetConfig API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetargetconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTargetConfigWithCallback(request *DescribeTargetConfigRequest, callback func(response *DescribeTargetConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTargetConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeTargetConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTargetConfigRequest is the request struct for api DescribeTargetConfig
type DescribeTargetConfigRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Type     string `position:"Query" name:"Type"`
	Uuid     string `position:"Query" name:"Uuid"`
}

// DescribeTargetConfigResponse is the response struct for api DescribeTargetConfig
type DescribeTargetConfigResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	TotalCount    int            `json:"TotalCount" xml:"TotalCount"`
	TargetConfigs []TargetConfig `json:"TargetConfigs" xml:"TargetConfigs"`
}

// CreateDescribeTargetConfigRequest creates a request to invoke DescribeTargetConfig API
func CreateDescribeTargetConfigRequest() (request *DescribeTargetConfigRequest) {
	request = &DescribeTargetConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeTargetConfig", "vipaegis", "openAPI")
	return
}

// CreateDescribeTargetConfigResponse creates a response to parse from DescribeTargetConfig response
func CreateDescribeTargetConfigResponse() (response *DescribeTargetConfigResponse) {
	response = &DescribeTargetConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
