package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeQuaraFile invokes the aegis.DescribeQuaraFile API synchronously
// api document: https://help.aliyun.com/api/aegis/describequarafile.html
func (client *Client) DescribeQuaraFile(request *DescribeQuaraFileRequest) (response *DescribeQuaraFileResponse, err error) {
	response = CreateDescribeQuaraFileResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeQuaraFileWithChan invokes the aegis.DescribeQuaraFile API asynchronously
// api document: https://help.aliyun.com/api/aegis/describequarafile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeQuaraFileWithChan(request *DescribeQuaraFileRequest) (<-chan *DescribeQuaraFileResponse, <-chan error) {
	responseChan := make(chan *DescribeQuaraFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeQuaraFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeQuaraFileWithCallback invokes the aegis.DescribeQuaraFile API asynchronously
// api document: https://help.aliyun.com/api/aegis/describequarafile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeQuaraFileWithCallback(request *DescribeQuaraFileRequest, callback func(response *DescribeQuaraFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeQuaraFileResponse
		var err error
		defer close(result)
		response, err = client.DescribeQuaraFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeQuaraFileRequest is the request struct for api DescribeQuaraFile
type DescribeQuaraFileRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// DescribeQuaraFileResponse is the response struct for api DescribeQuaraFile
type DescribeQuaraFileResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	CurrentPage int         `json:"CurrentPage" xml:"CurrentPage"`
	QuaraFiles  []QuaraFile `json:"QuaraFiles" xml:"QuaraFiles"`
}

// CreateDescribeQuaraFileRequest creates a request to invoke DescribeQuaraFile API
func CreateDescribeQuaraFileRequest() (request *DescribeQuaraFileRequest) {
	request = &DescribeQuaraFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeQuaraFile", "vipaegis", "openAPI")
	return
}

// CreateDescribeQuaraFileResponse creates a response to parse from DescribeQuaraFile response
func CreateDescribeQuaraFileResponse() (response *DescribeQuaraFileResponse) {
	response = &DescribeQuaraFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
