package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAdviceService invokes the adb.DisableAdviceService API synchronously
func (client *Client) DisableAdviceService(request *DisableAdviceServiceRequest) (response *DisableAdviceServiceResponse, err error) {
	response = CreateDisableAdviceServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAdviceServiceWithChan invokes the adb.DisableAdviceService API asynchronously
func (client *Client) DisableAdviceServiceWithChan(request *DisableAdviceServiceRequest) (<-chan *DisableAdviceServiceResponse, <-chan error) {
	responseChan := make(chan *DisableAdviceServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAdviceService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAdviceServiceWithCallback invokes the adb.DisableAdviceService API asynchronously
func (client *Client) DisableAdviceServiceWithCallback(request *DisableAdviceServiceRequest, callback func(response *DisableAdviceServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAdviceServiceResponse
		var err error
		defer close(result)
		response, err = client.DisableAdviceService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAdviceServiceRequest is the request struct for api DisableAdviceService
type DisableAdviceServiceRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
}

// DisableAdviceServiceResponse is the response struct for api DisableAdviceService
type DisableAdviceServiceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableAdviceServiceRequest creates a request to invoke DisableAdviceService API
func CreateDisableAdviceServiceRequest() (request *DisableAdviceServiceRequest) {
	request = &DisableAdviceServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DisableAdviceService", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableAdviceServiceResponse creates a response to parse from DisableAdviceService response
func CreateDisableAdviceServiceResponse() (response *DisableAdviceServiceResponse) {
	response = &DisableAdviceServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
