package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLPatterns invokes the adb.DescribeSQLPatterns API synchronously
func (client *Client) DescribeSQLPatterns(request *DescribeSQLPatternsRequest) (response *DescribeSQLPatternsResponse, err error) {
	response = CreateDescribeSQLPatternsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLPatternsWithChan invokes the adb.DescribeSQLPatterns API asynchronously
func (client *Client) DescribeSQLPatternsWithChan(request *DescribeSQLPatternsRequest) (<-chan *DescribeSQLPatternsResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLPatternsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLPatterns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLPatternsWithCallback invokes the adb.DescribeSQLPatterns API asynchronously
func (client *Client) DescribeSQLPatternsWithCallback(request *DescribeSQLPatternsRequest, callback func(response *DescribeSQLPatternsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLPatternsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLPatterns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLPatternsRequest is the request struct for api DescribeSQLPatterns
type DescribeSQLPatternsRequest struct {
	*requests.RpcRequest
	DBClusterId string           `position:"Query" name:"DBClusterId"`
	EndTime     string           `position:"Query" name:"EndTime"`
	StartTime   string           `position:"Query" name:"StartTime"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Keyword     string           `position:"Query" name:"Keyword"`
	Lang        string           `position:"Query" name:"Lang"`
	Order       string           `position:"Query" name:"Order"`
}

// DescribeSQLPatternsResponse is the response struct for api DescribeSQLPatterns
type DescribeSQLPatternsResponse struct {
	*responses.BaseResponse
	PageNumber     int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize       int                  `json:"PageSize" xml:"PageSize"`
	TotalCount     int                  `json:"TotalCount" xml:"TotalCount"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	PatternDetails []PatternDetailsItem `json:"PatternDetails" xml:"PatternDetails"`
}

// CreateDescribeSQLPatternsRequest creates a request to invoke DescribeSQLPatterns API
func CreateDescribeSQLPatternsRequest() (request *DescribeSQLPatternsRequest) {
	request = &DescribeSQLPatternsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeSQLPatterns", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLPatternsResponse creates a response to parse from DescribeSQLPatterns response
func CreateDescribeSQLPatternsResponse() (response *DescribeSQLPatternsResponse) {
	response = &DescribeSQLPatternsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
