package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterHealthStatus invokes the adb.DescribeDBClusterHealthStatus API synchronously
func (client *Client) DescribeDBClusterHealthStatus(request *DescribeDBClusterHealthStatusRequest) (response *DescribeDBClusterHealthStatusResponse, err error) {
	response = CreateDescribeDBClusterHealthStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterHealthStatusWithChan invokes the adb.DescribeDBClusterHealthStatus API asynchronously
func (client *Client) DescribeDBClusterHealthStatusWithChan(request *DescribeDBClusterHealthStatusRequest) (<-chan *DescribeDBClusterHealthStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterHealthStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterHealthStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterHealthStatusWithCallback invokes the adb.DescribeDBClusterHealthStatus API asynchronously
func (client *Client) DescribeDBClusterHealthStatusWithCallback(request *DescribeDBClusterHealthStatusRequest, callback func(response *DescribeDBClusterHealthStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterHealthStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterHealthStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterHealthStatusRequest is the request struct for api DescribeDBClusterHealthStatus
type DescribeDBClusterHealthStatusRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
}

// DescribeDBClusterHealthStatusResponse is the response struct for api DescribeDBClusterHealthStatus
type DescribeDBClusterHealthStatusResponse struct {
	*responses.BaseResponse
	InstanceStatus string   `json:"InstanceStatus" xml:"InstanceStatus"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	CS             CS       `json:"CS" xml:"CS"`
	Executor       Executor `json:"Executor" xml:"Executor"`
	Worker         Worker   `json:"Worker" xml:"Worker"`
}

// CreateDescribeDBClusterHealthStatusRequest creates a request to invoke DescribeDBClusterHealthStatus API
func CreateDescribeDBClusterHealthStatusRequest() (request *DescribeDBClusterHealthStatusRequest) {
	request = &DescribeDBClusterHealthStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterHealthStatus", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterHealthStatusResponse creates a response to parse from DescribeDBClusterHealthStatus response
func CreateDescribeDBClusterHealthStatusResponse() (response *DescribeDBClusterHealthStatusResponse) {
	response = &DescribeDBClusterHealthStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
