// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/cluster_data_proto/bigtable_cluster_data.proto
// DO NOT EDIT!

/*
Package google_bigtable_admin_cluster_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/cluster_data_proto/bigtable_cluster_data.proto

It has these top-level messages:
	Zone
	Cluster
*/
package google_bigtable_admin_cluster_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type StorageType int32

const (
	// The storage type used is unspecified.
	StorageType_STORAGE_UNSPECIFIED StorageType = 0
	// Data will be stored in SSD, providing low and consistent latencies.
	StorageType_STORAGE_SSD StorageType = 1
)

var StorageType_name = map[int32]string{
	0: "STORAGE_UNSPECIFIED",
	1: "STORAGE_SSD",
}
var StorageType_value = map[string]int32{
	"STORAGE_UNSPECIFIED": 0,
	"STORAGE_SSD":         1,
}

func (x StorageType) String() string {
	return proto.EnumName(StorageType_name, int32(x))
}
func (StorageType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Possible states of a zone.
type Zone_Status int32

const (
	// The state of the zone is unknown or unspecified.
	Zone_UNKNOWN Zone_Status = 0
	// The zone is in a good state.
	Zone_OK Zone_Status = 1
	// The zone is down for planned maintenance.
	Zone_PLANNED_MAINTENANCE Zone_Status = 2
	// The zone is down for emergency or unplanned maintenance.
	Zone_EMERGENCY_MAINENANCE Zone_Status = 3
)

var Zone_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "OK",
	2: "PLANNED_MAINTENANCE",
	3: "EMERGENCY_MAINENANCE",
}
var Zone_Status_value = map[string]int32{
	"UNKNOWN": 0,
	"OK":      1,
	"PLANNED_MAINTENANCE":  2,
	"EMERGENCY_MAINENANCE": 3,
}

func (x Zone_Status) String() string {
	return proto.EnumName(Zone_Status_name, int32(x))
}
func (Zone_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// A physical location in which a particular project can allocate Cloud BigTable
// resources.
type Zone struct {
	// A permanent unique identifier for the zone.
	// Values are of the form projects/<project>/zones/[a-z][-a-z0-9]*
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of this zone as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name" json:"display_name,omitempty"`
	// The current state of this zone.
	Status Zone_Status `protobuf:"varint,3,opt,name=status,enum=google.bigtable.admin.cluster.v1.Zone_Status" json:"status,omitempty"`
}

func (m *Zone) Reset()                    { *m = Zone{} }
func (m *Zone) String() string            { return proto.CompactTextString(m) }
func (*Zone) ProtoMessage()               {}
func (*Zone) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// An isolated set of Cloud BigTable resources on which tables can be hosted.
type Cluster struct {
	// A permanent unique identifier for the cluster. For technical reasons, the
	// zone in which the cluster resides is included here.
	// Values are of the form
	// projects/<project>/zones/<zone>/clusters/[a-z][-a-z0-9]*
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The descriptive name for this cluster as it appears in UIs.
	// Must be unique per zone.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name" json:"display_name,omitempty"`
	// The number of serve nodes allocated to this cluster.
	ServeNodes int32 `protobuf:"varint,5,opt,name=serve_nodes" json:"serve_nodes,omitempty"`
	// What storage type to use for tables in this cluster. Only configurable at
	// cluster creation time. If unspecified, STORAGE_SSD will be used.
	DefaultStorageType StorageType `protobuf:"varint,8,opt,name=default_storage_type,enum=google.bigtable.admin.cluster.v1.StorageType" json:"default_storage_type,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func init() {
	proto.RegisterType((*Zone)(nil), "google.bigtable.admin.cluster.v1.Zone")
	proto.RegisterType((*Cluster)(nil), "google.bigtable.admin.cluster.v1.Cluster")
	proto.RegisterEnum("google.bigtable.admin.cluster.v1.StorageType", StorageType_name, StorageType_value)
	proto.RegisterEnum("google.bigtable.admin.cluster.v1.Zone_Status", Zone_Status_name, Zone_Status_value)
}

var fileDescriptor0 = []byte{
	// 364 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x91, 0x4d, 0x4f, 0xc2, 0x40,
	0x10, 0x86, 0x2d, 0x1f, 0x45, 0x17, 0xa2, 0xcd, 0x42, 0x62, 0x8f, 0x84, 0x78, 0x30, 0x26, 0x2e,
	0x51, 0x0f, 0x9e, 0x3c, 0xf4, 0x63, 0x25, 0x04, 0x59, 0x1a, 0x0a, 0xf1, 0xe3, 0xb2, 0x59, 0xe8,
	0xda, 0x34, 0x29, 0x5d, 0xd2, 0x6e, 0x49, 0xf8, 0x15, 0xfe, 0x20, 0xff, 0x9c, 0x4b, 0xa9, 0x86,
	0x1b, 0xde, 0x66, 0xde, 0xe7, 0x9d, 0x99, 0xbc, 0x19, 0xf0, 0x16, 0x0a, 0x11, 0xc6, 0x1c, 0x85,
	0x22, 0x66, 0x49, 0x88, 0x44, 0x1a, 0xf6, 0x97, 0xb1, 0xc8, 0x83, 0xfe, 0x22, 0x0a, 0x25, 0x5b,
	0xc4, 0xbc, 0x1f, 0x25, 0x92, 0xa7, 0x09, 0x8b, 0x95, 0x9e, 0x67, 0xaa, 0xa4, 0x01, 0x93, 0x8c,
	0xae, 0x53, 0x21, 0xc5, 0x9f, 0x89, 0x1e, 0x32, 0x54, 0x30, 0xd8, 0x2d, 0x37, 0xff, 0x7a, 0x10,
	0x0b, 0x56, 0x51, 0x82, 0x4a, 0x27, 0xda, 0xdc, 0xf5, 0xbe, 0x35, 0x50, 0xfb, 0x10, 0x09, 0x87,
	0x2d, 0x50, 0x4b, 0xd8, 0x8a, 0x9b, 0x5a, 0x57, 0xbb, 0x3e, 0x83, 0x1d, 0xd0, 0x0a, 0xa2, 0x6c,
	0x1d, 0xb3, 0x2d, 0x2d, 0xd4, 0x4a, 0xa1, 0x3e, 0x01, 0x3d, 0x93, 0x4c, 0xe6, 0x99, 0x59, 0x55,
	0xfd, 0xf9, 0xfd, 0x2d, 0x3a, 0xb6, 0x1f, 0xed, 0x76, 0x23, 0xbf, 0x18, 0xea, 0x79, 0x40, 0xdf,
	0x57, 0xb0, 0x09, 0x1a, 0x73, 0x32, 0x22, 0x93, 0x57, 0x62, 0x9c, 0x40, 0x1d, 0x54, 0x26, 0x23,
	0x43, 0x83, 0x97, 0xa0, 0xed, 0xbd, 0x58, 0x84, 0x60, 0x97, 0x8e, 0xad, 0x21, 0x99, 0x61, 0x62,
	0x11, 0x07, 0x1b, 0x15, 0x68, 0x82, 0x0e, 0x1e, 0xe3, 0xe9, 0x00, 0x13, 0xe7, 0xbd, 0x40, 0x25,
	0xa9, 0xf6, 0xbe, 0x34, 0xd0, 0x70, 0xf6, 0xc7, 0x8e, 0x04, 0xa8, 0x15, 0x6a, 0x1b, 0x34, 0x33,
	0x9e, 0x6e, 0x38, 0x4d, 0x44, 0xc0, 0x33, 0xb3, 0xae, 0xc4, 0x3a, 0x1c, 0x81, 0x4e, 0xc0, 0x3f,
	0x59, 0x1e, 0x4b, 0x9a, 0x49, 0x91, 0xb2, 0x90, 0x53, 0xb9, 0x5d, 0x73, 0xf3, 0xf4, 0xbf, 0x19,
	0xfd, 0xfd, 0xd4, 0x4c, 0x0d, 0xdd, 0x3c, 0x82, 0xe6, 0x41, 0xbb, 0xcb, 0xe4, 0xcf, 0x26, 0x53,
	0x6b, 0x80, 0xe9, 0x9c, 0xf8, 0x1e, 0x76, 0x86, 0xcf, 0x43, 0xec, 0xaa, 0xd0, 0x17, 0xca, 0x57,
	0x02, 0xdf, 0x77, 0x0d, 0xcd, 0xb6, 0xc1, 0xd5, 0x52, 0xac, 0x8e, 0x1e, 0xb3, 0x4d, 0xbb, 0x44,
	0x65, 0x6e, 0x57, 0x7d, 0xdb, 0xdb, 0x3d, 0xdb, 0xd3, 0x16, 0x7a, 0xf1, 0xf5, 0x87, 0x9f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x6a, 0x10, 0x35, 0x5b, 0x51, 0x02, 0x00, 0x00,
}
