// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qapps_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/qapps"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Increase the rating counter by 1 for the related app for this user
//

func ExampleQApps_AssociateLibraryItemReview_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.AssociateLibraryItemReviewInput{
		InstanceId:    aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		LibraryItemId: aws.String("cb9ecf72-8563-450d-9db9-994f98297316"),
	}

	result, err := svc.AssociateLibraryItemReview(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Links an Amazon Q App to the invoker's list of apps
//

func ExampleQApps_AssociateQAppWithUser_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.AssociateQAppWithUserInput{
		AppId:      aws.String("393e77fb-0a30-4f47-ad30-75d71aeaed8a"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.AssociateQAppWithUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create a Library Item
//

func ExampleQApps_CreateLibraryItem_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.CreateLibraryItemInput{
		AppId:      aws.String("7a11f34b-42d4-4bc8-b668-ae4a788dae1e"),
		AppVersion: aws.Int64(6),
		Categories: []*string{
			aws.String("9c871ed4-1c41-4065-aefe-321cd4b61cf8"),
		},
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.CreateLibraryItem(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A basic application with 1 text input card and 1 output card
//

func ExampleQApps_CreateQApp_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.CreateQAppInput{
		AppDefinition: &qapps.AppDefinitionInput_{
			Cards: []*qapps.CardInput_{
				{
					TextInput: &qapps.TextInputCardInput_{
						Id:    aws.String("4cf94d96-8819-45c2-98cc-58c56b35c72f"),
						Title: aws.String("Color Base"),
						Type:  aws.String("text-input"),
					},
				},
				{
					QQuery: &qapps.QQueryCardInput_{
						Id:     aws.String("18870b94-1e63-40e0-8c12-669c90ac5acc"),
						Prompt: aws.String("Recommend me a list of colors that go well with @4cf94d96-8819-45c2-98cc-58c56b35c72f"),
						Title:  aws.String("Recommended Palette"),
						Type:   aws.String("q-query"),
					},
				},
			},
			InitialPrompt: aws.String("Create an app that recommend a list of colors based on input."),
		},
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Title:      aws.String("Color Palette Generator"),
	}

	result, err := svc.CreateQApp(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeConflictException:
				fmt.Println(qapps.ErrCodeConflictException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeContentTooLargeException:
				fmt.Println(qapps.ErrCodeContentTooLargeException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete a library item
//

func ExampleQApps_DeleteLibraryItem_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.DeleteLibraryItemInput{
		InstanceId:    aws.String("3642ba81-344c-42fd-a480-9119a5a5f26b"),
		LibraryItemId: aws.String("72088fd4-78b6-43da-bfb8-8621323c3cfb"),
	}

	result, err := svc.DeleteLibraryItem(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete an Amazon Q App
//

func ExampleQApps_DeleteQApp_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.DeleteQAppInput{
		AppId:      aws.String("393e77fb-0a30-4f47-ad30-75d71aeaed8a"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.DeleteQApp(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Decrease the rating counter by 1 for the related app for this user
//

func ExampleQApps_DisassociateLibraryItemReview_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.DisassociateLibraryItemReviewInput{
		InstanceId:    aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		LibraryItemId: aws.String("cb9ecf72-8563-450d-9db9-994f98297316"),
	}

	result, err := svc.DisassociateLibraryItemReview(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Unlinks an Amazon Q App from the invoker's list of apps
//

func ExampleQApps_DisassociateQAppFromUser_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.DisassociateQAppFromUserInput{
		AppId:      aws.String("393e77fb-0a30-4f47-ad30-75d71aeaed8a"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.DisassociateQAppFromUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Retrieve a library item
//

func ExampleQApps_GetLibraryItem_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.GetLibraryItemInput{
		InstanceId:    aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		LibraryItemId: aws.String("18cbebaa-196a-4aa5-a840-88d548e07f8f"),
	}

	result, err := svc.GetLibraryItem(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A basic application with 1 text input card and 1 output card
//

func ExampleQApps_GetQApp_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.GetQAppInput{
		AppId:      aws.String("3d110749-efc3-427c-87e8-15e966e5c168"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.GetQApp(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Retrieves an existing session for an Amazon Q App
//

func ExampleQApps_GetQAppSession_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.GetQAppSessionInput{
		InstanceId: aws.String("288ae830-1df2-4871-b6c0-4314d74dadef"),
		SessionId:  aws.String("1fca878e-64c5-4dc4-b1d9-c93effed4e82"),
	}

	result, err := svc.GetQAppSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Upload a file to a specific session
//

func ExampleQApps_ImportDocument_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.ImportDocumentInput{
		AppId:              aws.String("4263767c-d889-4cb2-a8f6-8b649bc66af0"),
		CardId:             aws.String("82f69028-22a9-4bea-8727-0eabf58e9fed"),
		FileContentsBase64: aws.String("data:text/plain;base64,SomeFileEncodedInBase64"),
		FileName:           aws.String("myFile.txt"),
		InstanceId:         aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Scope:              aws.String("SESSION"),
		SessionId:          aws.String("4f0e5b87-9d38-41cd-9eb4-ebce2f2917cc"),
	}

	result, err := svc.ImportDocument(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeContentTooLargeException:
				fmt.Println(qapps.ErrCodeContentTooLargeException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Upload a file into a application
//

func ExampleQApps_ImportDocument_shared01() {
	svc := qapps.New(session.New())
	input := &qapps.ImportDocumentInput{
		AppId:              aws.String("4263767c-d889-4cb2-a8f6-8b649bc66af0"),
		CardId:             aws.String("7a11f34b-42d4-4bc8-b668-ae4a788dae1e"),
		FileContentsBase64: aws.String("data:text/plain;base64,SomeFileEncodedInBase64"),
		FileName:           aws.String("anApplicationFile.txt"),
		InstanceId:         aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Scope:              aws.String("APPLICATION"),
	}

	result, err := svc.ImportDocument(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeContentTooLargeException:
				fmt.Println(qapps.ErrCodeContentTooLargeException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List at most 3 library items for this instance
//

func ExampleQApps_ListLibraryItems_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.ListLibraryItemsInput{
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Limit:      aws.Int64(3),
	}

	result, err := svc.ListLibraryItems(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List at most 3 Amazon Q Apps in an Q Business application
//

func ExampleQApps_ListQApps_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.ListQAppsInput{
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Limit:      aws.Int64(3),
	}

	result, err := svc.ListQApps(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Retrieve the next page of Amazon Q Apps
//

func ExampleQApps_ListQApps_shared01() {
	svc := qapps.New(session.New())
	input := &qapps.ListQAppsInput{
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Limit:      aws.Int64(3),
		NextToken:  aws.String("bXlzdGVyaW91c1BhZ2luYXRpb25Ub2tlbg=="),
	}

	result, err := svc.ListQApps(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A call to list tags for a resource
//

func ExampleQApps_ListTagsForResource_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.ListTagsForResourceInput{
		ResourceARN: aws.String("arn:aws:qapps:us-west-2:123456789012:application/3642ba81-344c-42fd-a480-9119a5a5f26b/qapp/7212ff04-de7b-4831-bd80-45d6975ba1b0"),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start a session for an Amazon Q App using version 1, passing in initial values for
// one card
//

func ExampleQApps_StartQAppSession_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.StartQAppSessionInput{
		AppId:      aws.String("65e7dce7-226a-47f9-b689-22850becef89"),
		AppVersion: aws.Int64(1),
		InitialValues: []*qapps.CardValue{
			{
				CardId: aws.String("6fb5b404-3b7b-48a4-8a8b-56406922a606"),
				Value:  aws.String("What is the circumference of Earth?"),
			},
		},
		InstanceId: aws.String("4cc5e4c2-d2a2-4188-a114-9ca125b4aedc"),
	}

	result, err := svc.StartQAppSession(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeServiceQuotaExceededException:
				fmt.Println(qapps.ErrCodeServiceQuotaExceededException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A call to tag a resource
//

func ExampleQApps_TagResource_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.TagResourceInput{
		ResourceARN: aws.String("arn:aws:qapps:us-west-2:123456789012:application/3642ba81-344c-42fd-a480-9119a5a5f26b/qapp/7212ff04-de7b-4831-bd80-45d6975ba1b0"),
		Tags: map[string]*string{
			"department": aws.String("HR"),
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeConflictException:
				fmt.Println(qapps.ErrCodeConflictException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A call to untag a resource
//

func ExampleQApps_UntagResource_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.UntagResourceInput{
		ResourceARN: aws.String("arn:aws:qapps:us-west-2:123456789012:application/3642ba81-344c-42fd-a480-9119a5a5f26b/qapp/7212ff04-de7b-4831-bd80-45d6975ba1b0"),
		TagKeys: []*string{
			aws.String("department"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Sets the status of a library item to DISABLED
//

func ExampleQApps_UpdateLibraryItem_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.UpdateLibraryItemInput{
		InstanceId:    aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		LibraryItemId: aws.String("cb9ecf72-8563-450d-9db9-994f98297316"),
		Status:        aws.String("DISABLED"),
	}

	result, err := svc.UpdateLibraryItem(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updating the title of an app
//

func ExampleQApps_UpdateQApp_shared00() {
	svc := qapps.New(session.New())
	input := &qapps.UpdateQAppInput{
		AppId:      aws.String("7212ff04-de7b-4831-bd80-45d6975ba1b0"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
		Title:      aws.String("This is the new title"),
	}

	result, err := svc.UpdateQApp(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeContentTooLargeException:
				fmt.Println(qapps.ErrCodeContentTooLargeException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Updating the app so it has a single q-query card
//

func ExampleQApps_UpdateQApp_shared01() {
	svc := qapps.New(session.New())
	input := &qapps.UpdateQAppInput{
		AppDefinition: &qapps.AppDefinitionInput_{
			Cards: []*qapps.CardInput_{
				{
					QQuery: &qapps.QQueryCardInput_{
						Id:     aws.String("18870b94-1e63-40e0-8c12-669c90ac5acc"),
						Prompt: aws.String("Recommend me an itinerary for a trip"),
						Title:  aws.String("Trip Ideas"),
						Type:   aws.String("q-query"),
					},
				},
			},
		},
		AppId:      aws.String("7212ff04-de7b-4831-bd80-45d6975ba1b0"),
		InstanceId: aws.String("0b95c9c4-89cc-4aa8-9aae-aa91cbec699f"),
	}

	result, err := svc.UpdateQApp(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case qapps.ErrCodeResourceNotFoundException:
				fmt.Println(qapps.ErrCodeResourceNotFoundException, aerr.Error())
			case qapps.ErrCodeAccessDeniedException:
				fmt.Println(qapps.ErrCodeAccessDeniedException, aerr.Error())
			case qapps.ErrCodeValidationException:
				fmt.Println(qapps.ErrCodeValidationException, aerr.Error())
			case qapps.ErrCodeInternalServerException:
				fmt.Println(qapps.ErrCodeInternalServerException, aerr.Error())
			case qapps.ErrCodeUnauthorizedException:
				fmt.Println(qapps.ErrCodeUnauthorizedException, aerr.Error())
			case qapps.ErrCodeContentTooLargeException:
				fmt.Println(qapps.ErrCodeContentTooLargeException, aerr.Error())
			case qapps.ErrCodeThrottlingException:
				fmt.Println(qapps.ErrCodeThrottlingException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
