// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddBridgeOutputs = "AddBridgeOutputs"

// AddBridgeOutputsRequest generates a "aws/request.Request" representing the
// client's request for the AddBridgeOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddBridgeOutputs for more information on using the AddBridgeOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddBridgeOutputsRequest method.
//	req, resp := client.AddBridgeOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs
func (c *MediaConnect) AddBridgeOutputsRequest(input *AddBridgeOutputsInput) (req *request.Request, output *AddBridgeOutputsOutput) {
	op := &request.Operation{
		Name:       opAddBridgeOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/bridges/{bridgeArn}/outputs",
	}

	if input == nil {
		input = &AddBridgeOutputsInput{}
	}

	output = &AddBridgeOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddBridgeOutputs API operation for AWS MediaConnect.
//
// Adds outputs to an existing bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddBridgeOutputs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeOutputs
func (c *MediaConnect) AddBridgeOutputs(input *AddBridgeOutputsInput) (*AddBridgeOutputsOutput, error) {
	req, out := c.AddBridgeOutputsRequest(input)
	return out, req.Send()
}

// AddBridgeOutputsWithContext is the same as AddBridgeOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See AddBridgeOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddBridgeOutputsWithContext(ctx aws.Context, input *AddBridgeOutputsInput, opts ...request.Option) (*AddBridgeOutputsOutput, error) {
	req, out := c.AddBridgeOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddBridgeSources = "AddBridgeSources"

// AddBridgeSourcesRequest generates a "aws/request.Request" representing the
// client's request for the AddBridgeSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddBridgeSources for more information on using the AddBridgeSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddBridgeSourcesRequest method.
//	req, resp := client.AddBridgeSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources
func (c *MediaConnect) AddBridgeSourcesRequest(input *AddBridgeSourcesInput) (req *request.Request, output *AddBridgeSourcesOutput) {
	op := &request.Operation{
		Name:       opAddBridgeSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/bridges/{bridgeArn}/sources",
	}

	if input == nil {
		input = &AddBridgeSourcesInput{}
	}

	output = &AddBridgeSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddBridgeSources API operation for AWS MediaConnect.
//
// Adds sources to an existing bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddBridgeSources for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddBridgeSources
func (c *MediaConnect) AddBridgeSources(input *AddBridgeSourcesInput) (*AddBridgeSourcesOutput, error) {
	req, out := c.AddBridgeSourcesRequest(input)
	return out, req.Send()
}

// AddBridgeSourcesWithContext is the same as AddBridgeSources with the addition of
// the ability to pass a context and additional request options.
//
// See AddBridgeSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddBridgeSourcesWithContext(ctx aws.Context, input *AddBridgeSourcesInput, opts ...request.Option) (*AddBridgeSourcesOutput, error) {
	req, out := c.AddBridgeSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowMediaStreams = "AddFlowMediaStreams"

// AddFlowMediaStreamsRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowMediaStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowMediaStreams for more information on using the AddFlowMediaStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddFlowMediaStreamsRequest method.
//	req, resp := client.AddFlowMediaStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams
func (c *MediaConnect) AddFlowMediaStreamsRequest(input *AddFlowMediaStreamsInput) (req *request.Request, output *AddFlowMediaStreamsOutput) {
	op := &request.Operation{
		Name:       opAddFlowMediaStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/mediaStreams",
	}

	if input == nil {
		input = &AddFlowMediaStreamsInput{}
	}

	output = &AddFlowMediaStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowMediaStreams API operation for AWS MediaConnect.
//
// Adds media streams to an existing flow. After you add a media stream to a
// flow, you can associate it with a source and/or an output that uses the ST
// 2110 JPEG XS or CDI protocol.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowMediaStreams for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowMediaStreams
func (c *MediaConnect) AddFlowMediaStreams(input *AddFlowMediaStreamsInput) (*AddFlowMediaStreamsOutput, error) {
	req, out := c.AddFlowMediaStreamsRequest(input)
	return out, req.Send()
}

// AddFlowMediaStreamsWithContext is the same as AddFlowMediaStreams with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowMediaStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowMediaStreamsWithContext(ctx aws.Context, input *AddFlowMediaStreamsInput, opts ...request.Option) (*AddFlowMediaStreamsOutput, error) {
	req, out := c.AddFlowMediaStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowOutputs = "AddFlowOutputs"

// AddFlowOutputsRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowOutputs for more information on using the AddFlowOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddFlowOutputsRequest method.
//	req, resp := client.AddFlowOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputsRequest(input *AddFlowOutputsInput) (req *request.Request, output *AddFlowOutputsOutput) {
	op := &request.Operation{
		Name:       opAddFlowOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/outputs",
	}

	if input == nil {
		input = &AddFlowOutputsInput{}
	}

	output = &AddFlowOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowOutputs API operation for AWS MediaConnect.
//
// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowOutputs for usage and error information.
//
// Returned Error Types:
//
//   - AddFlowOutputs420Exception
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputs(input *AddFlowOutputsInput) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	return out, req.Send()
}

// AddFlowOutputsWithContext is the same as AddFlowOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowOutputsWithContext(ctx aws.Context, input *AddFlowOutputsInput, opts ...request.Option) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowSources = "AddFlowSources"

// AddFlowSourcesRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowSources for more information on using the AddFlowSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddFlowSourcesRequest method.
//	req, resp := client.AddFlowSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources
func (c *MediaConnect) AddFlowSourcesRequest(input *AddFlowSourcesInput) (req *request.Request, output *AddFlowSourcesOutput) {
	op := &request.Operation{
		Name:       opAddFlowSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/source",
	}

	if input == nil {
		input = &AddFlowSourcesInput{}
	}

	output = &AddFlowSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowSources API operation for AWS MediaConnect.
//
// # Adds Sources to flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowSources for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources
func (c *MediaConnect) AddFlowSources(input *AddFlowSourcesInput) (*AddFlowSourcesOutput, error) {
	req, out := c.AddFlowSourcesRequest(input)
	return out, req.Send()
}

// AddFlowSourcesWithContext is the same as AddFlowSources with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowSourcesWithContext(ctx aws.Context, input *AddFlowSourcesInput, opts ...request.Option) (*AddFlowSourcesOutput, error) {
	req, out := c.AddFlowSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowVpcInterfaces = "AddFlowVpcInterfaces"

// AddFlowVpcInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowVpcInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowVpcInterfaces for more information on using the AddFlowVpcInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddFlowVpcInterfacesRequest method.
//	req, resp := client.AddFlowVpcInterfacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces
func (c *MediaConnect) AddFlowVpcInterfacesRequest(input *AddFlowVpcInterfacesInput) (req *request.Request, output *AddFlowVpcInterfacesOutput) {
	op := &request.Operation{
		Name:       opAddFlowVpcInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/vpcInterfaces",
	}

	if input == nil {
		input = &AddFlowVpcInterfacesInput{}
	}

	output = &AddFlowVpcInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowVpcInterfaces API operation for AWS MediaConnect.
//
// # Adds VPC interfaces to flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowVpcInterfaces for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces
func (c *MediaConnect) AddFlowVpcInterfaces(input *AddFlowVpcInterfacesInput) (*AddFlowVpcInterfacesOutput, error) {
	req, out := c.AddFlowVpcInterfacesRequest(input)
	return out, req.Send()
}

// AddFlowVpcInterfacesWithContext is the same as AddFlowVpcInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowVpcInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowVpcInterfacesWithContext(ctx aws.Context, input *AddFlowVpcInterfacesInput, opts ...request.Option) (*AddFlowVpcInterfacesOutput, error) {
	req, out := c.AddFlowVpcInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBridge = "CreateBridge"

// CreateBridgeRequest generates a "aws/request.Request" representing the
// client's request for the CreateBridge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBridge for more information on using the CreateBridge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBridgeRequest method.
//	req, resp := client.CreateBridgeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge
func (c *MediaConnect) CreateBridgeRequest(input *CreateBridgeInput) (req *request.Request, output *CreateBridgeOutput) {
	op := &request.Operation{
		Name:       opCreateBridge,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/bridges",
	}

	if input == nil {
		input = &CreateBridgeInput{}
	}

	output = &CreateBridgeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBridge API operation for AWS MediaConnect.
//
// Creates a new bridge. The request must include one source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation CreateBridge for usage and error information.
//
// Returned Error Types:
//
//   - CreateBridge420Exception
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateBridge
func (c *MediaConnect) CreateBridge(input *CreateBridgeInput) (*CreateBridgeOutput, error) {
	req, out := c.CreateBridgeRequest(input)
	return out, req.Send()
}

// CreateBridgeWithContext is the same as CreateBridge with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBridge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) CreateBridgeWithContext(ctx aws.Context, input *CreateBridgeInput, opts ...request.Option) (*CreateBridgeOutput, error) {
	req, out := c.CreateBridgeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlow = "CreateFlow"

// CreateFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlow for more information on using the CreateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlowRequest method.
//	req, resp := client.CreateFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlowRequest(input *CreateFlowInput) (req *request.Request, output *CreateFlowOutput) {
	op := &request.Operation{
		Name:       opCreateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows",
	}

	if input == nil {
		input = &CreateFlowInput{}
	}

	output = &CreateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlow API operation for AWS MediaConnect.
//
// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 50) and entitlements (up to 50).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation CreateFlow for usage and error information.
//
// Returned Error Types:
//
//   - CreateFlow420Exception
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlow(input *CreateFlowInput) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	return out, req.Send()
}

// CreateFlowWithContext is the same as CreateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) CreateFlowWithContext(ctx aws.Context, input *CreateFlowInput, opts ...request.Option) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGateway = "CreateGateway"

// CreateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGateway for more information on using the CreateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGatewayRequest method.
//	req, resp := client.CreateGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway
func (c *MediaConnect) CreateGatewayRequest(input *CreateGatewayInput) (req *request.Request, output *CreateGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/gateways",
	}

	if input == nil {
		input = &CreateGatewayInput{}
	}

	output = &CreateGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGateway API operation for AWS MediaConnect.
//
// Creates a new gateway. The request must include at least one network (up
// to 4).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation CreateGateway for usage and error information.
//
// Returned Error Types:
//
//   - CreateGateway420Exception
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateGateway
func (c *MediaConnect) CreateGateway(input *CreateGatewayInput) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	return out, req.Send()
}

// CreateGatewayWithContext is the same as CreateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) CreateGatewayWithContext(ctx aws.Context, input *CreateGatewayInput, opts ...request.Option) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBridge = "DeleteBridge"

// DeleteBridgeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBridge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBridge for more information on using the DeleteBridge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBridgeRequest method.
//	req, resp := client.DeleteBridgeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge
func (c *MediaConnect) DeleteBridgeRequest(input *DeleteBridgeInput) (req *request.Request, output *DeleteBridgeOutput) {
	op := &request.Operation{
		Name:       opDeleteBridge,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/bridges/{bridgeArn}",
	}

	if input == nil {
		input = &DeleteBridgeInput{}
	}

	output = &DeleteBridgeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBridge API operation for AWS MediaConnect.
//
// Deletes a bridge. Before you can delete a bridge, you must stop the bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeleteBridge for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteBridge
func (c *MediaConnect) DeleteBridge(input *DeleteBridgeInput) (*DeleteBridgeOutput, error) {
	req, out := c.DeleteBridgeRequest(input)
	return out, req.Send()
}

// DeleteBridgeWithContext is the same as DeleteBridge with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBridge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeleteBridgeWithContext(ctx aws.Context, input *DeleteBridgeInput, opts ...request.Option) (*DeleteBridgeOutput, error) {
	req, out := c.DeleteBridgeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlow = "DeleteFlow"

// DeleteFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlow for more information on using the DeleteFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlowRequest method.
//	req, resp := client.DeleteFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlowRequest(input *DeleteFlowInput) (req *request.Request, output *DeleteFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DeleteFlowInput{}
	}

	output = &DeleteFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlow API operation for AWS MediaConnect.
//
// Deletes a flow. Before you can delete a flow, you must stop the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeleteFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlow(input *DeleteFlowInput) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	return out, req.Send()
}

// DeleteFlowWithContext is the same as DeleteFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeleteFlowWithContext(ctx aws.Context, input *DeleteFlowInput, opts ...request.Option) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGateway for more information on using the DeleteGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGatewayRequest method.
//	req, resp := client.DeleteGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway
func (c *MediaConnect) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/gateways/{gatewayArn}",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	output = &DeleteGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGateway API operation for AWS MediaConnect.
//
// Deletes a gateway. Before you can delete a gateway, you must deregister its
// instances and delete its bridges.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteGateway
func (c *MediaConnect) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	return out, req.Send()
}

// DeleteGatewayWithContext is the same as DeleteGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeleteGatewayWithContext(ctx aws.Context, input *DeleteGatewayInput, opts ...request.Option) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterGatewayInstance = "DeregisterGatewayInstance"

// DeregisterGatewayInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterGatewayInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterGatewayInstance for more information on using the DeregisterGatewayInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterGatewayInstanceRequest method.
//	req, resp := client.DeregisterGatewayInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance
func (c *MediaConnect) DeregisterGatewayInstanceRequest(input *DeregisterGatewayInstanceInput) (req *request.Request, output *DeregisterGatewayInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterGatewayInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/gateway-instances/{gatewayInstanceArn}",
	}

	if input == nil {
		input = &DeregisterGatewayInstanceInput{}
	}

	output = &DeregisterGatewayInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterGatewayInstance API operation for AWS MediaConnect.
//
// Deregisters an instance. Before you deregister an instance, all bridges running
// on the instance must be stopped. If you want to deregister an instance without
// stopping the bridges, you must use the --force option.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeregisterGatewayInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeregisterGatewayInstance
func (c *MediaConnect) DeregisterGatewayInstance(input *DeregisterGatewayInstanceInput) (*DeregisterGatewayInstanceOutput, error) {
	req, out := c.DeregisterGatewayInstanceRequest(input)
	return out, req.Send()
}

// DeregisterGatewayInstanceWithContext is the same as DeregisterGatewayInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterGatewayInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeregisterGatewayInstanceWithContext(ctx aws.Context, input *DeregisterGatewayInstanceInput, opts ...request.Option) (*DeregisterGatewayInstanceOutput, error) {
	req, out := c.DeregisterGatewayInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBridge = "DescribeBridge"

// DescribeBridgeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBridge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBridge for more information on using the DescribeBridge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBridgeRequest method.
//	req, resp := client.DescribeBridgeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge
func (c *MediaConnect) DescribeBridgeRequest(input *DescribeBridgeInput) (req *request.Request, output *DescribeBridgeOutput) {
	op := &request.Operation{
		Name:       opDescribeBridge,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/bridges/{bridgeArn}",
	}

	if input == nil {
		input = &DescribeBridgeInput{}
	}

	output = &DescribeBridgeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBridge API operation for AWS MediaConnect.
//
// Displays the details of a bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeBridge for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeBridge
func (c *MediaConnect) DescribeBridge(input *DescribeBridgeInput) (*DescribeBridgeOutput, error) {
	req, out := c.DescribeBridgeRequest(input)
	return out, req.Send()
}

// DescribeBridgeWithContext is the same as DescribeBridge with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBridge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeBridgeWithContext(ctx aws.Context, input *DescribeBridgeInput, opts ...request.Option) (*DescribeBridgeOutput, error) {
	req, out := c.DescribeBridgeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlow = "DescribeFlow"

// DescribeFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlow for more information on using the DescribeFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFlowRequest method.
//	req, resp := client.DescribeFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlowRequest(input *DescribeFlowInput) (req *request.Request, output *DescribeFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DescribeFlowInput{}
	}

	output = &DescribeFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlow API operation for AWS MediaConnect.
//
// Displays the details of a flow. The response includes the flow ARN, name,
// and Availability Zone, as well as details about the source, outputs, and
// entitlements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlow(input *DescribeFlowInput) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	return out, req.Send()
}

// DescribeFlowWithContext is the same as DescribeFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeFlowWithContext(ctx aws.Context, input *DescribeFlowInput, opts ...request.Option) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlowSourceMetadata = "DescribeFlowSourceMetadata"

// DescribeFlowSourceMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowSourceMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowSourceMetadata for more information on using the DescribeFlowSourceMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFlowSourceMetadataRequest method.
//	req, resp := client.DescribeFlowSourceMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata
func (c *MediaConnect) DescribeFlowSourceMetadataRequest(input *DescribeFlowSourceMetadataInput) (req *request.Request, output *DescribeFlowSourceMetadataOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowSourceMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows/{flowArn}/source-metadata",
	}

	if input == nil {
		input = &DescribeFlowSourceMetadataInput{}
	}

	output = &DescribeFlowSourceMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowSourceMetadata API operation for AWS MediaConnect.
//
// Displays details of the flow's source stream. The response contains information
// about the contents of the stream and its programs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeFlowSourceMetadata for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlowSourceMetadata
func (c *MediaConnect) DescribeFlowSourceMetadata(input *DescribeFlowSourceMetadataInput) (*DescribeFlowSourceMetadataOutput, error) {
	req, out := c.DescribeFlowSourceMetadataRequest(input)
	return out, req.Send()
}

// DescribeFlowSourceMetadataWithContext is the same as DescribeFlowSourceMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowSourceMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeFlowSourceMetadataWithContext(ctx aws.Context, input *DescribeFlowSourceMetadataInput, opts ...request.Option) (*DescribeFlowSourceMetadataOutput, error) {
	req, out := c.DescribeFlowSourceMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGateway = "DescribeGateway"

// DescribeGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGateway for more information on using the DescribeGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGatewayRequest method.
//	req, resp := client.DescribeGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway
func (c *MediaConnect) DescribeGatewayRequest(input *DescribeGatewayInput) (req *request.Request, output *DescribeGatewayOutput) {
	op := &request.Operation{
		Name:       opDescribeGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/gateways/{gatewayArn}",
	}

	if input == nil {
		input = &DescribeGatewayInput{}
	}

	output = &DescribeGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGateway API operation for AWS MediaConnect.
//
// Displays the details of a gateway. The response includes the gateway ARN,
// name, and CIDR blocks, as well as details about the networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeGateway for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGateway
func (c *MediaConnect) DescribeGateway(input *DescribeGatewayInput) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	return out, req.Send()
}

// DescribeGatewayWithContext is the same as DescribeGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeGatewayWithContext(ctx aws.Context, input *DescribeGatewayInput, opts ...request.Option) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayInstance = "DescribeGatewayInstance"

// DescribeGatewayInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGatewayInstance for more information on using the DescribeGatewayInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGatewayInstanceRequest method.
//	req, resp := client.DescribeGatewayInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance
func (c *MediaConnect) DescribeGatewayInstanceRequest(input *DescribeGatewayInstanceInput) (req *request.Request, output *DescribeGatewayInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/gateway-instances/{gatewayInstanceArn}",
	}

	if input == nil {
		input = &DescribeGatewayInstanceInput{}
	}

	output = &DescribeGatewayInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGatewayInstance API operation for AWS MediaConnect.
//
// Displays the details of an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeGatewayInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeGatewayInstance
func (c *MediaConnect) DescribeGatewayInstance(input *DescribeGatewayInstanceInput) (*DescribeGatewayInstanceOutput, error) {
	req, out := c.DescribeGatewayInstanceRequest(input)
	return out, req.Send()
}

// DescribeGatewayInstanceWithContext is the same as DescribeGatewayInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeGatewayInstanceWithContext(ctx aws.Context, input *DescribeGatewayInstanceInput, opts ...request.Option) (*DescribeGatewayInstanceOutput, error) {
	req, out := c.DescribeGatewayInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOffering = "DescribeOffering"

// DescribeOfferingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOffering for more information on using the DescribeOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOfferingRequest method.
//	req, resp := client.DescribeOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering
func (c *MediaConnect) DescribeOfferingRequest(input *DescribeOfferingInput) (req *request.Request, output *DescribeOfferingOutput) {
	op := &request.Operation{
		Name:       opDescribeOffering,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/offerings/{offeringArn}",
	}

	if input == nil {
		input = &DescribeOfferingInput{}
	}

	output = &DescribeOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOffering API operation for AWS MediaConnect.
//
// Displays the details of an offering. The response includes the offering description,
// duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeOffering for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeOffering
func (c *MediaConnect) DescribeOffering(input *DescribeOfferingInput) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	return out, req.Send()
}

// DescribeOfferingWithContext is the same as DescribeOffering with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeOfferingWithContext(ctx aws.Context, input *DescribeOfferingInput, opts ...request.Option) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservation = "DescribeReservation"

// DescribeReservationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservation for more information on using the DescribeReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservationRequest method.
//	req, resp := client.DescribeReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation
func (c *MediaConnect) DescribeReservationRequest(input *DescribeReservationInput) (req *request.Request, output *DescribeReservationOutput) {
	op := &request.Operation{
		Name:       opDescribeReservation,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/reservations/{reservationArn}",
	}

	if input == nil {
		input = &DescribeReservationInput{}
	}

	output = &DescribeReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservation API operation for AWS MediaConnect.
//
// Displays the details of a reservation. The response includes the reservation
// name, state, start date and time, and the details of the offering that make
// up the rest of the reservation (such as price, duration, and outbound bandwidth).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeReservation for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeReservation
func (c *MediaConnect) DescribeReservation(input *DescribeReservationInput) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	return out, req.Send()
}

// DescribeReservationWithContext is the same as DescribeReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeReservationWithContext(ctx aws.Context, input *DescribeReservationInput, opts ...request.Option) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantFlowEntitlements = "GrantFlowEntitlements"

// GrantFlowEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the GrantFlowEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantFlowEntitlements for more information on using the GrantFlowEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GrantFlowEntitlementsRequest method.
//	req, resp := client.GrantFlowEntitlementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlementsRequest(input *GrantFlowEntitlementsInput) (req *request.Request, output *GrantFlowEntitlementsOutput) {
	op := &request.Operation{
		Name:       opGrantFlowEntitlements,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements",
	}

	if input == nil {
		input = &GrantFlowEntitlementsInput{}
	}

	output = &GrantFlowEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GrantFlowEntitlements API operation for AWS MediaConnect.
//
// Grants entitlements to an existing flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation GrantFlowEntitlements for usage and error information.
//
// Returned Error Types:
//
//   - GrantFlowEntitlements420Exception
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlements(input *GrantFlowEntitlementsInput) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	return out, req.Send()
}

// GrantFlowEntitlementsWithContext is the same as GrantFlowEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See GrantFlowEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) GrantFlowEntitlementsWithContext(ctx aws.Context, input *GrantFlowEntitlementsInput, opts ...request.Option) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBridges = "ListBridges"

// ListBridgesRequest generates a "aws/request.Request" representing the
// client's request for the ListBridges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBridges for more information on using the ListBridges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBridgesRequest method.
//	req, resp := client.ListBridgesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges
func (c *MediaConnect) ListBridgesRequest(input *ListBridgesInput) (req *request.Request, output *ListBridgesOutput) {
	op := &request.Operation{
		Name:       opListBridges,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/bridges",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBridgesInput{}
	}

	output = &ListBridgesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBridges API operation for AWS MediaConnect.
//
// Displays a list of bridges that are associated with this account and an optionally
// specified Arn. This request returns a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListBridges for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListBridges
func (c *MediaConnect) ListBridges(input *ListBridgesInput) (*ListBridgesOutput, error) {
	req, out := c.ListBridgesRequest(input)
	return out, req.Send()
}

// ListBridgesWithContext is the same as ListBridges with the addition of
// the ability to pass a context and additional request options.
//
// See ListBridges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListBridgesWithContext(ctx aws.Context, input *ListBridgesInput, opts ...request.Option) (*ListBridgesOutput, error) {
	req, out := c.ListBridgesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBridgesPages iterates over the pages of a ListBridges operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBridges method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBridges operation.
//	pageNum := 0
//	err := client.ListBridgesPages(params,
//	    func(page *mediaconnect.ListBridgesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListBridgesPages(input *ListBridgesInput, fn func(*ListBridgesOutput, bool) bool) error {
	return c.ListBridgesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBridgesPagesWithContext same as ListBridgesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListBridgesPagesWithContext(ctx aws.Context, input *ListBridgesInput, fn func(*ListBridgesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBridgesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBridgesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBridgesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntitlements = "ListEntitlements"

// ListEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitlements for more information on using the ListEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntitlementsRequest method.
//	req, resp := client.ListEntitlementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlementsRequest(input *ListEntitlementsInput) (req *request.Request, output *ListEntitlementsOutput) {
	op := &request.Operation{
		Name:       opListEntitlements,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/entitlements",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitlementsInput{}
	}

	output = &ListEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitlements API operation for AWS MediaConnect.
//
// Displays a list of all entitlements that have been granted to this account.
// This request returns 20 results per page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListEntitlements for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlements(input *ListEntitlementsInput) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	return out, req.Send()
}

// ListEntitlementsWithContext is the same as ListEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListEntitlementsWithContext(ctx aws.Context, input *ListEntitlementsInput, opts ...request.Option) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitlementsPages iterates over the pages of a ListEntitlements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitlements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntitlements operation.
//	pageNum := 0
//	err := client.ListEntitlementsPages(params,
//	    func(page *mediaconnect.ListEntitlementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListEntitlementsPages(input *ListEntitlementsInput, fn func(*ListEntitlementsOutput, bool) bool) error {
	return c.ListEntitlementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitlementsPagesWithContext same as ListEntitlementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListEntitlementsPagesWithContext(ctx aws.Context, input *ListEntitlementsInput, fn func(*ListEntitlementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitlementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitlementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitlementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlows = "ListFlows"

// ListFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlows for more information on using the ListFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlowsRequest method.
//	req, resp := client.ListFlowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlowsRequest(input *ListFlowsInput) (req *request.Request, output *ListFlowsOutput) {
	op := &request.Operation{
		Name:       opListFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowsInput{}
	}

	output = &ListFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlows API operation for AWS MediaConnect.
//
// Displays a list of flows that are associated with this account. This request
// returns a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListFlows for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlows(input *ListFlowsInput) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	return out, req.Send()
}

// ListFlowsWithContext is the same as ListFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsWithContext(ctx aws.Context, input *ListFlowsInput, opts ...request.Option) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowsPages iterates over the pages of a ListFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlows operation.
//	pageNum := 0
//	err := client.ListFlowsPages(params,
//	    func(page *mediaconnect.ListFlowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListFlowsPages(input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool) error {
	return c.ListFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowsPagesWithContext same as ListFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsPagesWithContext(ctx aws.Context, input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGatewayInstances = "ListGatewayInstances"

// ListGatewayInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListGatewayInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGatewayInstances for more information on using the ListGatewayInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGatewayInstancesRequest method.
//	req, resp := client.ListGatewayInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances
func (c *MediaConnect) ListGatewayInstancesRequest(input *ListGatewayInstancesInput) (req *request.Request, output *ListGatewayInstancesOutput) {
	op := &request.Operation{
		Name:       opListGatewayInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/gateway-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewayInstancesInput{}
	}

	output = &ListGatewayInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGatewayInstances API operation for AWS MediaConnect.
//
// Displays a list of instances associated with the AWS account. This request
// returns a paginated result. You can use the filterArn property to display
// only the instances associated with the selected Gateway Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListGatewayInstances for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGatewayInstances
func (c *MediaConnect) ListGatewayInstances(input *ListGatewayInstancesInput) (*ListGatewayInstancesOutput, error) {
	req, out := c.ListGatewayInstancesRequest(input)
	return out, req.Send()
}

// ListGatewayInstancesWithContext is the same as ListGatewayInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListGatewayInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListGatewayInstancesWithContext(ctx aws.Context, input *ListGatewayInstancesInput, opts ...request.Option) (*ListGatewayInstancesOutput, error) {
	req, out := c.ListGatewayInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewayInstancesPages iterates over the pages of a ListGatewayInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGatewayInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGatewayInstances operation.
//	pageNum := 0
//	err := client.ListGatewayInstancesPages(params,
//	    func(page *mediaconnect.ListGatewayInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListGatewayInstancesPages(input *ListGatewayInstancesInput, fn func(*ListGatewayInstancesOutput, bool) bool) error {
	return c.ListGatewayInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewayInstancesPagesWithContext same as ListGatewayInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListGatewayInstancesPagesWithContext(ctx aws.Context, input *ListGatewayInstancesInput, fn func(*ListGatewayInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewayInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewayInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewayInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGateways for more information on using the ListGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGatewaysRequest method.
//	req, resp := client.ListGatewaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways
func (c *MediaConnect) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/gateways",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGateways API operation for AWS MediaConnect.
//
// Displays a list of gateways that are associated with this account. This request
// returns a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListGateways for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListGateways
func (c *MediaConnect) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGateways operation.
//	pageNum := 0
//	err := client.ListGatewaysPages(params,
//	    func(page *mediaconnect.ListGatewaysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOfferings = "ListOfferings"

// ListOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferings for more information on using the ListOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOfferingsRequest method.
//	req, resp := client.ListOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings
func (c *MediaConnect) ListOfferingsRequest(input *ListOfferingsInput) (req *request.Request, output *ListOfferingsOutput) {
	op := &request.Operation{
		Name:       opListOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/offerings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingsInput{}
	}

	output = &ListOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferings API operation for AWS MediaConnect.
//
// Displays a list of all offerings that are available to this account in the
// current AWS Region. If you have an active reservation (which means you've
// purchased an offering that has already started and hasn't expired yet), your
// account isn't eligible for other offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListOfferings for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListOfferings
func (c *MediaConnect) ListOfferings(input *ListOfferingsInput) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	return out, req.Send()
}

// ListOfferingsWithContext is the same as ListOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListOfferingsWithContext(ctx aws.Context, input *ListOfferingsInput, opts ...request.Option) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOfferingsPages iterates over the pages of a ListOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOfferings operation.
//	pageNum := 0
//	err := client.ListOfferingsPages(params,
//	    func(page *mediaconnect.ListOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListOfferingsPages(input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool) error {
	return c.ListOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOfferingsPagesWithContext same as ListOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListOfferingsPagesWithContext(ctx aws.Context, input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReservations = "ListReservations"

// ListReservationsRequest generates a "aws/request.Request" representing the
// client's request for the ListReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReservations for more information on using the ListReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReservationsRequest method.
//	req, resp := client.ListReservationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations
func (c *MediaConnect) ListReservationsRequest(input *ListReservationsInput) (req *request.Request, output *ListReservationsOutput) {
	op := &request.Operation{
		Name:       opListReservations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/reservations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReservationsInput{}
	}

	output = &ListReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReservations API operation for AWS MediaConnect.
//
// Displays a list of all reservations that have been purchased by this account
// in the current AWS Region. This list includes all reservations in all states
// (such as active and expired).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListReservations for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListReservations
func (c *MediaConnect) ListReservations(input *ListReservationsInput) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	return out, req.Send()
}

// ListReservationsWithContext is the same as ListReservations with the addition of
// the ability to pass a context and additional request options.
//
// See ListReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListReservationsWithContext(ctx aws.Context, input *ListReservationsInput, opts ...request.Option) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReservationsPages iterates over the pages of a ListReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReservations operation.
//	pageNum := 0
//	err := client.ListReservationsPages(params,
//	    func(page *mediaconnect.ListReservationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaConnect) ListReservationsPages(input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool) error {
	return c.ListReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReservationsPagesWithContext same as ListReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListReservationsPagesWithContext(ctx aws.Context, input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource
func (c *MediaConnect) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS MediaConnect.
//
// # List all tags on an AWS Elemental MediaConnect resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource
func (c *MediaConnect) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseOffering for more information on using the PurchaseOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PurchaseOfferingRequest method.
//	req, resp := client.PurchaseOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering
func (c *MediaConnect) PurchaseOfferingRequest(input *PurchaseOfferingInput) (req *request.Request, output *PurchaseOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/offerings/{offeringArn}",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	output = &PurchaseOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseOffering API operation for AWS MediaConnect.
//
// Submits a request to purchase an offering. If you already have an active
// reservation, you can't purchase another offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation PurchaseOffering for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/PurchaseOffering
func (c *MediaConnect) PurchaseOffering(input *PurchaseOfferingInput) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	return out, req.Send()
}

// PurchaseOfferingWithContext is the same as PurchaseOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) PurchaseOfferingWithContext(ctx aws.Context, input *PurchaseOfferingInput, opts ...request.Option) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveBridgeOutput = "RemoveBridgeOutput"

// RemoveBridgeOutputRequest generates a "aws/request.Request" representing the
// client's request for the RemoveBridgeOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveBridgeOutput for more information on using the RemoveBridgeOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveBridgeOutputRequest method.
//	req, resp := client.RemoveBridgeOutputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput
func (c *MediaConnect) RemoveBridgeOutputRequest(input *RemoveBridgeOutputInput) (req *request.Request, output *RemoveBridgeOutputOutput) {
	op := &request.Operation{
		Name:       opRemoveBridgeOutput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/bridges/{bridgeArn}/outputs/{outputName}",
	}

	if input == nil {
		input = &RemoveBridgeOutputInput{}
	}

	output = &RemoveBridgeOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveBridgeOutput API operation for AWS MediaConnect.
//
// Removes an output from a bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveBridgeOutput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeOutput
func (c *MediaConnect) RemoveBridgeOutput(input *RemoveBridgeOutputInput) (*RemoveBridgeOutputOutput, error) {
	req, out := c.RemoveBridgeOutputRequest(input)
	return out, req.Send()
}

// RemoveBridgeOutputWithContext is the same as RemoveBridgeOutput with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveBridgeOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveBridgeOutputWithContext(ctx aws.Context, input *RemoveBridgeOutputInput, opts ...request.Option) (*RemoveBridgeOutputOutput, error) {
	req, out := c.RemoveBridgeOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveBridgeSource = "RemoveBridgeSource"

// RemoveBridgeSourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveBridgeSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveBridgeSource for more information on using the RemoveBridgeSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveBridgeSourceRequest method.
//	req, resp := client.RemoveBridgeSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource
func (c *MediaConnect) RemoveBridgeSourceRequest(input *RemoveBridgeSourceInput) (req *request.Request, output *RemoveBridgeSourceOutput) {
	op := &request.Operation{
		Name:       opRemoveBridgeSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/bridges/{bridgeArn}/sources/{sourceName}",
	}

	if input == nil {
		input = &RemoveBridgeSourceInput{}
	}

	output = &RemoveBridgeSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveBridgeSource API operation for AWS MediaConnect.
//
// Removes a source from a bridge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveBridgeSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveBridgeSource
func (c *MediaConnect) RemoveBridgeSource(input *RemoveBridgeSourceInput) (*RemoveBridgeSourceOutput, error) {
	req, out := c.RemoveBridgeSourceRequest(input)
	return out, req.Send()
}

// RemoveBridgeSourceWithContext is the same as RemoveBridgeSource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveBridgeSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveBridgeSourceWithContext(ctx aws.Context, input *RemoveBridgeSourceInput, opts ...request.Option) (*RemoveBridgeSourceOutput, error) {
	req, out := c.RemoveBridgeSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowMediaStream = "RemoveFlowMediaStream"

// RemoveFlowMediaStreamRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowMediaStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowMediaStream for more information on using the RemoveFlowMediaStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveFlowMediaStreamRequest method.
//	req, resp := client.RemoveFlowMediaStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream
func (c *MediaConnect) RemoveFlowMediaStreamRequest(input *RemoveFlowMediaStreamInput) (req *request.Request, output *RemoveFlowMediaStreamOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowMediaStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/mediaStreams/{mediaStreamName}",
	}

	if input == nil {
		input = &RemoveFlowMediaStreamInput{}
	}

	output = &RemoveFlowMediaStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowMediaStream API operation for AWS MediaConnect.
//
// Removes a media stream from a flow. This action is only available if the
// media stream is not associated with a source or output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowMediaStream for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowMediaStream
func (c *MediaConnect) RemoveFlowMediaStream(input *RemoveFlowMediaStreamInput) (*RemoveFlowMediaStreamOutput, error) {
	req, out := c.RemoveFlowMediaStreamRequest(input)
	return out, req.Send()
}

// RemoveFlowMediaStreamWithContext is the same as RemoveFlowMediaStream with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowMediaStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowMediaStreamWithContext(ctx aws.Context, input *RemoveFlowMediaStreamInput, opts ...request.Option) (*RemoveFlowMediaStreamOutput, error) {
	req, out := c.RemoveFlowMediaStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowOutput = "RemoveFlowOutput"

// RemoveFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowOutput for more information on using the RemoveFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveFlowOutputRequest method.
//	req, resp := client.RemoveFlowOutputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutputRequest(input *RemoveFlowOutputInput) (req *request.Request, output *RemoveFlowOutputOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowOutput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &RemoveFlowOutputInput{}
	}

	output = &RemoveFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowOutput API operation for AWS MediaConnect.
//
// Removes an output from an existing flow. This request can be made only on
// an output that does not have an entitlement associated with it. If the output
// has an entitlement, you must revoke the entitlement instead. When an entitlement
// is revoked from a flow, the service automatically removes the associated
// output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowOutput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutput(input *RemoveFlowOutputInput) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	return out, req.Send()
}

// RemoveFlowOutputWithContext is the same as RemoveFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowOutputWithContext(ctx aws.Context, input *RemoveFlowOutputInput, opts ...request.Option) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowSource = "RemoveFlowSource"

// RemoveFlowSourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowSource for more information on using the RemoveFlowSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveFlowSourceRequest method.
//	req, resp := client.RemoveFlowSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource
func (c *MediaConnect) RemoveFlowSourceRequest(input *RemoveFlowSourceInput) (req *request.Request, output *RemoveFlowSourceOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/source/{sourceArn}",
	}

	if input == nil {
		input = &RemoveFlowSourceInput{}
	}

	output = &RemoveFlowSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowSource API operation for AWS MediaConnect.
//
// Removes a source from an existing flow. This request can be made only if
// there is more than one source on the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource
func (c *MediaConnect) RemoveFlowSource(input *RemoveFlowSourceInput) (*RemoveFlowSourceOutput, error) {
	req, out := c.RemoveFlowSourceRequest(input)
	return out, req.Send()
}

// RemoveFlowSourceWithContext is the same as RemoveFlowSource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowSourceWithContext(ctx aws.Context, input *RemoveFlowSourceInput, opts ...request.Option) (*RemoveFlowSourceOutput, error) {
	req, out := c.RemoveFlowSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowVpcInterface = "RemoveFlowVpcInterface"

// RemoveFlowVpcInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowVpcInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowVpcInterface for more information on using the RemoveFlowVpcInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveFlowVpcInterfaceRequest method.
//	req, resp := client.RemoveFlowVpcInterfaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface
func (c *MediaConnect) RemoveFlowVpcInterfaceRequest(input *RemoveFlowVpcInterfaceInput) (req *request.Request, output *RemoveFlowVpcInterfaceOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowVpcInterface,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/vpcInterfaces/{vpcInterfaceName}",
	}

	if input == nil {
		input = &RemoveFlowVpcInterfaceInput{}
	}

	output = &RemoveFlowVpcInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowVpcInterface API operation for AWS MediaConnect.
//
// Removes a VPC Interface from an existing flow. This request can be made only
// on a VPC interface that does not have a Source or Output associated with
// it. If the VPC interface is referenced by a Source or Output, you must first
// delete or update the Source or Output to no longer reference the VPC interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowVpcInterface for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface
func (c *MediaConnect) RemoveFlowVpcInterface(input *RemoveFlowVpcInterfaceInput) (*RemoveFlowVpcInterfaceOutput, error) {
	req, out := c.RemoveFlowVpcInterfaceRequest(input)
	return out, req.Send()
}

// RemoveFlowVpcInterfaceWithContext is the same as RemoveFlowVpcInterface with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowVpcInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowVpcInterfaceWithContext(ctx aws.Context, input *RemoveFlowVpcInterfaceInput, opts ...request.Option) (*RemoveFlowVpcInterfaceOutput, error) {
	req, out := c.RemoveFlowVpcInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeFlowEntitlement = "RevokeFlowEntitlement"

// RevokeFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the RevokeFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeFlowEntitlement for more information on using the RevokeFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokeFlowEntitlementRequest method.
//	req, resp := client.RevokeFlowEntitlementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlementRequest(input *RevokeFlowEntitlementInput) (req *request.Request, output *RevokeFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opRevokeFlowEntitlement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &RevokeFlowEntitlementInput{}
	}

	output = &RevokeFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeFlowEntitlement API operation for AWS MediaConnect.
//
// Revokes an entitlement from a flow. Once an entitlement is revoked, the content
// becomes unavailable to the subscriber and the associated output is removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RevokeFlowEntitlement for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlement(input *RevokeFlowEntitlementInput) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	return out, req.Send()
}

// RevokeFlowEntitlementWithContext is the same as RevokeFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RevokeFlowEntitlementWithContext(ctx aws.Context, input *RevokeFlowEntitlementInput, opts ...request.Option) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFlow = "StartFlow"

// StartFlowRequest generates a "aws/request.Request" representing the
// client's request for the StartFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFlow for more information on using the StartFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFlowRequest method.
//	req, resp := client.StartFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlowRequest(input *StartFlowInput) (req *request.Request, output *StartFlowOutput) {
	op := &request.Operation{
		Name:       opStartFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/start/{flowArn}",
	}

	if input == nil {
		input = &StartFlowInput{}
	}

	output = &StartFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFlow API operation for AWS MediaConnect.
//
// Starts a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StartFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlow(input *StartFlowInput) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	return out, req.Send()
}

// StartFlowWithContext is the same as StartFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StartFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StartFlowWithContext(ctx aws.Context, input *StartFlowInput, opts ...request.Option) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFlow = "StopFlow"

// StopFlowRequest generates a "aws/request.Request" representing the
// client's request for the StopFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFlow for more information on using the StopFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopFlowRequest method.
//	req, resp := client.StopFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlowRequest(input *StopFlowInput) (req *request.Request, output *StopFlowOutput) {
	op := &request.Operation{
		Name:       opStopFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/stop/{flowArn}",
	}

	if input == nil {
		input = &StopFlowInput{}
	}

	output = &StopFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFlow API operation for AWS MediaConnect.
//
// Stops a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StopFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlow(input *StopFlowInput) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	return out, req.Send()
}

// StopFlowWithContext is the same as StopFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StopFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StopFlowWithContext(ctx aws.Context, input *StopFlowInput, opts ...request.Option) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource
func (c *MediaConnect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS MediaConnect.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource
func (c *MediaConnect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource
func (c *MediaConnect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS MediaConnect.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource
func (c *MediaConnect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBridge = "UpdateBridge"

// UpdateBridgeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBridge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBridge for more information on using the UpdateBridge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBridgeRequest method.
//	req, resp := client.UpdateBridgeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge
func (c *MediaConnect) UpdateBridgeRequest(input *UpdateBridgeInput) (req *request.Request, output *UpdateBridgeOutput) {
	op := &request.Operation{
		Name:       opUpdateBridge,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/bridges/{bridgeArn}",
	}

	if input == nil {
		input = &UpdateBridgeInput{}
	}

	output = &UpdateBridgeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBridge API operation for AWS MediaConnect.
//
// # Updates the bridge
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateBridge for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridge
func (c *MediaConnect) UpdateBridge(input *UpdateBridgeInput) (*UpdateBridgeOutput, error) {
	req, out := c.UpdateBridgeRequest(input)
	return out, req.Send()
}

// UpdateBridgeWithContext is the same as UpdateBridge with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBridge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateBridgeWithContext(ctx aws.Context, input *UpdateBridgeInput, opts ...request.Option) (*UpdateBridgeOutput, error) {
	req, out := c.UpdateBridgeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBridgeOutput = "UpdateBridgeOutput"

// UpdateBridgeOutputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBridgeOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBridgeOutput for more information on using the UpdateBridgeOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBridgeOutputRequest method.
//	req, resp := client.UpdateBridgeOutputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput
func (c *MediaConnect) UpdateBridgeOutputRequest(input *UpdateBridgeOutputInput) (req *request.Request, output *UpdateBridgeOutputOutput) {
	op := &request.Operation{
		Name:       opUpdateBridgeOutput,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/bridges/{bridgeArn}/outputs/{outputName}",
	}

	if input == nil {
		input = &UpdateBridgeOutputInput{}
	}

	output = &UpdateBridgeOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBridgeOutput API operation for AWS MediaConnect.
//
// Updates an existing bridge output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateBridgeOutput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeOutput
func (c *MediaConnect) UpdateBridgeOutput(input *UpdateBridgeOutputInput) (*UpdateBridgeOutputOutput, error) {
	req, out := c.UpdateBridgeOutputRequest(input)
	return out, req.Send()
}

// UpdateBridgeOutputWithContext is the same as UpdateBridgeOutput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBridgeOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateBridgeOutputWithContext(ctx aws.Context, input *UpdateBridgeOutputInput, opts ...request.Option) (*UpdateBridgeOutputOutput, error) {
	req, out := c.UpdateBridgeOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBridgeSource = "UpdateBridgeSource"

// UpdateBridgeSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBridgeSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBridgeSource for more information on using the UpdateBridgeSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBridgeSourceRequest method.
//	req, resp := client.UpdateBridgeSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource
func (c *MediaConnect) UpdateBridgeSourceRequest(input *UpdateBridgeSourceInput) (req *request.Request, output *UpdateBridgeSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateBridgeSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/bridges/{bridgeArn}/sources/{sourceName}",
	}

	if input == nil {
		input = &UpdateBridgeSourceInput{}
	}

	output = &UpdateBridgeSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBridgeSource API operation for AWS MediaConnect.
//
// Updates an existing bridge source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateBridgeSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeSource
func (c *MediaConnect) UpdateBridgeSource(input *UpdateBridgeSourceInput) (*UpdateBridgeSourceOutput, error) {
	req, out := c.UpdateBridgeSourceRequest(input)
	return out, req.Send()
}

// UpdateBridgeSourceWithContext is the same as UpdateBridgeSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBridgeSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateBridgeSourceWithContext(ctx aws.Context, input *UpdateBridgeSourceInput, opts ...request.Option) (*UpdateBridgeSourceOutput, error) {
	req, out := c.UpdateBridgeSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBridgeState = "UpdateBridgeState"

// UpdateBridgeStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBridgeState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBridgeState for more information on using the UpdateBridgeState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBridgeStateRequest method.
//	req, resp := client.UpdateBridgeStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState
func (c *MediaConnect) UpdateBridgeStateRequest(input *UpdateBridgeStateInput) (req *request.Request, output *UpdateBridgeStateOutput) {
	op := &request.Operation{
		Name:       opUpdateBridgeState,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/bridges/{bridgeArn}/state",
	}

	if input == nil {
		input = &UpdateBridgeStateInput{}
	}

	output = &UpdateBridgeStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBridgeState API operation for AWS MediaConnect.
//
// # Updates the bridge state
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateBridgeState for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateBridgeState
func (c *MediaConnect) UpdateBridgeState(input *UpdateBridgeStateInput) (*UpdateBridgeStateOutput, error) {
	req, out := c.UpdateBridgeStateRequest(input)
	return out, req.Send()
}

// UpdateBridgeStateWithContext is the same as UpdateBridgeState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBridgeState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateBridgeStateWithContext(ctx aws.Context, input *UpdateBridgeStateInput, opts ...request.Option) (*UpdateBridgeStateOutput, error) {
	req, out := c.UpdateBridgeStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlow = "UpdateFlow"

// UpdateFlowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlow for more information on using the UpdateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowRequest method.
//	req, resp := client.UpdateFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow
func (c *MediaConnect) UpdateFlowRequest(input *UpdateFlowInput) (req *request.Request, output *UpdateFlowOutput) {
	op := &request.Operation{
		Name:       opUpdateFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &UpdateFlowInput{}
	}

	output = &UpdateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlow API operation for AWS MediaConnect.
//
// # Updates flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow
func (c *MediaConnect) UpdateFlow(input *UpdateFlowInput) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	return out, req.Send()
}

// UpdateFlowWithContext is the same as UpdateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowWithContext(ctx aws.Context, input *UpdateFlowInput, opts ...request.Option) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowEntitlement = "UpdateFlowEntitlement"

// UpdateFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowEntitlement for more information on using the UpdateFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowEntitlementRequest method.
//	req, resp := client.UpdateFlowEntitlementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlementRequest(input *UpdateFlowEntitlementInput) (req *request.Request, output *UpdateFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowEntitlement,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &UpdateFlowEntitlementInput{}
	}

	output = &UpdateFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowEntitlement API operation for AWS MediaConnect.
//
// You can change an entitlement's description, subscribers, and encryption.
// If you change the subscribers, the service will remove the outputs that are
// are used by the subscribers that are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowEntitlement for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlement(input *UpdateFlowEntitlementInput) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	return out, req.Send()
}

// UpdateFlowEntitlementWithContext is the same as UpdateFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowEntitlementWithContext(ctx aws.Context, input *UpdateFlowEntitlementInput, opts ...request.Option) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowMediaStream = "UpdateFlowMediaStream"

// UpdateFlowMediaStreamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowMediaStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowMediaStream for more information on using the UpdateFlowMediaStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowMediaStreamRequest method.
//	req, resp := client.UpdateFlowMediaStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream
func (c *MediaConnect) UpdateFlowMediaStreamRequest(input *UpdateFlowMediaStreamInput) (req *request.Request, output *UpdateFlowMediaStreamOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowMediaStream,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/mediaStreams/{mediaStreamName}",
	}

	if input == nil {
		input = &UpdateFlowMediaStreamInput{}
	}

	output = &UpdateFlowMediaStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowMediaStream API operation for AWS MediaConnect.
//
// Updates an existing media stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowMediaStream for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowMediaStream
func (c *MediaConnect) UpdateFlowMediaStream(input *UpdateFlowMediaStreamInput) (*UpdateFlowMediaStreamOutput, error) {
	req, out := c.UpdateFlowMediaStreamRequest(input)
	return out, req.Send()
}

// UpdateFlowMediaStreamWithContext is the same as UpdateFlowMediaStream with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowMediaStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowMediaStreamWithContext(ctx aws.Context, input *UpdateFlowMediaStreamInput, opts ...request.Option) (*UpdateFlowMediaStreamOutput, error) {
	req, out := c.UpdateFlowMediaStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowOutput = "UpdateFlowOutput"

// UpdateFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowOutput for more information on using the UpdateFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowOutputRequest method.
//	req, resp := client.UpdateFlowOutputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutputRequest(input *UpdateFlowOutputInput) (req *request.Request, output *UpdateFlowOutputOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowOutput,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &UpdateFlowOutputInput{}
	}

	output = &UpdateFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowOutput API operation for AWS MediaConnect.
//
// Updates an existing flow output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowOutput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutput(input *UpdateFlowOutputInput) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	return out, req.Send()
}

// UpdateFlowOutputWithContext is the same as UpdateFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowOutputWithContext(ctx aws.Context, input *UpdateFlowOutputInput, opts ...request.Option) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowSource = "UpdateFlowSource"

// UpdateFlowSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowSource for more information on using the UpdateFlowSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowSourceRequest method.
//	req, resp := client.UpdateFlowSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSourceRequest(input *UpdateFlowSourceInput) (req *request.Request, output *UpdateFlowSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/source/{sourceArn}",
	}

	if input == nil {
		input = &UpdateFlowSourceInput{}
	}

	output = &UpdateFlowSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowSource API operation for AWS MediaConnect.
//
// Updates the source of a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowSource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSource(input *UpdateFlowSourceInput) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	return out, req.Send()
}

// UpdateFlowSourceWithContext is the same as UpdateFlowSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowSourceWithContext(ctx aws.Context, input *UpdateFlowSourceInput, opts ...request.Option) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayInstance = "UpdateGatewayInstance"

// UpdateGatewayInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayInstance for more information on using the UpdateGatewayInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGatewayInstanceRequest method.
//	req, resp := client.UpdateGatewayInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance
func (c *MediaConnect) UpdateGatewayInstanceRequest(input *UpdateGatewayInstanceInput) (req *request.Request, output *UpdateGatewayInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayInstance,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/gateway-instances/{gatewayInstanceArn}",
	}

	if input == nil {
		input = &UpdateGatewayInstanceInput{}
	}

	output = &UpdateGatewayInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewayInstance API operation for AWS MediaConnect.
//
// Updates the configuration of an existing Gateway Instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateGatewayInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - InternalServerErrorException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ForbiddenException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - NotFoundException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ServiceUnavailableException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - TooManyRequestsException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
//   - ConflictException
//     Exception raised by AWS Elemental MediaConnect. See the error message and
//     documentation for the operation for more information on the cause of this
//     exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateGatewayInstance
func (c *MediaConnect) UpdateGatewayInstance(input *UpdateGatewayInstanceInput) (*UpdateGatewayInstanceOutput, error) {
	req, out := c.UpdateGatewayInstanceRequest(input)
	return out, req.Send()
}

// UpdateGatewayInstanceWithContext is the same as UpdateGatewayInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateGatewayInstanceWithContext(ctx aws.Context, input *UpdateGatewayInstanceInput, opts ...request.Option) (*UpdateGatewayInstanceOutput, error) {
	req, out := c.UpdateGatewayInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Add a flow source to an existing bridge.
type AddBridgeFlowSourceRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the cloud flow to use as a source of
	// this bridge.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the VPC interface attachment to use for this source.
	FlowVpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"flowVpcInterfaceAttachment" type:"structure"`

	// The name of the flow source. This name is used to reference the source and
	// must be unique among sources in this bridge.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeFlowSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeFlowSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeFlowSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeFlowSourceRequest"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddBridgeFlowSourceRequest) SetFlowArn(v string) *AddBridgeFlowSourceRequest {
	s.FlowArn = &v
	return s
}

// SetFlowVpcInterfaceAttachment sets the FlowVpcInterfaceAttachment field's value.
func (s *AddBridgeFlowSourceRequest) SetFlowVpcInterfaceAttachment(v *VpcInterfaceAttachment) *AddBridgeFlowSourceRequest {
	s.FlowVpcInterfaceAttachment = v
	return s
}

// SetName sets the Name field's value.
func (s *AddBridgeFlowSourceRequest) SetName(v string) *AddBridgeFlowSourceRequest {
	s.Name = &v
	return s
}

// Add a network output to an existing bridge.
type AddBridgeNetworkOutputRequest struct {
	_ struct{} `type:"structure"`

	// The network output IP Address.
	//
	// IpAddress is a required field
	IpAddress *string `locationName:"ipAddress" type:"string" required:"true"`

	// The network output name. This name is used to reference the output and must
	// be unique among outputs in this bridge.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The network output's gateway network name.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" type:"string" required:"true"`

	// The network output port.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`

	// The network output protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The network output TTL.
	//
	// Ttl is a required field
	Ttl *int64 `locationName:"ttl" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeNetworkOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeNetworkOutputRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeNetworkOutputRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeNetworkOutputRequest"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Ttl == nil {
		invalidParams.Add(request.NewErrParamRequired("Ttl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *AddBridgeNetworkOutputRequest) SetIpAddress(v string) *AddBridgeNetworkOutputRequest {
	s.IpAddress = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddBridgeNetworkOutputRequest) SetName(v string) *AddBridgeNetworkOutputRequest {
	s.Name = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *AddBridgeNetworkOutputRequest) SetNetworkName(v string) *AddBridgeNetworkOutputRequest {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddBridgeNetworkOutputRequest) SetPort(v int64) *AddBridgeNetworkOutputRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AddBridgeNetworkOutputRequest) SetProtocol(v string) *AddBridgeNetworkOutputRequest {
	s.Protocol = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *AddBridgeNetworkOutputRequest) SetTtl(v int64) *AddBridgeNetworkOutputRequest {
	s.Ttl = &v
	return s
}

// Add a network source to an existing bridge.
type AddBridgeNetworkSourceRequest struct {
	_ struct{} `type:"structure"`

	// The network source multicast IP.
	//
	// MulticastIp is a required field
	MulticastIp *string `locationName:"multicastIp" type:"string" required:"true"`

	// The name of the network source. This name is used to reference the source
	// and must be unique among sources in this bridge.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The network source's gateway network name.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" type:"string" required:"true"`

	// The network source port.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`

	// The network source protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeNetworkSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeNetworkSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeNetworkSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeNetworkSourceRequest"}
	if s.MulticastIp == nil {
		invalidParams.Add(request.NewErrParamRequired("MulticastIp"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMulticastIp sets the MulticastIp field's value.
func (s *AddBridgeNetworkSourceRequest) SetMulticastIp(v string) *AddBridgeNetworkSourceRequest {
	s.MulticastIp = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddBridgeNetworkSourceRequest) SetName(v string) *AddBridgeNetworkSourceRequest {
	s.Name = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *AddBridgeNetworkSourceRequest) SetNetworkName(v string) *AddBridgeNetworkSourceRequest {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddBridgeNetworkSourceRequest) SetPort(v int64) *AddBridgeNetworkSourceRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AddBridgeNetworkSourceRequest) SetProtocol(v string) *AddBridgeNetworkSourceRequest {
	s.Protocol = &v
	return s
}

// Add an output to a bridge.
type AddBridgeOutputRequest struct {
	_ struct{} `type:"structure"`

	// Add a network output to an existing bridge.
	NetworkOutput *AddBridgeNetworkOutputRequest `locationName:"networkOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeOutputRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeOutputRequest"}
	if s.NetworkOutput != nil {
		if err := s.NetworkOutput.Validate(); err != nil {
			invalidParams.AddNested("NetworkOutput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkOutput sets the NetworkOutput field's value.
func (s *AddBridgeOutputRequest) SetNetworkOutput(v *AddBridgeNetworkOutputRequest) *AddBridgeOutputRequest {
	s.NetworkOutput = v
	return s
}

// Adds outputs to an existing bridge. You can create up to 2 outputs per bridge.
type AddBridgeOutputsInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// The outputs that you want to add to this bridge.
	//
	// Outputs is a required field
	Outputs []*AddBridgeOutputRequest `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeOutputsInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *AddBridgeOutputsInput) SetBridgeArn(v string) *AddBridgeOutputsInput {
	s.BridgeArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddBridgeOutputsInput) SetOutputs(v []*AddBridgeOutputRequest) *AddBridgeOutputsInput {
	s.Outputs = v
	return s
}

// The result of a successful AddBridgeOutputs request.
type AddBridgeOutputsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The outputs that you added to this bridge.
	Outputs []*BridgeOutput_ `locationName:"outputs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeOutputsOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *AddBridgeOutputsOutput) SetBridgeArn(v string) *AddBridgeOutputsOutput {
	s.BridgeArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddBridgeOutputsOutput) SetOutputs(v []*BridgeOutput_) *AddBridgeOutputsOutput {
	s.Outputs = v
	return s
}

// Add a source to an existing bridge.
type AddBridgeSourceRequest struct {
	_ struct{} `type:"structure"`

	// Add a flow source to an existing bridge.
	FlowSource *AddBridgeFlowSourceRequest `locationName:"flowSource" type:"structure"`

	// Add a network source to an existing bridge.
	NetworkSource *AddBridgeNetworkSourceRequest `locationName:"networkSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeSourceRequest"}
	if s.FlowSource != nil {
		if err := s.FlowSource.Validate(); err != nil {
			invalidParams.AddNested("FlowSource", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkSource != nil {
		if err := s.NetworkSource.Validate(); err != nil {
			invalidParams.AddNested("NetworkSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowSource sets the FlowSource field's value.
func (s *AddBridgeSourceRequest) SetFlowSource(v *AddBridgeFlowSourceRequest) *AddBridgeSourceRequest {
	s.FlowSource = v
	return s
}

// SetNetworkSource sets the NetworkSource field's value.
func (s *AddBridgeSourceRequest) SetNetworkSource(v *AddBridgeNetworkSourceRequest) *AddBridgeSourceRequest {
	s.NetworkSource = v
	return s
}

// Add sources to an existing bridge. You can create up to 2 sources per bridge.
type AddBridgeSourcesInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// The sources that you want to add to this bridge.
	//
	// Sources is a required field
	Sources []*AddBridgeSourceRequest `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddBridgeSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddBridgeSourcesInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *AddBridgeSourcesInput) SetBridgeArn(v string) *AddBridgeSourcesInput {
	s.BridgeArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddBridgeSourcesInput) SetSources(v []*AddBridgeSourceRequest) *AddBridgeSourcesInput {
	s.Sources = v
	return s
}

// The result of a successful AddBridgeSources request.
type AddBridgeSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The sources that you added to this bridge.
	Sources []*BridgeSource `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddBridgeSourcesOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *AddBridgeSourcesOutput) SetBridgeArn(v string) *AddBridgeSourcesOutput {
	s.BridgeArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddBridgeSourcesOutput) SetSources(v []*BridgeSource) *AddBridgeSourcesOutput {
	s.Sources = v
	return s
}

type AddEgressGatewayBridgeRequest struct {
	_ struct{} `type:"structure"`

	// The maximum expected bitrate (in bps).
	//
	// MaxBitrate is a required field
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEgressGatewayBridgeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEgressGatewayBridgeRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddEgressGatewayBridgeRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddEgressGatewayBridgeRequest"}
	if s.MaxBitrate == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxBitrate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *AddEgressGatewayBridgeRequest) SetMaxBitrate(v int64) *AddEgressGatewayBridgeRequest {
	s.MaxBitrate = &v
	return s
}

// Adds media streams to an existing flow.
type AddFlowMediaStreamsInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The media streams that you want to add to the flow.
	//
	// MediaStreams is a required field
	MediaStreams []*AddMediaStreamRequest `locationName:"mediaStreams" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowMediaStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowMediaStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowMediaStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowMediaStreamsInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.MediaStreams == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreams"))
	}
	if s.MediaStreams != nil {
		for i, v := range s.MediaStreams {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreams", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowMediaStreamsInput) SetFlowArn(v string) *AddFlowMediaStreamsInput {
	s.FlowArn = &v
	return s
}

// SetMediaStreams sets the MediaStreams field's value.
func (s *AddFlowMediaStreamsInput) SetMediaStreams(v []*AddMediaStreamRequest) *AddFlowMediaStreamsInput {
	s.MediaStreams = v
	return s
}

// The result of a successful AddFlowMediaStreams request. The response includes
// the details of the newly added media streams.
type AddFlowMediaStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you added media streams to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The media streams that you added to the flow.
	MediaStreams []*MediaStream `locationName:"mediaStreams" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowMediaStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowMediaStreamsOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowMediaStreamsOutput) SetFlowArn(v string) *AddFlowMediaStreamsOutput {
	s.FlowArn = &v
	return s
}

// SetMediaStreams sets the MediaStreams field's value.
func (s *AddFlowMediaStreamsOutput) SetMediaStreams(v []*MediaStream) *AddFlowMediaStreamsOutput {
	s.MediaStreams = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type AddFlowOutputs420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputs420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputs420Exception) GoString() string {
	return s.String()
}

func newErrorAddFlowOutputs420Exception(v protocol.ResponseMetadata) error {
	return &AddFlowOutputs420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AddFlowOutputs420Exception) Code() string {
	return "AddFlowOutputs420Exception"
}

// Message returns the exception's message.
func (s *AddFlowOutputs420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AddFlowOutputs420Exception) OrigErr() error {
	return nil
}

func (s *AddFlowOutputs420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AddFlowOutputs420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AddFlowOutputs420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
type AddFlowOutputsInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of outputs that you want to add.
	//
	// Outputs is a required field
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowOutputsInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsInput) SetFlowArn(v string) *AddFlowOutputsInput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsInput) SetOutputs(v []*AddOutputRequest) *AddFlowOutputsInput {
	s.Outputs = v
	return s
}

// The result of a successful AddOutput request. The response includes the details
// of the newly added outputs.
type AddFlowOutputsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these outputs were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added outputs.
	Outputs []*Output `locationName:"outputs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowOutputsOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsOutput) SetFlowArn(v string) *AddFlowOutputsOutput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsOutput) SetOutputs(v []*Output) *AddFlowOutputsOutput {
	s.Outputs = v
	return s
}

// Adds sources to an existing flow.
type AddFlowSourcesInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of sources that you want to add.
	//
	// Sources is a required field
	Sources []*SetSourceRequest `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowSourcesInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowSourcesInput) SetFlowArn(v string) *AddFlowSourcesInput {
	s.FlowArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddFlowSourcesInput) SetSources(v []*SetSourceRequest) *AddFlowSourcesInput {
	s.Sources = v
	return s
}

// The result of a successful AddFlowSources request. The response includes
// the details of the newly added sources.
type AddFlowSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these sources were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added sources.
	Sources []*Source `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowSourcesOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowSourcesOutput) SetFlowArn(v string) *AddFlowSourcesOutput {
	s.FlowArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddFlowSourcesOutput) SetSources(v []*Source) *AddFlowSourcesOutput {
	s.Sources = v
	return s
}

// Adds VPC interfaces to an existing flow.
type AddFlowVpcInterfacesInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of VPC interfaces that you want to add.
	//
	// VpcInterfaces is a required field
	VpcInterfaces []*VpcInterfaceRequest `locationName:"vpcInterfaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowVpcInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowVpcInterfacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowVpcInterfacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowVpcInterfacesInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.VpcInterfaces == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcInterfaces"))
	}
	if s.VpcInterfaces != nil {
		for i, v := range s.VpcInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowVpcInterfacesInput) SetFlowArn(v string) *AddFlowVpcInterfacesInput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *AddFlowVpcInterfacesInput) SetVpcInterfaces(v []*VpcInterfaceRequest) *AddFlowVpcInterfacesInput {
	s.VpcInterfaces = v
	return s
}

// The result of a successful AddFlowVpcInterfaces request. The response includes
// the details of the newly added VPC interfaces.
type AddFlowVpcInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these VPC interfaces were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added VPC interfaces.
	VpcInterfaces []*VpcInterface `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowVpcInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddFlowVpcInterfacesOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowVpcInterfacesOutput) SetFlowArn(v string) *AddFlowVpcInterfacesOutput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *AddFlowVpcInterfacesOutput) SetVpcInterfaces(v []*VpcInterface) *AddFlowVpcInterfacesOutput {
	s.VpcInterfaces = v
	return s
}

type AddIngressGatewayBridgeRequest struct {
	_ struct{} `type:"structure"`

	// The maximum expected bitrate (in bps).
	//
	// MaxBitrate is a required field
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer" required:"true"`

	// The maximum number of expected outputs.
	//
	// MaxOutputs is a required field
	MaxOutputs *int64 `locationName:"maxOutputs" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddIngressGatewayBridgeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddIngressGatewayBridgeRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddIngressGatewayBridgeRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddIngressGatewayBridgeRequest"}
	if s.MaxBitrate == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxBitrate"))
	}
	if s.MaxOutputs == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxOutputs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *AddIngressGatewayBridgeRequest) SetMaxBitrate(v int64) *AddIngressGatewayBridgeRequest {
	s.MaxBitrate = &v
	return s
}

// SetMaxOutputs sets the MaxOutputs field's value.
func (s *AddIngressGatewayBridgeRequest) SetMaxOutputs(v int64) *AddIngressGatewayBridgeRequest {
	s.MaxOutputs = &v
	return s
}

// Create maintenance setting for a flow
type AddMaintenance struct {
	_ struct{} `type:"structure"`

	// A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
	//
	// MaintenanceDay is a required field
	MaintenanceDay *string `locationName:"maintenanceDay" type:"string" required:"true" enum:"MaintenanceDay"`

	// UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes
	// must be 00. Example: 13:00. The default value is 02:00.
	//
	// MaintenanceStartHour is a required field
	MaintenanceStartHour *string `locationName:"maintenanceStartHour" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddMaintenance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddMaintenance) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddMaintenance) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddMaintenance"}
	if s.MaintenanceDay == nil {
		invalidParams.Add(request.NewErrParamRequired("MaintenanceDay"))
	}
	if s.MaintenanceStartHour == nil {
		invalidParams.Add(request.NewErrParamRequired("MaintenanceStartHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaintenanceDay sets the MaintenanceDay field's value.
func (s *AddMaintenance) SetMaintenanceDay(v string) *AddMaintenance {
	s.MaintenanceDay = &v
	return s
}

// SetMaintenanceStartHour sets the MaintenanceStartHour field's value.
func (s *AddMaintenance) SetMaintenanceStartHour(v string) *AddMaintenance {
	s.MaintenanceStartHour = &v
	return s
}

// The media stream that you want to add to the flow.
type AddMediaStreamRequest struct {
	_ struct{} `type:"structure"`

	// The attributes that you want to assign to the new media stream.
	Attributes *MediaStreamAttributesRequest `locationName:"attributes" type:"structure"`

	// The sample rate (in Hz) for the stream. If the media stream type is video
	// or ancillary data, set this value to 90000. If the media stream type is audio,
	// set this value to either 48000 or 96000.
	ClockRate *int64 `locationName:"clockRate" type:"integer"`

	// A description that can help you quickly identify what your media stream is
	// used for.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier for the media stream.
	//
	// MediaStreamId is a required field
	MediaStreamId *int64 `locationName:"mediaStreamId" type:"integer" required:"true"`

	// A name that helps you distinguish one media stream from another.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`

	// The type of media stream.
	//
	// MediaStreamType is a required field
	MediaStreamType *string `locationName:"mediaStreamType" type:"string" required:"true" enum:"MediaStreamType"`

	// The resolution of the video.
	VideoFormat *string `locationName:"videoFormat" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddMediaStreamRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddMediaStreamRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddMediaStreamRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddMediaStreamRequest"}
	if s.MediaStreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamId"))
	}
	if s.MediaStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamName"))
	}
	if s.MediaStreamType == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *AddMediaStreamRequest) SetAttributes(v *MediaStreamAttributesRequest) *AddMediaStreamRequest {
	s.Attributes = v
	return s
}

// SetClockRate sets the ClockRate field's value.
func (s *AddMediaStreamRequest) SetClockRate(v int64) *AddMediaStreamRequest {
	s.ClockRate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddMediaStreamRequest) SetDescription(v string) *AddMediaStreamRequest {
	s.Description = &v
	return s
}

// SetMediaStreamId sets the MediaStreamId field's value.
func (s *AddMediaStreamRequest) SetMediaStreamId(v int64) *AddMediaStreamRequest {
	s.MediaStreamId = &v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *AddMediaStreamRequest) SetMediaStreamName(v string) *AddMediaStreamRequest {
	s.MediaStreamName = &v
	return s
}

// SetMediaStreamType sets the MediaStreamType field's value.
func (s *AddMediaStreamRequest) SetMediaStreamType(v string) *AddMediaStreamRequest {
	s.MediaStreamType = &v
	return s
}

// SetVideoFormat sets the VideoFormat field's value.
func (s *AddMediaStreamRequest) SetVideoFormat(v string) *AddMediaStreamRequest {
	s.VideoFormat = &v
	return s
}

// The output that you want to add to this flow.
type AddOutputRequest struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key). Allowable encryption types: static-key.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based,
	// Zixi-based, and Fujitsu-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The media streams that are associated with the output, and the parameters
	// for those associations.
	MediaStreamOutputConfigurations []*MediaStreamOutputConfigurationRequest `locationName:"mediaStreamOutputConfigurations" type:"list"`

	// The minimum latency in milliseconds for SRT-based streams. In streams that
	// use the SRT protocol, this value that you set on your MediaConnect source
	// or output represents the minimal potential latency of that connection. The
	// latency of the stream is set to the highest number between the sender’s
	// minimum latency and the receiver’s minimum latency.
	MinLatency *int64 `locationName:"minLatency" type:"integer"`

	// The name of the output. This value must be unique within the current flow.
	Name *string `locationName:"name" type:"string"`

	// An indication of whether the new output should be enabled or disabled as
	// soon as it is created. If you don't specify the outputStatus field in your
	// request, MediaConnect sets it to ENABLED.
	OutputStatus *string `locationName:"outputStatus" type:"string" enum:"OutputStatus"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The remote ID for the Zixi-pull output stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddOutputRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddOutputRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddOutputRequest"}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}
	if s.MediaStreamOutputConfigurations != nil {
		for i, v := range s.MediaStreamOutputConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreamOutputConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *AddOutputRequest) SetCidrAllowList(v []*string) *AddOutputRequest {
	s.CidrAllowList = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddOutputRequest) SetDescription(v string) *AddOutputRequest {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *AddOutputRequest) SetDestination(v string) *AddOutputRequest {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *AddOutputRequest) SetEncryption(v *Encryption) *AddOutputRequest {
	s.Encryption = v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *AddOutputRequest) SetMaxLatency(v int64) *AddOutputRequest {
	s.MaxLatency = &v
	return s
}

// SetMediaStreamOutputConfigurations sets the MediaStreamOutputConfigurations field's value.
func (s *AddOutputRequest) SetMediaStreamOutputConfigurations(v []*MediaStreamOutputConfigurationRequest) *AddOutputRequest {
	s.MediaStreamOutputConfigurations = v
	return s
}

// SetMinLatency sets the MinLatency field's value.
func (s *AddOutputRequest) SetMinLatency(v int64) *AddOutputRequest {
	s.MinLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddOutputRequest) SetName(v string) *AddOutputRequest {
	s.Name = &v
	return s
}

// SetOutputStatus sets the OutputStatus field's value.
func (s *AddOutputRequest) SetOutputStatus(v string) *AddOutputRequest {
	s.OutputStatus = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddOutputRequest) SetPort(v int64) *AddOutputRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AddOutputRequest) SetProtocol(v string) *AddOutputRequest {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *AddOutputRequest) SetRemoteId(v string) *AddOutputRequest {
	s.RemoteId = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *AddOutputRequest) SetSenderControlPort(v int64) *AddOutputRequest {
	s.SenderControlPort = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *AddOutputRequest) SetSmoothingLatency(v int64) *AddOutputRequest {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *AddOutputRequest) SetStreamId(v string) *AddOutputRequest {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *AddOutputRequest) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *AddOutputRequest {
	s.VpcInterfaceAttachment = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A Bridge is the connection between your datacenter's Instances and the AWS
// cloud. A bridge can be used to send video from the AWS cloud to your datacenter
// or from your datacenter to the AWS cloud.
type Bridge struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	//
	// BridgeArn is a required field
	BridgeArn *string `locationName:"bridgeArn" type:"string" required:"true"`

	BridgeMessages []*MessageDetail `locationName:"bridgeMessages" type:"list"`

	// BridgeState is a required field
	BridgeState *string `locationName:"bridgeState" type:"string" required:"true" enum:"BridgeState"`

	EgressGatewayBridge *EgressGatewayBridge `locationName:"egressGatewayBridge" type:"structure"`

	IngressGatewayBridge *IngressGatewayBridge `locationName:"ingressGatewayBridge" type:"structure"`

	// The name of the bridge.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs on this bridge.
	Outputs []*BridgeOutput_ `locationName:"outputs" type:"list"`

	// The placement Amazon Resource Number (ARN) of the bridge.
	//
	// PlacementArn is a required field
	PlacementArn *string `locationName:"placementArn" type:"string" required:"true"`

	// The settings for source failover.
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	// The sources on this bridge.
	Sources []*BridgeSource `locationName:"sources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bridge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bridge) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *Bridge) SetBridgeArn(v string) *Bridge {
	s.BridgeArn = &v
	return s
}

// SetBridgeMessages sets the BridgeMessages field's value.
func (s *Bridge) SetBridgeMessages(v []*MessageDetail) *Bridge {
	s.BridgeMessages = v
	return s
}

// SetBridgeState sets the BridgeState field's value.
func (s *Bridge) SetBridgeState(v string) *Bridge {
	s.BridgeState = &v
	return s
}

// SetEgressGatewayBridge sets the EgressGatewayBridge field's value.
func (s *Bridge) SetEgressGatewayBridge(v *EgressGatewayBridge) *Bridge {
	s.EgressGatewayBridge = v
	return s
}

// SetIngressGatewayBridge sets the IngressGatewayBridge field's value.
func (s *Bridge) SetIngressGatewayBridge(v *IngressGatewayBridge) *Bridge {
	s.IngressGatewayBridge = v
	return s
}

// SetName sets the Name field's value.
func (s *Bridge) SetName(v string) *Bridge {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Bridge) SetOutputs(v []*BridgeOutput_) *Bridge {
	s.Outputs = v
	return s
}

// SetPlacementArn sets the PlacementArn field's value.
func (s *Bridge) SetPlacementArn(v string) *Bridge {
	s.PlacementArn = &v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *Bridge) SetSourceFailoverConfig(v *FailoverConfig) *Bridge {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Bridge) SetSources(v []*BridgeSource) *Bridge {
	s.Sources = v
	return s
}

// The output of the bridge. A flow output is delivered to the AWS cloud.
type BridgeFlowOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the cloud flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the flow source.
	//
	// FlowSourceArn is a required field
	FlowSourceArn *string `locationName:"flowSourceArn" type:"string" required:"true"`

	// The name of the bridge's output.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeFlowOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeFlowOutput_) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *BridgeFlowOutput_) SetFlowArn(v string) *BridgeFlowOutput_ {
	s.FlowArn = &v
	return s
}

// SetFlowSourceArn sets the FlowSourceArn field's value.
func (s *BridgeFlowOutput_) SetFlowSourceArn(v string) *BridgeFlowOutput_ {
	s.FlowSourceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *BridgeFlowOutput_) SetName(v string) *BridgeFlowOutput_ {
	s.Name = &v
	return s
}

// The source of the bridge. A flow source originates in MediaConnect as an
// existing cloud flow.
type BridgeFlowSource struct {
	_ struct{} `type:"structure"`

	// The ARN of the cloud flow used as a source of this bridge.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the VPC interface attachment to use for this source.
	FlowVpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"flowVpcInterfaceAttachment" type:"structure"`

	// The name of the flow source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the output.
	OutputArn *string `locationName:"outputArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeFlowSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeFlowSource) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *BridgeFlowSource) SetFlowArn(v string) *BridgeFlowSource {
	s.FlowArn = &v
	return s
}

// SetFlowVpcInterfaceAttachment sets the FlowVpcInterfaceAttachment field's value.
func (s *BridgeFlowSource) SetFlowVpcInterfaceAttachment(v *VpcInterfaceAttachment) *BridgeFlowSource {
	s.FlowVpcInterfaceAttachment = v
	return s
}

// SetName sets the Name field's value.
func (s *BridgeFlowSource) SetName(v string) *BridgeFlowSource {
	s.Name = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *BridgeFlowSource) SetOutputArn(v string) *BridgeFlowSource {
	s.OutputArn = &v
	return s
}

// The output of the bridge. A network output is delivered to your premises.
type BridgeNetworkOutput_ struct {
	_ struct{} `type:"structure"`

	// The network output IP Address.
	//
	// IpAddress is a required field
	IpAddress *string `locationName:"ipAddress" type:"string" required:"true"`

	// The network output name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The network output's gateway network name.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" type:"string" required:"true"`

	// The network output port.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`

	// The network output protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The network output TTL.
	//
	// Ttl is a required field
	Ttl *int64 `locationName:"ttl" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeNetworkOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeNetworkOutput_) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *BridgeNetworkOutput_) SetIpAddress(v string) *BridgeNetworkOutput_ {
	s.IpAddress = &v
	return s
}

// SetName sets the Name field's value.
func (s *BridgeNetworkOutput_) SetName(v string) *BridgeNetworkOutput_ {
	s.Name = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *BridgeNetworkOutput_) SetNetworkName(v string) *BridgeNetworkOutput_ {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BridgeNetworkOutput_) SetPort(v int64) *BridgeNetworkOutput_ {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *BridgeNetworkOutput_) SetProtocol(v string) *BridgeNetworkOutput_ {
	s.Protocol = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *BridgeNetworkOutput_) SetTtl(v int64) *BridgeNetworkOutput_ {
	s.Ttl = &v
	return s
}

// The source of the bridge. A network source originates at your premises.
type BridgeNetworkSource struct {
	_ struct{} `type:"structure"`

	// The network source multicast IP.
	//
	// MulticastIp is a required field
	MulticastIp *string `locationName:"multicastIp" type:"string" required:"true"`

	// The name of the network source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The network source's gateway network name.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" type:"string" required:"true"`

	// The network source port.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`

	// The network source protocol.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeNetworkSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeNetworkSource) GoString() string {
	return s.String()
}

// SetMulticastIp sets the MulticastIp field's value.
func (s *BridgeNetworkSource) SetMulticastIp(v string) *BridgeNetworkSource {
	s.MulticastIp = &v
	return s
}

// SetName sets the Name field's value.
func (s *BridgeNetworkSource) SetName(v string) *BridgeNetworkSource {
	s.Name = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *BridgeNetworkSource) SetNetworkName(v string) *BridgeNetworkSource {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BridgeNetworkSource) SetPort(v int64) *BridgeNetworkSource {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *BridgeNetworkSource) SetProtocol(v string) *BridgeNetworkSource {
	s.Protocol = &v
	return s
}

// The output of the bridge.
type BridgeOutput_ struct {
	_ struct{} `type:"structure"`

	// The output of the bridge. A flow output is delivered to the AWS cloud.
	FlowOutput *BridgeFlowOutput_ `locationName:"flowOutput" type:"structure"`

	// The output of the bridge. A network output is delivered to your premises.
	NetworkOutput *BridgeNetworkOutput_ `locationName:"networkOutput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeOutput_) GoString() string {
	return s.String()
}

// SetFlowOutput sets the FlowOutput field's value.
func (s *BridgeOutput_) SetFlowOutput(v *BridgeFlowOutput_) *BridgeOutput_ {
	s.FlowOutput = v
	return s
}

// SetNetworkOutput sets the NetworkOutput field's value.
func (s *BridgeOutput_) SetNetworkOutput(v *BridgeNetworkOutput_) *BridgeOutput_ {
	s.NetworkOutput = v
	return s
}

// The bridge's source.
type BridgeSource struct {
	_ struct{} `type:"structure"`

	// The source of the bridge. A flow source originates in MediaConnect as an
	// existing cloud flow.
	FlowSource *BridgeFlowSource `locationName:"flowSource" type:"structure"`

	// The source of the bridge. A network source originates at your premises.
	NetworkSource *BridgeNetworkSource `locationName:"networkSource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BridgeSource) GoString() string {
	return s.String()
}

// SetFlowSource sets the FlowSource field's value.
func (s *BridgeSource) SetFlowSource(v *BridgeFlowSource) *BridgeSource {
	s.FlowSource = v
	return s
}

// SetNetworkSource sets the NetworkSource field's value.
func (s *BridgeSource) SetNetworkSource(v *BridgeNetworkSource) *BridgeSource {
	s.NetworkSource = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type CreateBridge420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridge420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridge420Exception) GoString() string {
	return s.String()
}

func newErrorCreateBridge420Exception(v protocol.ResponseMetadata) error {
	return &CreateBridge420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateBridge420Exception) Code() string {
	return "CreateBridge420Exception"
}

// Message returns the exception's message.
func (s *CreateBridge420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateBridge420Exception) OrigErr() error {
	return nil
}

func (s *CreateBridge420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateBridge420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateBridge420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates a new bridge. The request must include one source.
type CreateBridgeInput struct {
	_ struct{} `type:"structure"`

	// Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground
	// bridge. The content comes from an existing MediaConnect flow and is delivered
	// to your premises.
	EgressGatewayBridge *AddEgressGatewayBridgeRequest `locationName:"egressGatewayBridge" type:"structure"`

	// Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud
	// bridge. The content originates at your premises and is delivered to the cloud.
	IngressGatewayBridge *AddIngressGatewayBridgeRequest `locationName:"ingressGatewayBridge" type:"structure"`

	// The name of the bridge. This name can not be modified after the bridge is
	// created.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs that you want to add to this bridge.
	Outputs []*AddBridgeOutputRequest `locationName:"outputs" type:"list"`

	// The bridge placement Amazon Resource Number (ARN).
	//
	// PlacementArn is a required field
	PlacementArn *string `locationName:"placementArn" type:"string" required:"true"`

	// The settings for source failover.
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	// The sources that you want to add to this bridge.
	//
	// Sources is a required field
	Sources []*AddBridgeSourceRequest `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridgeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridgeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBridgeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBridgeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PlacementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementArn"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.EgressGatewayBridge != nil {
		if err := s.EgressGatewayBridge.Validate(); err != nil {
			invalidParams.AddNested("EgressGatewayBridge", err.(request.ErrInvalidParams))
		}
	}
	if s.IngressGatewayBridge != nil {
		if err := s.IngressGatewayBridge.Validate(); err != nil {
			invalidParams.AddNested("IngressGatewayBridge", err.(request.ErrInvalidParams))
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEgressGatewayBridge sets the EgressGatewayBridge field's value.
func (s *CreateBridgeInput) SetEgressGatewayBridge(v *AddEgressGatewayBridgeRequest) *CreateBridgeInput {
	s.EgressGatewayBridge = v
	return s
}

// SetIngressGatewayBridge sets the IngressGatewayBridge field's value.
func (s *CreateBridgeInput) SetIngressGatewayBridge(v *AddIngressGatewayBridgeRequest) *CreateBridgeInput {
	s.IngressGatewayBridge = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateBridgeInput) SetName(v string) *CreateBridgeInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateBridgeInput) SetOutputs(v []*AddBridgeOutputRequest) *CreateBridgeInput {
	s.Outputs = v
	return s
}

// SetPlacementArn sets the PlacementArn field's value.
func (s *CreateBridgeInput) SetPlacementArn(v string) *CreateBridgeInput {
	s.PlacementArn = &v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *CreateBridgeInput) SetSourceFailoverConfig(v *FailoverConfig) *CreateBridgeInput {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateBridgeInput) SetSources(v []*AddBridgeSourceRequest) *CreateBridgeInput {
	s.Sources = v
	return s
}

// The result of a successful CreateBridge request.
type CreateBridgeOutput struct {
	_ struct{} `type:"structure"`

	// A Bridge is the connection between your datacenter's Instances and the AWS
	// cloud. A bridge can be used to send video from the AWS cloud to your datacenter
	// or from your datacenter to the AWS cloud.
	Bridge *Bridge `locationName:"bridge" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridgeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBridgeOutput) GoString() string {
	return s.String()
}

// SetBridge sets the Bridge field's value.
func (s *CreateBridgeOutput) SetBridge(v *Bridge) *CreateBridgeOutput {
	s.Bridge = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type CreateFlow420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlow420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlow420Exception) GoString() string {
	return s.String()
}

func newErrorCreateFlow420Exception(v protocol.ResponseMetadata) error {
	return &CreateFlow420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateFlow420Exception) Code() string {
	return "CreateFlow420Exception"
}

// Message returns the exception's message.
func (s *CreateFlow420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateFlow420Exception) OrigErr() error {
	return nil
}

func (s *CreateFlow420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateFlow420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateFlow420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 50) and entitlements (up to 50.)
type CreateFlowInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS Region.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The entitlements that you want to grant on a flow.
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list"`

	// Create maintenance setting for a flow
	Maintenance *AddMaintenance `locationName:"maintenance" type:"structure"`

	// The media streams that you want to add to the flow. You can associate these
	// media streams with sources and outputs on the flow.
	MediaStreams []*AddMediaStreamRequest `locationName:"mediaStreams" type:"list"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs that you want to add to this flow.
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list"`

	// The settings for the source of the flow.
	Source *SetSourceRequest `locationName:"source" type:"structure"`

	// The settings for source failover.
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	Sources []*SetSourceRequest `locationName:"sources" type:"list"`

	// The VPC interfaces you want on the flow.
	VpcInterfaces []*VpcInterfaceRequest `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Maintenance != nil {
		if err := s.Maintenance.Validate(); err != nil {
			invalidParams.AddNested("Maintenance", err.(request.ErrInvalidParams))
		}
	}
	if s.MediaStreams != nil {
		for i, v := range s.MediaStreams {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreams", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcInterfaces != nil {
		for i, v := range s.VpcInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateFlowInput) SetAvailabilityZone(v string) *CreateFlowInput {
	s.AvailabilityZone = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *CreateFlowInput) SetEntitlements(v []*GrantEntitlementRequest) *CreateFlowInput {
	s.Entitlements = v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *CreateFlowInput) SetMaintenance(v *AddMaintenance) *CreateFlowInput {
	s.Maintenance = v
	return s
}

// SetMediaStreams sets the MediaStreams field's value.
func (s *CreateFlowInput) SetMediaStreams(v []*AddMediaStreamRequest) *CreateFlowInput {
	s.MediaStreams = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowInput) SetName(v string) *CreateFlowInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateFlowInput) SetOutputs(v []*AddOutputRequest) *CreateFlowInput {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateFlowInput) SetSource(v *SetSourceRequest) *CreateFlowInput {
	s.Source = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *CreateFlowInput) SetSourceFailoverConfig(v *FailoverConfig) *CreateFlowInput {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateFlowInput) SetSources(v []*SetSourceRequest) *CreateFlowInput {
	s.Sources = v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *CreateFlowInput) SetVpcInterfaces(v []*VpcInterfaceRequest) *CreateFlowInput {
	s.VpcInterfaces = v
	return s
}

// The result of a successful CreateFlow request.
type CreateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *CreateFlowOutput) SetFlow(v *Flow) *CreateFlowOutput {
	s.Flow = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type CreateGateway420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGateway420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGateway420Exception) GoString() string {
	return s.String()
}

func newErrorCreateGateway420Exception(v protocol.ResponseMetadata) error {
	return &CreateGateway420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateGateway420Exception) Code() string {
	return "CreateGateway420Exception"
}

// Message returns the exception's message.
func (s *CreateGateway420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateGateway420Exception) OrigErr() error {
	return nil
}

func (s *CreateGateway420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateGateway420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateGateway420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates a new gateway. The request must include one network (up to 4).
type CreateGatewayInput struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that are allowed to contribute content or initiate
	// output requests for flows communicating with this gateway. These IP addresses
	// should be in the form of a Classless Inter-Domain Routing (CIDR) block; for
	// example, 10.0.0.0/16.
	//
	// EgressCidrBlocks is a required field
	EgressCidrBlocks []*string `locationName:"egressCidrBlocks" type:"list" required:"true"`

	// The name of the gateway. This name can not be modified after the gateway
	// is created.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The list of networks that you want to add.
	//
	// Networks is a required field
	Networks []*GatewayNetwork `locationName:"networks" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGatewayInput"}
	if s.EgressCidrBlocks == nil {
		invalidParams.Add(request.NewErrParamRequired("EgressCidrBlocks"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Networks == nil {
		invalidParams.Add(request.NewErrParamRequired("Networks"))
	}
	if s.Networks != nil {
		for i, v := range s.Networks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Networks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEgressCidrBlocks sets the EgressCidrBlocks field's value.
func (s *CreateGatewayInput) SetEgressCidrBlocks(v []*string) *CreateGatewayInput {
	s.EgressCidrBlocks = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGatewayInput) SetName(v string) *CreateGatewayInput {
	s.Name = &v
	return s
}

// SetNetworks sets the Networks field's value.
func (s *CreateGatewayInput) SetNetworks(v []*GatewayNetwork) *CreateGatewayInput {
	s.Networks = v
	return s
}

type CreateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a gateway, including its networks.
	Gateway *Gateway `locationName:"gateway" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGatewayOutput) GoString() string {
	return s.String()
}

// SetGateway sets the Gateway field's value.
func (s *CreateGatewayOutput) SetGateway(v *Gateway) *CreateGatewayOutput {
	s.Gateway = v
	return s
}

type DeleteBridgeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBridgeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBridgeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBridgeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBridgeInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *DeleteBridgeInput) SetBridgeArn(v string) *DeleteBridgeInput {
	s.BridgeArn = &v
	return s
}

// The result of a successful DeleteBridge request.
type DeleteBridgeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the deleted bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBridgeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBridgeOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *DeleteBridgeOutput) SetBridgeArn(v string) *DeleteBridgeOutput {
	s.BridgeArn = &v
	return s
}

type DeleteFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowInput) SetFlowArn(v string) *DeleteFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DeleteFlow request.
type DeleteFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that was deleted.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the DeleteFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowOutput) SetFlowArn(v string) *DeleteFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteFlowOutput) SetStatus(v string) *DeleteFlowOutput {
	s.Status = &v
	return s
}

type DeleteGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// GatewayArn is a required field
	GatewayArn *string `location:"uri" locationName:"gatewayArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayArn"))
	}
	if s.GatewayArn != nil && len(*s.GatewayArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *DeleteGatewayInput) SetGatewayArn(v string) *DeleteGatewayInput {
	s.GatewayArn = &v
	return s
}

// The result of a successful DeleteGateway request.
type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway that was deleted.
	GatewayArn *string `locationName:"gatewayArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *DeleteGatewayOutput) SetGatewayArn(v string) *DeleteGatewayOutput {
	s.GatewayArn = &v
	return s
}

type DeregisterGatewayInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	Force *bool `location:"querystring" locationName:"force" type:"boolean"`

	// GatewayInstanceArn is a required field
	GatewayInstanceArn *string `location:"uri" locationName:"gatewayInstanceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGatewayInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGatewayInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterGatewayInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterGatewayInstanceInput"}
	if s.GatewayInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayInstanceArn"))
	}
	if s.GatewayInstanceArn != nil && len(*s.GatewayInstanceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayInstanceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeregisterGatewayInstanceInput) SetForce(v bool) *DeregisterGatewayInstanceInput {
	s.Force = &v
	return s
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *DeregisterGatewayInstanceInput) SetGatewayInstanceArn(v string) *DeregisterGatewayInstanceInput {
	s.GatewayInstanceArn = &v
	return s
}

// The result of a successful DeregisterGatewayInstance request.
type DeregisterGatewayInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance.
	GatewayInstanceArn *string `locationName:"gatewayInstanceArn" type:"string"`

	// The status of the instance.
	InstanceState *string `locationName:"instanceState" type:"string" enum:"InstanceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGatewayInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGatewayInstanceOutput) GoString() string {
	return s.String()
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *DeregisterGatewayInstanceOutput) SetGatewayInstanceArn(v string) *DeregisterGatewayInstanceOutput {
	s.GatewayInstanceArn = &v
	return s
}

// SetInstanceState sets the InstanceState field's value.
func (s *DeregisterGatewayInstanceOutput) SetInstanceState(v string) *DeregisterGatewayInstanceOutput {
	s.InstanceState = &v
	return s
}

type DescribeBridgeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBridgeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBridgeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBridgeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBridgeInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *DescribeBridgeInput) SetBridgeArn(v string) *DescribeBridgeInput {
	s.BridgeArn = &v
	return s
}

// The result of a successful DescribeBridge request.
type DescribeBridgeOutput struct {
	_ struct{} `type:"structure"`

	// A Bridge is the connection between your datacenter's Instances and the AWS
	// cloud. A bridge can be used to send video from the AWS cloud to your datacenter
	// or from your datacenter to the AWS cloud.
	Bridge *Bridge `locationName:"bridge" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBridgeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBridgeOutput) GoString() string {
	return s.String()
}

// SetBridge sets the Bridge field's value.
func (s *DescribeBridgeOutput) SetBridge(v *Bridge) *DescribeBridgeOutput {
	s.Bridge = v
	return s
}

type DescribeFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowInput) SetFlowArn(v string) *DescribeFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DescribeFlow request.
type DescribeFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`

	// Messages that provide the state of the flow.
	Messages *Messages `locationName:"messages" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *DescribeFlowOutput) SetFlow(v *Flow) *DescribeFlowOutput {
	s.Flow = v
	return s
}

// SetMessages sets the Messages field's value.
func (s *DescribeFlowOutput) SetMessages(v *Messages) *DescribeFlowOutput {
	s.Messages = v
	return s
}

type DescribeFlowSourceMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowSourceMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowSourceMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowSourceMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowSourceMetadataInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowSourceMetadataInput) SetFlowArn(v string) *DescribeFlowSourceMetadataInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DescribeFlowSourceMetadata request.
type DescribeFlowSourceMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that DescribeFlowSourceMetadata was performed on.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// Provides a status code and message regarding issues found with the flow source
	// metadata.
	Messages []*MessageDetail `locationName:"messages" type:"list"`

	// The timestamp of the most recent change in metadata for this flow’s source.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" timestampFormat:"iso8601"`

	// The metadata of the transport stream in the current flow's source.
	TransportMediaInfo *TransportMediaInfo `locationName:"transportMediaInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowSourceMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlowSourceMetadataOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowSourceMetadataOutput) SetFlowArn(v string) *DescribeFlowSourceMetadataOutput {
	s.FlowArn = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *DescribeFlowSourceMetadataOutput) SetMessages(v []*MessageDetail) *DescribeFlowSourceMetadataOutput {
	s.Messages = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DescribeFlowSourceMetadataOutput) SetTimestamp(v time.Time) *DescribeFlowSourceMetadataOutput {
	s.Timestamp = &v
	return s
}

// SetTransportMediaInfo sets the TransportMediaInfo field's value.
func (s *DescribeFlowSourceMetadataOutput) SetTransportMediaInfo(v *TransportMediaInfo) *DescribeFlowSourceMetadataOutput {
	s.TransportMediaInfo = v
	return s
}

type DescribeGatewayInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// GatewayArn is a required field
	GatewayArn *string `location:"uri" locationName:"gatewayArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInput"}
	if s.GatewayArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayArn"))
	}
	if s.GatewayArn != nil && len(*s.GatewayArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *DescribeGatewayInput) SetGatewayArn(v string) *DescribeGatewayInput {
	s.GatewayArn = &v
	return s
}

type DescribeGatewayInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// GatewayInstanceArn is a required field
	GatewayInstanceArn *string `location:"uri" locationName:"gatewayInstanceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInstanceInput"}
	if s.GatewayInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayInstanceArn"))
	}
	if s.GatewayInstanceArn != nil && len(*s.GatewayInstanceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayInstanceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *DescribeGatewayInstanceInput) SetGatewayInstanceArn(v string) *DescribeGatewayInstanceInput {
	s.GatewayInstanceArn = &v
	return s
}

// The result of a successful DescribeGatewayInstance request.
type DescribeGatewayInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The settings for an instance in a gateway.
	GatewayInstance *GatewayInstance `locationName:"gatewayInstance" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayInstanceOutput) GoString() string {
	return s.String()
}

// SetGatewayInstance sets the GatewayInstance field's value.
func (s *DescribeGatewayInstanceOutput) SetGatewayInstance(v *GatewayInstance) *DescribeGatewayInstanceOutput {
	s.GatewayInstance = v
	return s
}

// The result of a successful DescribeGateway request.
type DescribeGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a gateway, including its networks.
	Gateway *Gateway `locationName:"gateway" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGatewayOutput) GoString() string {
	return s.String()
}

// SetGateway sets the Gateway field's value.
func (s *DescribeGatewayOutput) SetGateway(v *Gateway) *DescribeGatewayOutput {
	s.Gateway = v
	return s
}

type DescribeOfferingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// OfferingArn is a required field
	OfferingArn *string `location:"uri" locationName:"offeringArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOfferingInput"}
	if s.OfferingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingArn"))
	}
	if s.OfferingArn != nil && len(*s.OfferingArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingArn sets the OfferingArn field's value.
func (s *DescribeOfferingInput) SetOfferingArn(v string) *DescribeOfferingInput {
	s.OfferingArn = &v
	return s
}

// The result of a successful DescribeOffering request.
type DescribeOfferingOutput struct {
	_ struct{} `type:"structure"`

	// A savings plan that reserves a certain amount of outbound bandwidth usage
	// at a discounted rate each month over a period of time.
	Offering *Offering `locationName:"offering" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingOutput) GoString() string {
	return s.String()
}

// SetOffering sets the Offering field's value.
func (s *DescribeOfferingOutput) SetOffering(v *Offering) *DescribeOfferingOutput {
	s.Offering = v
	return s
}

type DescribeReservationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ReservationArn is a required field
	ReservationArn *string `location:"uri" locationName:"reservationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservationInput"}
	if s.ReservationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationArn"))
	}
	if s.ReservationArn != nil && len(*s.ReservationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservationArn sets the ReservationArn field's value.
func (s *DescribeReservationInput) SetReservationArn(v string) *DescribeReservationInput {
	s.ReservationArn = &v
	return s
}

// The result of a successful DescribeReservation request.
type DescribeReservationOutput struct {
	_ struct{} `type:"structure"`

	// A pricing agreement for a discounted rate for a specific outbound bandwidth
	// that your MediaConnect account will use each month over a specific time period.
	// The discounted rate in the reservation applies to outbound bandwidth for
	// all flows from your account until your account reaches the amount of bandwidth
	// in your reservation. If you use more outbound bandwidth than the agreed upon
	// amount in a single month, the overage is charged at the on-demand rate.
	Reservation *Reservation `locationName:"reservation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationOutput) GoString() string {
	return s.String()
}

// SetReservation sets the Reservation field's value.
func (s *DescribeReservationOutput) SetReservation(v *Reservation) *DescribeReservationOutput {
	s.Reservation = v
	return s
}

// The transport parameters that are associated with an outbound media stream.
type DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The IP address where contents of the media stream will be sent.
	//
	// DestinationIp is a required field
	DestinationIp *string `locationName:"destinationIp" type:"string" required:"true"`

	// The port to use when the content of the media stream is distributed to the
	// output.
	//
	// DestinationPort is a required field
	DestinationPort *int64 `locationName:"destinationPort" type:"integer" required:"true"`

	// The VPC interface that is used for the media stream associated with the output.
	//
	// Interface is a required field
	Interface *Interface `locationName:"interface" type:"structure" required:"true"`

	// The IP address that the receiver requires in order to establish a connection
	// with the flow. This value is represented by the elastic network interface
	// IP address of the VPC. This field applies only to outputs that use the CDI
	// or ST 2110 JPEG XS protocol.
	//
	// OutboundIp is a required field
	OutboundIp *string `locationName:"outboundIp" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) GoString() string {
	return s.String()
}

// SetDestinationIp sets the DestinationIp field's value.
func (s *DestinationConfiguration) SetDestinationIp(v string) *DestinationConfiguration {
	s.DestinationIp = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *DestinationConfiguration) SetDestinationPort(v int64) *DestinationConfiguration {
	s.DestinationPort = &v
	return s
}

// SetInterface sets the Interface field's value.
func (s *DestinationConfiguration) SetInterface(v *Interface) *DestinationConfiguration {
	s.Interface = v
	return s
}

// SetOutboundIp sets the OutboundIp field's value.
func (s *DestinationConfiguration) SetOutboundIp(v string) *DestinationConfiguration {
	s.OutboundIp = &v
	return s
}

// The transport parameters that you want to associate with an outbound media
// stream.
type DestinationConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The IP address where you want MediaConnect to send contents of the media
	// stream.
	//
	// DestinationIp is a required field
	DestinationIp *string `locationName:"destinationIp" type:"string" required:"true"`

	// The port that you want MediaConnect to use when it distributes the media
	// stream to the output.
	//
	// DestinationPort is a required field
	DestinationPort *int64 `locationName:"destinationPort" type:"integer" required:"true"`

	// The VPC interface that you want to use for the media stream associated with
	// the output.
	//
	// Interface is a required field
	Interface *InterfaceRequest `locationName:"interface" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfigurationRequest"}
	if s.DestinationIp == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationIp"))
	}
	if s.DestinationPort == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPort"))
	}
	if s.Interface == nil {
		invalidParams.Add(request.NewErrParamRequired("Interface"))
	}
	if s.Interface != nil {
		if err := s.Interface.Validate(); err != nil {
			invalidParams.AddNested("Interface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationIp sets the DestinationIp field's value.
func (s *DestinationConfigurationRequest) SetDestinationIp(v string) *DestinationConfigurationRequest {
	s.DestinationIp = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *DestinationConfigurationRequest) SetDestinationPort(v int64) *DestinationConfigurationRequest {
	s.DestinationPort = &v
	return s
}

// SetInterface sets the Interface field's value.
func (s *DestinationConfigurationRequest) SetInterface(v *InterfaceRequest) *DestinationConfigurationRequest {
	s.Interface = v
	return s
}

type EgressGatewayBridge struct {
	_ struct{} `type:"structure"`

	// The ID of the instance running this bridge.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The maximum expected bitrate (in bps) of the egress bridge.
	//
	// MaxBitrate is a required field
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressGatewayBridge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EgressGatewayBridge) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *EgressGatewayBridge) SetInstanceId(v string) *EgressGatewayBridge {
	s.InstanceId = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *EgressGatewayBridge) SetMaxBitrate(v int64) *EgressGatewayBridge {
	s.MaxBitrate = &v
	return s
}

// A collection of parameters that determine how MediaConnect will convert the
// content. These fields only apply to outputs on flows that have a CDI source.
type EncodingParameters struct {
	_ struct{} `type:"structure"`

	// A value that is used to calculate compression for an output. The bitrate
	// of the output is calculated as follows: Output bitrate = (1 / compressionFactor)
	// * (source bitrate) This property only applies to outputs that use the ST
	// 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid
	// values are floating point numbers in the range of 3.0 to 10.0, inclusive.
	//
	// CompressionFactor is a required field
	CompressionFactor *float64 `locationName:"compressionFactor" type:"double" required:"true"`

	// A setting on the encoder that drives compression settings. This property
	// only applies to video media streams associated with outputs that use the
	// ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
	//
	// EncoderProfile is a required field
	EncoderProfile *string `locationName:"encoderProfile" type:"string" required:"true" enum:"EncoderProfile"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncodingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncodingParameters) GoString() string {
	return s.String()
}

// SetCompressionFactor sets the CompressionFactor field's value.
func (s *EncodingParameters) SetCompressionFactor(v float64) *EncodingParameters {
	s.CompressionFactor = &v
	return s
}

// SetEncoderProfile sets the EncoderProfile field's value.
func (s *EncodingParameters) SetEncoderProfile(v string) *EncodingParameters {
	s.EncoderProfile = &v
	return s
}

// A collection of parameters that determine how MediaConnect will convert the
// content. These fields only apply to outputs on flows that have a CDI source.
type EncodingParametersRequest struct {
	_ struct{} `type:"structure"`

	// A value that is used to calculate compression for an output. The bitrate
	// of the output is calculated as follows: Output bitrate = (1 / compressionFactor)
	// * (source bitrate) This property only applies to outputs that use the ST
	// 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid
	// values are floating point numbers in the range of 3.0 to 10.0, inclusive.
	//
	// CompressionFactor is a required field
	CompressionFactor *float64 `locationName:"compressionFactor" type:"double" required:"true"`

	// A setting on the encoder that drives compression settings. This property
	// only applies to video media streams associated with outputs that use the
	// ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI
	// protocol.
	//
	// EncoderProfile is a required field
	EncoderProfile *string `locationName:"encoderProfile" type:"string" required:"true" enum:"EncoderProfile"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncodingParametersRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncodingParametersRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncodingParametersRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncodingParametersRequest"}
	if s.CompressionFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("CompressionFactor"))
	}
	if s.EncoderProfile == nil {
		invalidParams.Add(request.NewErrParamRequired("EncoderProfile"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompressionFactor sets the CompressionFactor field's value.
func (s *EncodingParametersRequest) SetCompressionFactor(v float64) *EncodingParametersRequest {
	s.CompressionFactor = &v
	return s
}

// SetEncoderProfile sets the EncoderProfile field's value.
func (s *EncodingParametersRequest) SetEncoderProfile(v string) *EncodingParametersRequest {
	s.EncoderProfile = &v
	return s
}

// Information about the encryption of the flow.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	Algorithm *string `locationName:"algorithm" type:"string" enum:"Algorithm"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *Encryption) SetAlgorithm(v string) *Encryption {
	s.Algorithm = &v
	return s
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *Encryption) SetConstantInitializationVector(v string) *Encryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *Encryption) SetDeviceId(v string) *Encryption {
	s.DeviceId = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *Encryption) SetKeyType(v string) *Encryption {
	s.KeyType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Encryption) SetRegion(v string) *Encryption {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Encryption) SetResourceId(v string) *Encryption {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Encryption) SetRoleArn(v string) *Encryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *Encryption) SetSecretArn(v string) *Encryption {
	s.SecretArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Encryption) SetUrl(v string) *Encryption {
	s.Url = &v
	return s
}

// The settings for a flow entitlement.
type Entitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// An indication of whether the entitlement is enabled.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// The name of the entitlement.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entitlement) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Entitlement) SetDataTransferSubscriberFeePercent(v int64) *Entitlement {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Entitlement) SetDescription(v string) *Entitlement {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Entitlement) SetEncryption(v *Encryption) *Entitlement {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Entitlement) SetEntitlementArn(v string) *Entitlement {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *Entitlement) SetEntitlementStatus(v string) *Entitlement {
	s.EntitlementStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *Entitlement) SetName(v string) *Entitlement {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *Entitlement) SetSubscribers(v []*string) *Entitlement {
	s.Subscribers = v
	return s
}

// The settings for source failover.
type FailoverConfig struct {
	_ struct{} `type:"structure"`

	// The type of failover you choose for this flow. MERGE combines the source
	// streams into a single stream, allowing graceful recovery from any single-source
	// loss. FAILOVER allows switching between different streams.
	FailoverMode *string `locationName:"failoverMode" type:"string" enum:"FailoverMode"`

	// Search window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	// The priority you want to assign to a source. You can have a primary stream
	// and a backup stream or two equally prioritized streams.
	SourcePriority *SourcePriority `locationName:"sourcePriority" type:"structure"`

	State *string `locationName:"state" type:"string" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConfig) GoString() string {
	return s.String()
}

// SetFailoverMode sets the FailoverMode field's value.
func (s *FailoverConfig) SetFailoverMode(v string) *FailoverConfig {
	s.FailoverMode = &v
	return s
}

// SetRecoveryWindow sets the RecoveryWindow field's value.
func (s *FailoverConfig) SetRecoveryWindow(v int64) *FailoverConfig {
	s.RecoveryWindow = &v
	return s
}

// SetSourcePriority sets the SourcePriority field's value.
func (s *FailoverConfig) SetSourcePriority(v *SourcePriority) *FailoverConfig {
	s.SourcePriority = v
	return s
}

// SetState sets the State field's value.
func (s *FailoverConfig) SetState(v string) *FailoverConfig {
	s.State = &v
	return s
}

// The settings for a flow, including its source, outputs, and entitlements.
type Flow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	EgressIp *string `locationName:"egressIp" type:"string"`

	// The entitlements in this flow.
	//
	// Entitlements is a required field
	Entitlements []*Entitlement `locationName:"entitlements" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The maintenance setting of a flow
	Maintenance *Maintenance `locationName:"maintenance" type:"structure"`

	// The media streams that are associated with the flow. After you associate
	// a media stream with a source, you can also associate it with outputs on the
	// flow.
	MediaStreams []*MediaStream `locationName:"mediaStreams" type:"list"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs in this flow.
	//
	// Outputs is a required field
	Outputs []*Output `locationName:"outputs" type:"list" required:"true"`

	// The settings for the source of the flow.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`

	// The settings for source failover.
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	Sources []*Source `locationName:"sources" type:"list"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`

	// The VPC Interfaces for this flow.
	VpcInterfaces []*VpcInterface `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Flow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Flow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Flow) SetAvailabilityZone(v string) *Flow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Flow) SetDescription(v string) *Flow {
	s.Description = &v
	return s
}

// SetEgressIp sets the EgressIp field's value.
func (s *Flow) SetEgressIp(v string) *Flow {
	s.EgressIp = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *Flow) SetEntitlements(v []*Entitlement) *Flow {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *Flow) SetFlowArn(v string) *Flow {
	s.FlowArn = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *Flow) SetMaintenance(v *Maintenance) *Flow {
	s.Maintenance = v
	return s
}

// SetMediaStreams sets the MediaStreams field's value.
func (s *Flow) SetMediaStreams(v []*MediaStream) *Flow {
	s.MediaStreams = v
	return s
}

// SetName sets the Name field's value.
func (s *Flow) SetName(v string) *Flow {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Flow) SetOutputs(v []*Output) *Flow {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *Flow) SetSource(v *Source) *Flow {
	s.Source = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *Flow) SetSourceFailoverConfig(v *FailoverConfig) *Flow {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Flow) SetSources(v []*Source) *Flow {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Flow) SetStatus(v string) *Flow {
	s.Status = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *Flow) SetVpcInterfaces(v []*VpcInterface) *Flow {
	s.VpcInterfaces = v
	return s
}

// FMTP
type Fmtp struct {
	_ struct{} `type:"structure"`

	// The format of the audio channel.
	ChannelOrder *string `locationName:"channelOrder" type:"string"`

	// The format that is used for the representation of color.
	Colorimetry *string `locationName:"colorimetry" type:"string" enum:"Colorimetry"`

	// The frame rate for the video stream, in frames/second. For example: 60000/1001.
	// If you specify a whole number, MediaConnect uses a ratio of N/1. For example,
	// if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
	ExactFramerate *string `locationName:"exactFramerate" type:"string"`

	// The pixel aspect ratio (PAR) of the video.
	Par *string `locationName:"par" type:"string"`

	// The encoding range of the video.
	Range *string `locationName:"range" type:"string" enum:"Range"`

	// The type of compression that was used to smooth the video’s appearance
	ScanMode *string `locationName:"scanMode" type:"string" enum:"ScanMode"`

	// The transfer characteristic system (TCS) that is used in the video.
	Tcs *string `locationName:"tcs" type:"string" enum:"Tcs"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fmtp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fmtp) GoString() string {
	return s.String()
}

// SetChannelOrder sets the ChannelOrder field's value.
func (s *Fmtp) SetChannelOrder(v string) *Fmtp {
	s.ChannelOrder = &v
	return s
}

// SetColorimetry sets the Colorimetry field's value.
func (s *Fmtp) SetColorimetry(v string) *Fmtp {
	s.Colorimetry = &v
	return s
}

// SetExactFramerate sets the ExactFramerate field's value.
func (s *Fmtp) SetExactFramerate(v string) *Fmtp {
	s.ExactFramerate = &v
	return s
}

// SetPar sets the Par field's value.
func (s *Fmtp) SetPar(v string) *Fmtp {
	s.Par = &v
	return s
}

// SetRange sets the Range field's value.
func (s *Fmtp) SetRange(v string) *Fmtp {
	s.Range = &v
	return s
}

// SetScanMode sets the ScanMode field's value.
func (s *Fmtp) SetScanMode(v string) *Fmtp {
	s.ScanMode = &v
	return s
}

// SetTcs sets the Tcs field's value.
func (s *Fmtp) SetTcs(v string) *Fmtp {
	s.Tcs = &v
	return s
}

// The settings that you want to use to define the media stream.
type FmtpRequest struct {
	_ struct{} `type:"structure"`

	// The format of the audio channel.
	ChannelOrder *string `locationName:"channelOrder" type:"string"`

	// The format that is used for the representation of color.
	Colorimetry *string `locationName:"colorimetry" type:"string" enum:"Colorimetry"`

	// The frame rate for the video stream, in frames/second. For example: 60000/1001.
	// If you specify a whole number, MediaConnect uses a ratio of N/1. For example,
	// if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
	ExactFramerate *string `locationName:"exactFramerate" type:"string"`

	// The pixel aspect ratio (PAR) of the video.
	Par *string `locationName:"par" type:"string"`

	// The encoding range of the video.
	Range *string `locationName:"range" type:"string" enum:"Range"`

	// The type of compression that was used to smooth the video’s appearance.
	ScanMode *string `locationName:"scanMode" type:"string" enum:"ScanMode"`

	// The transfer characteristic system (TCS) that is used in the video.
	Tcs *string `locationName:"tcs" type:"string" enum:"Tcs"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FmtpRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FmtpRequest) GoString() string {
	return s.String()
}

// SetChannelOrder sets the ChannelOrder field's value.
func (s *FmtpRequest) SetChannelOrder(v string) *FmtpRequest {
	s.ChannelOrder = &v
	return s
}

// SetColorimetry sets the Colorimetry field's value.
func (s *FmtpRequest) SetColorimetry(v string) *FmtpRequest {
	s.Colorimetry = &v
	return s
}

// SetExactFramerate sets the ExactFramerate field's value.
func (s *FmtpRequest) SetExactFramerate(v string) *FmtpRequest {
	s.ExactFramerate = &v
	return s
}

// SetPar sets the Par field's value.
func (s *FmtpRequest) SetPar(v string) *FmtpRequest {
	s.Par = &v
	return s
}

// SetRange sets the Range field's value.
func (s *FmtpRequest) SetRange(v string) *FmtpRequest {
	s.Range = &v
	return s
}

// SetScanMode sets the ScanMode field's value.
func (s *FmtpRequest) SetScanMode(v string) *FmtpRequest {
	s.ScanMode = &v
	return s
}

// SetTcs sets the Tcs field's value.
func (s *FmtpRequest) SetTcs(v string) *FmtpRequest {
	s.Tcs = &v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The frame resolution used by the video stream.
type FrameResolution struct {
	_ struct{} `type:"structure"`

	// The number of pixels in the height of the video frame.
	//
	// FrameHeight is a required field
	FrameHeight *int64 `locationName:"frameHeight" type:"integer" required:"true"`

	// The number of pixels in the width of the video frame.
	//
	// FrameWidth is a required field
	FrameWidth *int64 `locationName:"frameWidth" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameResolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameResolution) GoString() string {
	return s.String()
}

// SetFrameHeight sets the FrameHeight field's value.
func (s *FrameResolution) SetFrameHeight(v int64) *FrameResolution {
	s.FrameHeight = &v
	return s
}

// SetFrameWidth sets the FrameWidth field's value.
func (s *FrameResolution) SetFrameWidth(v int64) *FrameResolution {
	s.FrameWidth = &v
	return s
}

// The settings for a gateway, including its networks.
type Gateway struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that contribute content or initiate output requests
	// for flows communicating with this gateway. These IP addresses should be in
	// the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
	//
	// EgressCidrBlocks is a required field
	EgressCidrBlocks []*string `locationName:"egressCidrBlocks" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" type:"string" required:"true"`

	GatewayMessages []*MessageDetail `locationName:"gatewayMessages" type:"list"`

	// The current status of the gateway.
	GatewayState *string `locationName:"gatewayState" type:"string" enum:"GatewayState"`

	// The name of the gateway. This name can not be modified after the gateway
	// is created.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The list of networks in the gateway.
	//
	// Networks is a required field
	Networks []*GatewayNetwork `locationName:"networks" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gateway) GoString() string {
	return s.String()
}

// SetEgressCidrBlocks sets the EgressCidrBlocks field's value.
func (s *Gateway) SetEgressCidrBlocks(v []*string) *Gateway {
	s.EgressCidrBlocks = v
	return s
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *Gateway) SetGatewayArn(v string) *Gateway {
	s.GatewayArn = &v
	return s
}

// SetGatewayMessages sets the GatewayMessages field's value.
func (s *Gateway) SetGatewayMessages(v []*MessageDetail) *Gateway {
	s.GatewayMessages = v
	return s
}

// SetGatewayState sets the GatewayState field's value.
func (s *Gateway) SetGatewayState(v string) *Gateway {
	s.GatewayState = &v
	return s
}

// SetName sets the Name field's value.
func (s *Gateway) SetName(v string) *Gateway {
	s.Name = &v
	return s
}

// SetNetworks sets the Networks field's value.
func (s *Gateway) SetNetworks(v []*GatewayNetwork) *Gateway {
	s.Networks = v
	return s
}

// The source configuration for cloud flows receiving a stream from a bridge.
type GatewayBridgeSource struct {
	_ struct{} `type:"structure"`

	// The ARN of the bridge feeding this flow.
	//
	// BridgeArn is a required field
	BridgeArn *string `locationName:"bridgeArn" type:"string" required:"true"`

	// The name of the VPC interface attachment to use for this bridge source.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayBridgeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayBridgeSource) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *GatewayBridgeSource) SetBridgeArn(v string) *GatewayBridgeSource {
	s.BridgeArn = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *GatewayBridgeSource) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *GatewayBridgeSource {
	s.VpcInterfaceAttachment = v
	return s
}

// The settings for an instance in a gateway.
type GatewayInstance struct {
	_ struct{} `type:"structure"`

	// The availability of the instance to host new bridges. The bridgePlacement
	// property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can
	// be deployed to this instance. If it is AVAILABLE, new bridges can be added
	// to this instance.
	//
	// BridgePlacement is a required field
	BridgePlacement *string `locationName:"bridgePlacement" type:"string" required:"true" enum:"BridgePlacement"`

	// The connection state of the instance.
	//
	// ConnectionStatus is a required field
	ConnectionStatus *string `locationName:"connectionStatus" type:"string" required:"true" enum:"ConnectionStatus"`

	// The Amazon Resource Name (ARN) of the instance.
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// GatewayInstanceArn is a required field
	GatewayInstanceArn *string `locationName:"gatewayInstanceArn" type:"string" required:"true"`

	// The managed instance ID generated by the SSM install. This will begin with
	// "mi-".
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	InstanceMessages []*MessageDetail `locationName:"instanceMessages" type:"list"`

	// The status of the instance.
	//
	// InstanceState is a required field
	InstanceState *string `locationName:"instanceState" type:"string" required:"true" enum:"InstanceState"`

	// The running bridge count.
	//
	// RunningBridgeCount is a required field
	RunningBridgeCount *int64 `locationName:"runningBridgeCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayInstance) GoString() string {
	return s.String()
}

// SetBridgePlacement sets the BridgePlacement field's value.
func (s *GatewayInstance) SetBridgePlacement(v string) *GatewayInstance {
	s.BridgePlacement = &v
	return s
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *GatewayInstance) SetConnectionStatus(v string) *GatewayInstance {
	s.ConnectionStatus = &v
	return s
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *GatewayInstance) SetGatewayArn(v string) *GatewayInstance {
	s.GatewayArn = &v
	return s
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *GatewayInstance) SetGatewayInstanceArn(v string) *GatewayInstance {
	s.GatewayInstanceArn = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GatewayInstance) SetInstanceId(v string) *GatewayInstance {
	s.InstanceId = &v
	return s
}

// SetInstanceMessages sets the InstanceMessages field's value.
func (s *GatewayInstance) SetInstanceMessages(v []*MessageDetail) *GatewayInstance {
	s.InstanceMessages = v
	return s
}

// SetInstanceState sets the InstanceState field's value.
func (s *GatewayInstance) SetInstanceState(v string) *GatewayInstance {
	s.InstanceState = &v
	return s
}

// SetRunningBridgeCount sets the RunningBridgeCount field's value.
func (s *GatewayInstance) SetRunningBridgeCount(v int64) *GatewayInstance {
	s.RunningBridgeCount = &v
	return s
}

// The network settings for a gateway.
type GatewayNetwork struct {
	_ struct{} `type:"structure"`

	// A unique IP address range to use for this network. These IP addresses should
	// be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
	// 10.0.0.0/16.
	//
	// CidrBlock is a required field
	CidrBlock *string `locationName:"cidrBlock" type:"string" required:"true"`

	// The name of the network. This name is used to reference the network and must
	// be unique among networks in this gateway.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayNetwork) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayNetwork) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayNetwork) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayNetwork"}
	if s.CidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrBlock"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *GatewayNetwork) SetCidrBlock(v string) *GatewayNetwork {
	s.CidrBlock = &v
	return s
}

// SetName sets the Name field's value.
func (s *GatewayNetwork) SetName(v string) *GatewayNetwork {
	s.Name = &v
	return s
}

// The entitlements that you want to grant on a flow.
type GrantEntitlementRequest struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement. Allowable encryption types: static-key, speke.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// An indication of whether the new entitlement should be enabled or disabled
	// as soon as it is created. If you don’t specify the entitlementStatus field
	// in your request, MediaConnect sets it to ENABLED.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// The name of the entitlement. This value must be unique within the current
	// flow.
	Name *string `locationName:"name" type:"string"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flows using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantEntitlementRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantEntitlementRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantEntitlementRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantEntitlementRequest"}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *GrantEntitlementRequest) SetDataTransferSubscriberFeePercent(v int64) *GrantEntitlementRequest {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GrantEntitlementRequest) SetDescription(v string) *GrantEntitlementRequest {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *GrantEntitlementRequest) SetEncryption(v *Encryption) *GrantEntitlementRequest {
	s.Encryption = v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *GrantEntitlementRequest) SetEntitlementStatus(v string) *GrantEntitlementRequest {
	s.EntitlementStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *GrantEntitlementRequest) SetName(v string) *GrantEntitlementRequest {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *GrantEntitlementRequest) SetSubscribers(v []*string) *GrantEntitlementRequest {
	s.Subscribers = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type GrantFlowEntitlements420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlements420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlements420Exception) GoString() string {
	return s.String()
}

func newErrorGrantFlowEntitlements420Exception(v protocol.ResponseMetadata) error {
	return &GrantFlowEntitlements420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GrantFlowEntitlements420Exception) Code() string {
	return "GrantFlowEntitlements420Exception"
}

// Message returns the exception's message.
func (s *GrantFlowEntitlements420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GrantFlowEntitlements420Exception) OrigErr() error {
	return nil
}

func (s *GrantFlowEntitlements420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GrantFlowEntitlements420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GrantFlowEntitlements420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Grants an entitlement on a flow.
type GrantFlowEntitlementsInput struct {
	_ struct{} `type:"structure"`

	// The list of entitlements that you want to grant.
	//
	// Entitlements is a required field
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantFlowEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantFlowEntitlementsInput"}
	if s.Entitlements == nil {
		invalidParams.Add(request.NewErrParamRequired("Entitlements"))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsInput) SetEntitlements(v []*GrantEntitlementRequest) *GrantFlowEntitlementsInput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsInput) SetFlowArn(v string) *GrantFlowEntitlementsInput {
	s.FlowArn = &v
	return s
}

// The result of a successful GrantFlowEntitlements request.
type GrantFlowEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// The entitlements that were just granted.
	Entitlements []*Entitlement `locationName:"entitlements" type:"list"`

	// The ARN of the flow that these entitlements were granted to.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantFlowEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsOutput) SetEntitlements(v []*Entitlement) *GrantFlowEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsOutput) SetFlowArn(v string) *GrantFlowEntitlementsOutput {
	s.FlowArn = &v
	return s
}

type IngressGatewayBridge struct {
	_ struct{} `type:"structure"`

	// The ID of the instance running this bridge.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The maximum expected bitrate (in bps) of the ingress bridge.
	//
	// MaxBitrate is a required field
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer" required:"true"`

	// The maximum number of outputs on the ingress bridge.
	//
	// MaxOutputs is a required field
	MaxOutputs *int64 `locationName:"maxOutputs" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressGatewayBridge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngressGatewayBridge) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *IngressGatewayBridge) SetInstanceId(v string) *IngressGatewayBridge {
	s.InstanceId = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *IngressGatewayBridge) SetMaxBitrate(v int64) *IngressGatewayBridge {
	s.MaxBitrate = &v
	return s
}

// SetMaxOutputs sets the MaxOutputs field's value.
func (s *IngressGatewayBridge) SetMaxOutputs(v int64) *IngressGatewayBridge {
	s.MaxOutputs = &v
	return s
}

// The transport parameters that are associated with an incoming media stream.
type InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The IP address that the flow listens on for incoming content for a media
	// stream.
	//
	// InputIp is a required field
	InputIp *string `locationName:"inputIp" type:"string" required:"true"`

	// The port that the flow listens on for an incoming media stream.
	//
	// InputPort is a required field
	InputPort *int64 `locationName:"inputPort" type:"integer" required:"true"`

	// The VPC interface where the media stream comes in from.
	//
	// Interface is a required field
	Interface *Interface `locationName:"interface" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfiguration) GoString() string {
	return s.String()
}

// SetInputIp sets the InputIp field's value.
func (s *InputConfiguration) SetInputIp(v string) *InputConfiguration {
	s.InputIp = &v
	return s
}

// SetInputPort sets the InputPort field's value.
func (s *InputConfiguration) SetInputPort(v int64) *InputConfiguration {
	s.InputPort = &v
	return s
}

// SetInterface sets the Interface field's value.
func (s *InputConfiguration) SetInterface(v *Interface) *InputConfiguration {
	s.Interface = v
	return s
}

// The transport parameters that you want to associate with an incoming media
// stream.
type InputConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The port that you want the flow to listen on for an incoming media stream.
	//
	// InputPort is a required field
	InputPort *int64 `locationName:"inputPort" type:"integer" required:"true"`

	// The VPC interface that you want to use for the incoming media stream.
	//
	// Interface is a required field
	Interface *InterfaceRequest `locationName:"interface" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputConfigurationRequest"}
	if s.InputPort == nil {
		invalidParams.Add(request.NewErrParamRequired("InputPort"))
	}
	if s.Interface == nil {
		invalidParams.Add(request.NewErrParamRequired("Interface"))
	}
	if s.Interface != nil {
		if err := s.Interface.Validate(); err != nil {
			invalidParams.AddNested("Interface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputPort sets the InputPort field's value.
func (s *InputConfigurationRequest) SetInputPort(v int64) *InputConfigurationRequest {
	s.InputPort = &v
	return s
}

// SetInterface sets the Interface field's value.
func (s *InputConfigurationRequest) SetInterface(v *InterfaceRequest) *InputConfigurationRequest {
	s.Interface = v
	return s
}

// The VPC interface that is used for the media stream associated with the source
// or output.
type Interface struct {
	_ struct{} `type:"structure"`

	// The name of the VPC interface.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Interface) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Interface) SetName(v string) *Interface {
	s.Name = &v
	return s
}

// The VPC interface that you want to designate where the media stream is coming
// from or going to.
type InterfaceRequest struct {
	_ struct{} `type:"structure"`

	// The name of the VPC interface.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterfaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterfaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InterfaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InterfaceRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *InterfaceRequest) SetName(v string) *InterfaceRequest {
	s.Name = &v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBridgesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	FilterArn *string `location:"querystring" locationName:"filterArn" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBridgesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBridgesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBridgesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBridgesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *ListBridgesInput) SetFilterArn(v string) *ListBridgesInput {
	s.FilterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBridgesInput) SetMaxResults(v int64) *ListBridgesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBridgesInput) SetNextToken(v string) *ListBridgesInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListBridges request. The response includes bridge
// summaries and the NextToken to use in a subsequent ListBridges request.
type ListBridgesOutput struct {
	_ struct{} `type:"structure"`

	// A list of bridge summaries.
	Bridges []*ListedBridge `locationName:"bridges" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListBridges request with MaxResults set at 5. The service
	// returns the first batch of results (up to 5) and a NextToken value. To see
	// the next batch of results, you can submit the ListBridges request a second
	// time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBridgesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBridgesOutput) GoString() string {
	return s.String()
}

// SetBridges sets the Bridges field's value.
func (s *ListBridgesOutput) SetBridges(v []*ListedBridge) *ListBridgesOutput {
	s.Bridges = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBridgesOutput) SetNextToken(v string) *ListBridgesOutput {
	s.NextToken = &v
	return s
}

type ListEntitlementsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitlementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitlementsInput) SetMaxResults(v int64) *ListEntitlementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsInput) SetNextToken(v string) *ListEntitlementsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListEntitlements request. The response includes
// the ARN of each entitlement, the name of the associated flow, and the NextToken
// to use in a subsequent ListEntitlements request.
type ListEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// A list of entitlements that have been granted to you from other AWS accounts.
	Entitlements []*ListedEntitlement `locationName:"entitlements" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListEntitlements request with MaxResults set at 5.
	// The service returns the first batch of results (up to 5) and a NextToken
	// value. To see the next batch of results, you can submit the ListEntitlements
	// request a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *ListEntitlementsOutput) SetEntitlements(v []*ListedEntitlement) *ListEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsOutput) SetNextToken(v string) *ListEntitlementsOutput {
	s.NextToken = &v
	return s
}

type ListFlowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowsInput) SetMaxResults(v int64) *ListFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsInput) SetNextToken(v string) *ListFlowsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListFlows request. The response includes flow
// summaries and the NextToken to use in a subsequent ListFlows request.
type ListFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of flow summaries.
	Flows []*ListedFlow `locationName:"flows" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListFlows request with MaxResults set at 5. The service
	// returns the first batch of results (up to 5) and a NextToken value. To see
	// the next batch of results, you can submit the ListFlows request a second
	// time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsOutput) GoString() string {
	return s.String()
}

// SetFlows sets the Flows field's value.
func (s *ListFlowsOutput) SetFlows(v []*ListedFlow) *ListFlowsOutput {
	s.Flows = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsOutput) SetNextToken(v string) *ListFlowsOutput {
	s.NextToken = &v
	return s
}

type ListGatewayInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	FilterArn *string `location:"querystring" locationName:"filterArn" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewayInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewayInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *ListGatewayInstancesInput) SetFilterArn(v string) *ListGatewayInstancesInput {
	s.FilterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewayInstancesInput) SetMaxResults(v int64) *ListGatewayInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayInstancesInput) SetNextToken(v string) *ListGatewayInstancesInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListGatewayInstances request. The response includes
// instance summaries and the NextToken to use in a subsequent ListInstances
// request.
type ListGatewayInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance summaries.
	Instances []*ListedGatewayInstance `locationName:"instances" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListInstances request with MaxResults set at 5. The
	// service returns the first batch of results (up to 5) and a NextToken value.
	// To see the next batch of results, you can submit the ListInstances request
	// a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewayInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListGatewayInstancesOutput) SetInstances(v []*ListedGatewayInstance) *ListGatewayInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewayInstancesOutput) SetNextToken(v string) *ListGatewayInstancesOutput {
	s.NextToken = &v
	return s
}

type ListGatewaysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewaysInput) SetMaxResults(v int64) *ListGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysInput) SetNextToken(v string) *ListGatewaysInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListGateways request. The response includes gateway
// summaries and the NextToken to use in a subsequent ListGateways request.
type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list of gateway summaries.
	Gateways []*ListedGateway `locationName:"gateways" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListGateways request with MaxResults set at 5. The
	// service returns the first batch of results (up to 5) and a NextToken value.
	// To see the next batch of results, you can submit the ListGateways request
	// a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGateways sets the Gateways field's value.
func (s *ListGatewaysOutput) SetGateways(v []*ListedGateway) *ListGatewaysOutput {
	s.Gateways = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysOutput) SetNextToken(v string) *ListGatewaysOutput {
	s.NextToken = &v
	return s
}

type ListOfferingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOfferingsInput) SetMaxResults(v int64) *ListOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsInput) SetNextToken(v string) *ListOfferingsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListOfferings request. The response includes the
// details of each offering that your account is eligible for. The response
// includes the following information for each offering: description, duration,
// outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken
// to use in a subsequent ListOfferings request.
type ListOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListOfferings request with MaxResults set at 5. The
	// service returns the first batch of results (up to 5) and a NextToken value.
	// To see the next batch of results, you can submit the ListOfferings request
	// a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of offerings that are available to this account in the current AWS
	// Region.
	Offerings []*Offering `locationName:"offerings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsOutput) SetNextToken(v string) *ListOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetOfferings sets the Offerings field's value.
func (s *ListOfferingsOutput) SetOfferings(v []*Offering) *ListOfferingsOutput {
	s.Offerings = v
	return s
}

type ListReservationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReservationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReservationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReservationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReservationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReservationsInput) SetMaxResults(v int64) *ListReservationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReservationsInput) SetNextToken(v string) *ListReservationsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListReservations request. The response includes
// the details of each offering that your account is eligible for. The response
// includes the following information for each offering: description, duration,
// outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken
// to use in a subsequent ListOfferings request.
type ListReservationsOutput struct {
	_ struct{} `type:"structure"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListReservations request with MaxResults set at 5.
	// The service returns the first batch of results (up to 5) and a NextToken
	// value. To see the next batch of results, you can submit the ListReservations
	// request a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all reservations that have been purchased by this account in the
	// current AWS Region.
	Reservations []*Reservation `locationName:"reservations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReservationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReservationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReservationsOutput) SetNextToken(v string) *ListReservationsOutput {
	s.NextToken = &v
	return s
}

// SetReservations sets the Reservations field's value.
func (s *ListReservationsOutput) SetReservations(v []*Reservation) *ListReservationsOutput {
	s.Reservations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// The tags for the resource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map from tag keys to values. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Displays details of the selected bridge.
type ListedBridge struct {
	_ struct{} `type:"structure"`

	// The ARN of the bridge.
	//
	// BridgeArn is a required field
	BridgeArn *string `locationName:"bridgeArn" type:"string" required:"true"`

	// BridgeState is a required field
	BridgeState *string `locationName:"bridgeState" type:"string" required:"true" enum:"BridgeState"`

	// The type of the bridge.
	//
	// BridgeType is a required field
	BridgeType *string `locationName:"bridgeType" type:"string" required:"true"`

	// The name of the bridge.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the gateway associated with the bridge.
	//
	// PlacementArn is a required field
	PlacementArn *string `locationName:"placementArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedBridge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedBridge) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *ListedBridge) SetBridgeArn(v string) *ListedBridge {
	s.BridgeArn = &v
	return s
}

// SetBridgeState sets the BridgeState field's value.
func (s *ListedBridge) SetBridgeState(v string) *ListedBridge {
	s.BridgeState = &v
	return s
}

// SetBridgeType sets the BridgeType field's value.
func (s *ListedBridge) SetBridgeType(v string) *ListedBridge {
	s.BridgeType = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListedBridge) SetName(v string) *ListedBridge {
	s.Name = &v
	return s
}

// SetPlacementArn sets the PlacementArn field's value.
func (s *ListedBridge) SetPlacementArn(v string) *ListedBridge {
	s.PlacementArn = &v
	return s
}

// An entitlement that has been granted to you from other AWS accounts.
type ListedEntitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// EntitlementName is a required field
	EntitlementName *string `locationName:"entitlementName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedEntitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedEntitlement) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *ListedEntitlement) SetDataTransferSubscriberFeePercent(v int64) *ListedEntitlement {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *ListedEntitlement) SetEntitlementArn(v string) *ListedEntitlement {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementName sets the EntitlementName field's value.
func (s *ListedEntitlement) SetEntitlementName(v string) *ListedEntitlement {
	s.EntitlementName = &v
	return s
}

// Provides a summary of a flow, including its ARN, Availability Zone, and source
// type.
type ListedFlow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the flow was created in.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ARN of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The maintenance setting of a flow
	Maintenance *Maintenance `locationName:"maintenance" type:"structure"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of source. This value is either owned (originated somewhere other
	// than an AWS Elemental MediaConnect flow owned by another AWS account) or
	// entitled (originated at an AWS Elemental MediaConnect flow owned by another
	// AWS account).
	//
	// SourceType is a required field
	SourceType *string `locationName:"sourceType" type:"string" required:"true" enum:"SourceType"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedFlow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ListedFlow) SetAvailabilityZone(v string) *ListedFlow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListedFlow) SetDescription(v string) *ListedFlow {
	s.Description = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *ListedFlow) SetFlowArn(v string) *ListedFlow {
	s.FlowArn = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *ListedFlow) SetMaintenance(v *Maintenance) *ListedFlow {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *ListedFlow) SetName(v string) *ListedFlow {
	s.Name = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ListedFlow) SetSourceType(v string) *ListedFlow {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListedFlow) SetStatus(v string) *ListedFlow {
	s.Status = &v
	return s
}

// Provides a summary of a gateway, including its name, ARN, and status.
type ListedGateway struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" type:"string" required:"true"`

	// GatewayState is a required field
	GatewayState *string `locationName:"gatewayState" type:"string" required:"true" enum:"GatewayState"`

	// The name of the gateway.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedGateway) GoString() string {
	return s.String()
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *ListedGateway) SetGatewayArn(v string) *ListedGateway {
	s.GatewayArn = &v
	return s
}

// SetGatewayState sets the GatewayState field's value.
func (s *ListedGateway) SetGatewayState(v string) *ListedGateway {
	s.GatewayState = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListedGateway) SetName(v string) *ListedGateway {
	s.Name = &v
	return s
}

// Provides a summary of an instance.
type ListedGatewayInstance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the instance.
	//
	// GatewayInstanceArn is a required field
	GatewayInstanceArn *string `locationName:"gatewayInstanceArn" type:"string" required:"true"`

	// The managed instance ID generated by the SSM install. This will begin with
	// "mi-".
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The status of the instance.
	InstanceState *string `locationName:"instanceState" type:"string" enum:"InstanceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedGatewayInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListedGatewayInstance) GoString() string {
	return s.String()
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *ListedGatewayInstance) SetGatewayArn(v string) *ListedGatewayInstance {
	s.GatewayArn = &v
	return s
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *ListedGatewayInstance) SetGatewayInstanceArn(v string) *ListedGatewayInstance {
	s.GatewayInstanceArn = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListedGatewayInstance) SetInstanceId(v string) *ListedGatewayInstance {
	s.InstanceId = &v
	return s
}

// SetInstanceState sets the InstanceState field's value.
func (s *ListedGatewayInstance) SetInstanceState(v string) *ListedGatewayInstance {
	s.InstanceState = &v
	return s
}

// The maintenance setting of a flow
type Maintenance struct {
	_ struct{} `type:"structure"`

	// A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
	MaintenanceDay *string `locationName:"maintenanceDay" type:"string" enum:"MaintenanceDay"`

	// The Maintenance has to be performed before this deadline in ISO UTC format.
	// Example: 2021-01-30T08:30:00Z.
	MaintenanceDeadline *string `locationName:"maintenanceDeadline" type:"string"`

	// A scheduled date in ISO UTC format when the maintenance will happen. Use
	// YYYY-MM-DD format. Example: 2021-01-30.
	MaintenanceScheduledDate *string `locationName:"maintenanceScheduledDate" type:"string"`

	// UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes
	// must be 00. Example: 13:00. The default value is 02:00.
	MaintenanceStartHour *string `locationName:"maintenanceStartHour" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Maintenance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Maintenance) GoString() string {
	return s.String()
}

// SetMaintenanceDay sets the MaintenanceDay field's value.
func (s *Maintenance) SetMaintenanceDay(v string) *Maintenance {
	s.MaintenanceDay = &v
	return s
}

// SetMaintenanceDeadline sets the MaintenanceDeadline field's value.
func (s *Maintenance) SetMaintenanceDeadline(v string) *Maintenance {
	s.MaintenanceDeadline = &v
	return s
}

// SetMaintenanceScheduledDate sets the MaintenanceScheduledDate field's value.
func (s *Maintenance) SetMaintenanceScheduledDate(v string) *Maintenance {
	s.MaintenanceScheduledDate = &v
	return s
}

// SetMaintenanceStartHour sets the MaintenanceStartHour field's value.
func (s *Maintenance) SetMaintenanceStartHour(v string) *Maintenance {
	s.MaintenanceStartHour = &v
	return s
}

// A single track or stream of media that contains video, audio, or ancillary
// data. After you add a media stream to a flow, you can associate it with sources
// and outputs on that flow, as long as they use the CDI protocol or the ST
// 2110 JPEG XS protocol. Each source or output can consist of one or many media
// streams.
type MediaStream struct {
	_ struct{} `type:"structure"`

	// Attributes that are related to the media stream.
	Attributes *MediaStreamAttributes `locationName:"attributes" type:"structure"`

	// The sample rate for the stream. This value is measured in Hz.
	ClockRate *int64 `locationName:"clockRate" type:"integer"`

	// A description that can help you quickly identify what your media stream is
	// used for.
	Description *string `locationName:"description" type:"string"`

	// The format type number (sometimes referred to as RTP payload type) of the
	// media stream. MediaConnect assigns this value to the media stream. For ST
	// 2110 JPEG XS outputs, you need to provide this value to the receiver.
	//
	// Fmt is a required field
	Fmt *int64 `locationName:"fmt" type:"integer" required:"true"`

	// A unique identifier for the media stream.
	//
	// MediaStreamId is a required field
	MediaStreamId *int64 `locationName:"mediaStreamId" type:"integer" required:"true"`

	// A name that helps you distinguish one media stream from another.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`

	// The type of media stream.
	//
	// MediaStreamType is a required field
	MediaStreamType *string `locationName:"mediaStreamType" type:"string" required:"true" enum:"MediaStreamType"`

	// The resolution of the video.
	VideoFormat *string `locationName:"videoFormat" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStream) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *MediaStream) SetAttributes(v *MediaStreamAttributes) *MediaStream {
	s.Attributes = v
	return s
}

// SetClockRate sets the ClockRate field's value.
func (s *MediaStream) SetClockRate(v int64) *MediaStream {
	s.ClockRate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MediaStream) SetDescription(v string) *MediaStream {
	s.Description = &v
	return s
}

// SetFmt sets the Fmt field's value.
func (s *MediaStream) SetFmt(v int64) *MediaStream {
	s.Fmt = &v
	return s
}

// SetMediaStreamId sets the MediaStreamId field's value.
func (s *MediaStream) SetMediaStreamId(v int64) *MediaStream {
	s.MediaStreamId = &v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *MediaStream) SetMediaStreamName(v string) *MediaStream {
	s.MediaStreamName = &v
	return s
}

// SetMediaStreamType sets the MediaStreamType field's value.
func (s *MediaStream) SetMediaStreamType(v string) *MediaStream {
	s.MediaStreamType = &v
	return s
}

// SetVideoFormat sets the VideoFormat field's value.
func (s *MediaStream) SetVideoFormat(v string) *MediaStream {
	s.VideoFormat = &v
	return s
}

// Attributes that are related to the media stream.
type MediaStreamAttributes struct {
	_ struct{} `type:"structure"`

	// A set of parameters that define the media stream.
	//
	// Fmtp is a required field
	Fmtp *Fmtp `locationName:"fmtp" type:"structure" required:"true"`

	// The audio language, in a format that is recognized by the receiver.
	Lang *string `locationName:"lang" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamAttributes) GoString() string {
	return s.String()
}

// SetFmtp sets the Fmtp field's value.
func (s *MediaStreamAttributes) SetFmtp(v *Fmtp) *MediaStreamAttributes {
	s.Fmtp = v
	return s
}

// SetLang sets the Lang field's value.
func (s *MediaStreamAttributes) SetLang(v string) *MediaStreamAttributes {
	s.Lang = &v
	return s
}

// Attributes that are related to the media stream.
type MediaStreamAttributesRequest struct {
	_ struct{} `type:"structure"`

	// The settings that you want to use to define the media stream.
	Fmtp *FmtpRequest `locationName:"fmtp" type:"structure"`

	// The audio language, in a format that is recognized by the receiver.
	Lang *string `locationName:"lang" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamAttributesRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamAttributesRequest) GoString() string {
	return s.String()
}

// SetFmtp sets the Fmtp field's value.
func (s *MediaStreamAttributesRequest) SetFmtp(v *FmtpRequest) *MediaStreamAttributesRequest {
	s.Fmtp = v
	return s
}

// SetLang sets the Lang field's value.
func (s *MediaStreamAttributesRequest) SetLang(v string) *MediaStreamAttributesRequest {
	s.Lang = &v
	return s
}

// The media stream that is associated with the output, and the parameters for
// that association.
type MediaStreamOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// The transport parameters that are associated with each outbound media stream.
	DestinationConfigurations []*DestinationConfiguration `locationName:"destinationConfigurations" type:"list"`

	// The format that was used to encode the data. For ancillary data streams,
	// set the encoding name to smpte291. For audio streams, set the encoding name
	// to pcm. For video, 2110 streams, set the encoding name to raw. For video,
	// JPEG XS streams, set the encoding name to jxsv.
	//
	// EncodingName is a required field
	EncodingName *string `locationName:"encodingName" type:"string" required:"true" enum:"EncodingName"`

	// Encoding parameters
	EncodingParameters *EncodingParameters `locationName:"encodingParameters" type:"structure"`

	// The name of the media stream.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamOutputConfiguration) GoString() string {
	return s.String()
}

// SetDestinationConfigurations sets the DestinationConfigurations field's value.
func (s *MediaStreamOutputConfiguration) SetDestinationConfigurations(v []*DestinationConfiguration) *MediaStreamOutputConfiguration {
	s.DestinationConfigurations = v
	return s
}

// SetEncodingName sets the EncodingName field's value.
func (s *MediaStreamOutputConfiguration) SetEncodingName(v string) *MediaStreamOutputConfiguration {
	s.EncodingName = &v
	return s
}

// SetEncodingParameters sets the EncodingParameters field's value.
func (s *MediaStreamOutputConfiguration) SetEncodingParameters(v *EncodingParameters) *MediaStreamOutputConfiguration {
	s.EncodingParameters = v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *MediaStreamOutputConfiguration) SetMediaStreamName(v string) *MediaStreamOutputConfiguration {
	s.MediaStreamName = &v
	return s
}

// The media stream that you want to associate with the output, and the parameters
// for that association.
type MediaStreamOutputConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The transport parameters that you want to associate with the media stream.
	DestinationConfigurations []*DestinationConfigurationRequest `locationName:"destinationConfigurations" type:"list"`

	// The format that will be used to encode the data. For ancillary data streams,
	// set the encoding name to smpte291. For audio streams, set the encoding name
	// to pcm. For video, 2110 streams, set the encoding name to raw. For video,
	// JPEG XS streams, set the encoding name to jxsv.
	//
	// EncodingName is a required field
	EncodingName *string `locationName:"encodingName" type:"string" required:"true" enum:"EncodingName"`

	// A collection of parameters that determine how MediaConnect will convert the
	// content. These fields only apply to outputs on flows that have a CDI source.
	EncodingParameters *EncodingParametersRequest `locationName:"encodingParameters" type:"structure"`

	// The name of the media stream that is associated with the output.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamOutputConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamOutputConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaStreamOutputConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MediaStreamOutputConfigurationRequest"}
	if s.EncodingName == nil {
		invalidParams.Add(request.NewErrParamRequired("EncodingName"))
	}
	if s.MediaStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamName"))
	}
	if s.DestinationConfigurations != nil {
		for i, v := range s.DestinationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DestinationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EncodingParameters != nil {
		if err := s.EncodingParameters.Validate(); err != nil {
			invalidParams.AddNested("EncodingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfigurations sets the DestinationConfigurations field's value.
func (s *MediaStreamOutputConfigurationRequest) SetDestinationConfigurations(v []*DestinationConfigurationRequest) *MediaStreamOutputConfigurationRequest {
	s.DestinationConfigurations = v
	return s
}

// SetEncodingName sets the EncodingName field's value.
func (s *MediaStreamOutputConfigurationRequest) SetEncodingName(v string) *MediaStreamOutputConfigurationRequest {
	s.EncodingName = &v
	return s
}

// SetEncodingParameters sets the EncodingParameters field's value.
func (s *MediaStreamOutputConfigurationRequest) SetEncodingParameters(v *EncodingParametersRequest) *MediaStreamOutputConfigurationRequest {
	s.EncodingParameters = v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *MediaStreamOutputConfigurationRequest) SetMediaStreamName(v string) *MediaStreamOutputConfigurationRequest {
	s.MediaStreamName = &v
	return s
}

// The media stream that is associated with the source, and the parameters for
// that association.
type MediaStreamSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The format that was used to encode the data. For ancillary data streams,
	// set the encoding name to smpte291. For audio streams, set the encoding name
	// to pcm. For video, 2110 streams, set the encoding name to raw. For video,
	// JPEG XS streams, set the encoding name to jxsv.
	//
	// EncodingName is a required field
	EncodingName *string `locationName:"encodingName" type:"string" required:"true" enum:"EncodingName"`

	// The transport parameters that are associated with an incoming media stream.
	InputConfigurations []*InputConfiguration `locationName:"inputConfigurations" type:"list"`

	// The name of the media stream.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamSourceConfiguration) GoString() string {
	return s.String()
}

// SetEncodingName sets the EncodingName field's value.
func (s *MediaStreamSourceConfiguration) SetEncodingName(v string) *MediaStreamSourceConfiguration {
	s.EncodingName = &v
	return s
}

// SetInputConfigurations sets the InputConfigurations field's value.
func (s *MediaStreamSourceConfiguration) SetInputConfigurations(v []*InputConfiguration) *MediaStreamSourceConfiguration {
	s.InputConfigurations = v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *MediaStreamSourceConfiguration) SetMediaStreamName(v string) *MediaStreamSourceConfiguration {
	s.MediaStreamName = &v
	return s
}

// The definition of a media stream that you want to associate with the source.
type MediaStreamSourceConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The format you want to use to encode the data. For ancillary data streams,
	// set the encoding name to smpte291. For audio streams, set the encoding name
	// to pcm. For video, 2110 streams, set the encoding name to raw. For video,
	// JPEG XS streams, set the encoding name to jxsv.
	//
	// EncodingName is a required field
	EncodingName *string `locationName:"encodingName" type:"string" required:"true" enum:"EncodingName"`

	// The transport parameters that you want to associate with the media stream.
	InputConfigurations []*InputConfigurationRequest `locationName:"inputConfigurations" type:"list"`

	// The name of the media stream.
	//
	// MediaStreamName is a required field
	MediaStreamName *string `locationName:"mediaStreamName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamSourceConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaStreamSourceConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaStreamSourceConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MediaStreamSourceConfigurationRequest"}
	if s.EncodingName == nil {
		invalidParams.Add(request.NewErrParamRequired("EncodingName"))
	}
	if s.MediaStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamName"))
	}
	if s.InputConfigurations != nil {
		for i, v := range s.InputConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncodingName sets the EncodingName field's value.
func (s *MediaStreamSourceConfigurationRequest) SetEncodingName(v string) *MediaStreamSourceConfigurationRequest {
	s.EncodingName = &v
	return s
}

// SetInputConfigurations sets the InputConfigurations field's value.
func (s *MediaStreamSourceConfigurationRequest) SetInputConfigurations(v []*InputConfigurationRequest) *MediaStreamSourceConfigurationRequest {
	s.InputConfigurations = v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *MediaStreamSourceConfigurationRequest) SetMediaStreamName(v string) *MediaStreamSourceConfigurationRequest {
	s.MediaStreamName = &v
	return s
}

type MessageDetail struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true"`

	// The specific error message that MediaConnect returns to help you understand
	// the reason that the request did not succeed.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the resource.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageDetail) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *MessageDetail) SetCode(v string) *MessageDetail {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *MessageDetail) SetMessage(v string) *MessageDetail {
	s.Message = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *MessageDetail) SetResourceName(v string) *MessageDetail {
	s.ResourceName = &v
	return s
}

// Messages that provide the state of the flow.
type Messages struct {
	_ struct{} `type:"structure"`

	// A list of errors that might have been generated from processes on this flow.
	//
	// Errors is a required field
	Errors []*string `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Messages) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Messages) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *Messages) SetErrors(v []*string) *Messages {
	s.Errors = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A savings plan that reserves a certain amount of outbound bandwidth usage
// at a discounted rate each month over a period of time.
type Offering struct {
	_ struct{} `type:"structure"`

	// The type of currency that is used for billing. The currencyCode used for
	// all reservations is US dollars.
	//
	// CurrencyCode is a required field
	CurrencyCode *string `locationName:"currencyCode" type:"string" required:"true"`

	// The length of time that your reservation would be active.
	//
	// Duration is a required field
	Duration *int64 `locationName:"duration" type:"integer" required:"true"`

	// The unit of measurement for the duration of the offering.
	//
	// DurationUnits is a required field
	DurationUnits *string `locationName:"durationUnits" type:"string" required:"true" enum:"DurationUnits"`

	// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
	//
	// OfferingArn is a required field
	OfferingArn *string `locationName:"offeringArn" type:"string" required:"true"`

	// A description of the offering.
	//
	// OfferingDescription is a required field
	OfferingDescription *string `locationName:"offeringDescription" type:"string" required:"true"`

	// The cost of a single unit. This value, in combination with priceUnits, makes
	// up the rate.
	//
	// PricePerUnit is a required field
	PricePerUnit *string `locationName:"pricePerUnit" type:"string" required:"true"`

	// The unit of measurement that is used for billing. This value, in combination
	// with pricePerUnit, makes up the rate.
	//
	// PriceUnits is a required field
	PriceUnits *string `locationName:"priceUnits" type:"string" required:"true" enum:"PriceUnits"`

	// A definition of the amount of outbound bandwidth that you would be reserving
	// if you purchase the offering.
	//
	// ResourceSpecification is a required field
	ResourceSpecification *ResourceSpecification `locationName:"resourceSpecification" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Offering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *Offering) SetCurrencyCode(v string) *Offering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Offering) SetDuration(v int64) *Offering {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *Offering) SetDurationUnits(v string) *Offering {
	s.DurationUnits = &v
	return s
}

// SetOfferingArn sets the OfferingArn field's value.
func (s *Offering) SetOfferingArn(v string) *Offering {
	s.OfferingArn = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *Offering) SetOfferingDescription(v string) *Offering {
	s.OfferingDescription = &v
	return s
}

// SetPricePerUnit sets the PricePerUnit field's value.
func (s *Offering) SetPricePerUnit(v string) *Offering {
	s.PricePerUnit = &v
	return s
}

// SetPriceUnits sets the PriceUnits field's value.
func (s *Offering) SetPriceUnits(v string) *Offering {
	s.PriceUnits = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *Offering) SetResourceSpecification(v *ResourceSpecification) *Offering {
	s.ResourceSpecification = v
	return s
}

// The settings for an output.
type Output struct {
	_ struct{} `type:"structure"`

	// The ARN of the bridge that added this output.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The bridge output ports currently in use.
	BridgePorts []*int64 `locationName:"bridgePorts" type:"list"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the output.
	Description *string `locationName:"description" type:"string"`

	// The address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement on the originator''s flow. This value is relevant
	// only on entitled flows.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The IP address that the receiver requires in order to establish a connection
	// with the flow. For public networking, the ListenerAddress is represented
	// by the elastic IP address of the flow. For private networking, the ListenerAddress
	// is represented by the elastic network interface IP address of the VPC. This
	// field applies only to outputs that use the Zixi pull or SRT listener protocol.
	ListenerAddress *string `locationName:"listenerAddress" type:"string"`

	// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant
	// only for outputs that were added by creating a MediaLive input.
	MediaLiveInputArn *string `locationName:"mediaLiveInputArn" type:"string"`

	// The configuration for each media stream that is associated with the output.
	MediaStreamOutputConfigurations []*MediaStreamOutputConfiguration `locationName:"mediaStreamOutputConfigurations" type:"list"`

	// The name of the output. This value must be unique within the current flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the output.
	//
	// OutputArn is a required field
	OutputArn *string `locationName:"outputArn" type:"string" required:"true"`

	// An indication of whether the output is transmitting data or not.
	OutputStatus *string `locationName:"outputStatus" type:"string" enum:"OutputStatus"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// Attributes related to the transport stream that are used in the output.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *Output) SetBridgeArn(v string) *Output {
	s.BridgeArn = &v
	return s
}

// SetBridgePorts sets the BridgePorts field's value.
func (s *Output) SetBridgePorts(v []*int64) *Output {
	s.BridgePorts = v
	return s
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Output) SetDataTransferSubscriberFeePercent(v int64) *Output {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *Output) SetDestination(v string) *Output {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Output) SetEncryption(v *Encryption) *Output {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Output) SetEntitlementArn(v string) *Output {
	s.EntitlementArn = &v
	return s
}

// SetListenerAddress sets the ListenerAddress field's value.
func (s *Output) SetListenerAddress(v string) *Output {
	s.ListenerAddress = &v
	return s
}

// SetMediaLiveInputArn sets the MediaLiveInputArn field's value.
func (s *Output) SetMediaLiveInputArn(v string) *Output {
	s.MediaLiveInputArn = &v
	return s
}

// SetMediaStreamOutputConfigurations sets the MediaStreamOutputConfigurations field's value.
func (s *Output) SetMediaStreamOutputConfigurations(v []*MediaStreamOutputConfiguration) *Output {
	s.MediaStreamOutputConfigurations = v
	return s
}

// SetName sets the Name field's value.
func (s *Output) SetName(v string) *Output {
	s.Name = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *Output) SetOutputArn(v string) *Output {
	s.OutputArn = &v
	return s
}

// SetOutputStatus sets the OutputStatus field's value.
func (s *Output) SetOutputStatus(v string) *Output {
	s.OutputStatus = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Output) SetPort(v int64) *Output {
	s.Port = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Output) SetTransport(v *Transport) *Output {
	s.Transport = v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *Output) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *Output {
	s.VpcInterfaceAttachment = v
	return s
}

// Submits a request to purchase an offering, which creates a reservation in
// your AWS account. If you already have an active reservation, you can't purchase
// another offering.
type PurchaseOfferingInput struct {
	_ struct{} `type:"structure"`

	// OfferingArn is a required field
	OfferingArn *string `location:"uri" locationName:"offeringArn" type:"string" required:"true"`

	// The name that you want to use for the reservation.
	//
	// ReservationName is a required field
	ReservationName *string `locationName:"reservationName" type:"string" required:"true"`

	// The date and time that you want the reservation to begin, in Coordinated
	// Universal Time (UTC). You can specify any date and time between 12:00am on
	// the first day of the current month to the current time on today's date, inclusive.
	// Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ,
	// where T and Z are literal characters. For example, to specify 11:30pm on
	// March 5, 2020, enter 2020-03-05T23:30:00Z.
	//
	// Start is a required field
	Start *string `locationName:"start" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseOfferingInput"}
	if s.OfferingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingArn"))
	}
	if s.OfferingArn != nil && len(*s.OfferingArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingArn", 1))
	}
	if s.ReservationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationName"))
	}
	if s.Start == nil {
		invalidParams.Add(request.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingArn sets the OfferingArn field's value.
func (s *PurchaseOfferingInput) SetOfferingArn(v string) *PurchaseOfferingInput {
	s.OfferingArn = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseOfferingInput) SetReservationName(v string) *PurchaseOfferingInput {
	s.ReservationName = &v
	return s
}

// SetStart sets the Start field's value.
func (s *PurchaseOfferingInput) SetStart(v string) *PurchaseOfferingInput {
	s.Start = &v
	return s
}

// The result of a successful PurchaseOffering request.
type PurchaseOfferingOutput struct {
	_ struct{} `type:"structure"`

	// A pricing agreement for a discounted rate for a specific outbound bandwidth
	// that your MediaConnect account will use each month over a specific time period.
	// The discounted rate in the reservation applies to outbound bandwidth for
	// all flows from your account until your account reaches the amount of bandwidth
	// in your reservation. If you use more outbound bandwidth than the agreed upon
	// amount in a single month, the overage is charged at the on-demand rate.
	Reservation *Reservation `locationName:"reservation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PurchaseOfferingOutput) GoString() string {
	return s.String()
}

// SetReservation sets the Reservation field's value.
func (s *PurchaseOfferingOutput) SetReservation(v *Reservation) *PurchaseOfferingOutput {
	s.Reservation = v
	return s
}

type RemoveBridgeOutputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// OutputName is a required field
	OutputName *string `location:"uri" locationName:"outputName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveBridgeOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveBridgeOutputInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.OutputName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputName"))
	}
	if s.OutputName != nil && len(*s.OutputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *RemoveBridgeOutputInput) SetBridgeArn(v string) *RemoveBridgeOutputInput {
	s.BridgeArn = &v
	return s
}

// SetOutputName sets the OutputName field's value.
func (s *RemoveBridgeOutputInput) SetOutputName(v string) *RemoveBridgeOutputInput {
	s.OutputName = &v
	return s
}

// The result of a successful RemoveBridgeOutput request.
type RemoveBridgeOutputOutput struct {
	_ struct{} `type:"structure"`

	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	OutputName *string `locationName:"outputName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeOutputOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *RemoveBridgeOutputOutput) SetBridgeArn(v string) *RemoveBridgeOutputOutput {
	s.BridgeArn = &v
	return s
}

// SetOutputName sets the OutputName field's value.
func (s *RemoveBridgeOutputOutput) SetOutputName(v string) *RemoveBridgeOutputOutput {
	s.OutputName = &v
	return s
}

type RemoveBridgeSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// SourceName is a required field
	SourceName *string `location:"uri" locationName:"sourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveBridgeSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveBridgeSourceInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.SourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceName"))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *RemoveBridgeSourceInput) SetBridgeArn(v string) *RemoveBridgeSourceInput {
	s.BridgeArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *RemoveBridgeSourceInput) SetSourceName(v string) *RemoveBridgeSourceInput {
	s.SourceName = &v
	return s
}

// The result of a successful RemoveBridgeSource request.
type RemoveBridgeSourceOutput struct {
	_ struct{} `type:"structure"`

	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	SourceName *string `locationName:"sourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBridgeSourceOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *RemoveBridgeSourceOutput) SetBridgeArn(v string) *RemoveBridgeSourceOutput {
	s.BridgeArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *RemoveBridgeSourceOutput) SetSourceName(v string) *RemoveBridgeSourceOutput {
	s.SourceName = &v
	return s
}

type RemoveFlowMediaStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// MediaStreamName is a required field
	MediaStreamName *string `location:"uri" locationName:"mediaStreamName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowMediaStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowMediaStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowMediaStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowMediaStreamInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.MediaStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamName"))
	}
	if s.MediaStreamName != nil && len(*s.MediaStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowMediaStreamInput) SetFlowArn(v string) *RemoveFlowMediaStreamInput {
	s.FlowArn = &v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *RemoveFlowMediaStreamInput) SetMediaStreamName(v string) *RemoveFlowMediaStreamInput {
	s.MediaStreamName = &v
	return s
}

// The result of a successful RemoveFlowMediaStream request.
type RemoveFlowMediaStreamOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The name of the media stream that was removed.
	MediaStreamName *string `locationName:"mediaStreamName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowMediaStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowMediaStreamOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowMediaStreamOutput) SetFlowArn(v string) *RemoveFlowMediaStreamOutput {
	s.FlowArn = &v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *RemoveFlowMediaStreamOutput) SetMediaStreamName(v string) *RemoveFlowMediaStreamOutput {
	s.MediaStreamName = &v
	return s
}

type RemoveFlowOutputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}
	if s.OutputArn != nil && len(*s.OutputArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputInput) SetFlowArn(v string) *RemoveFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputInput) SetOutputArn(v string) *RemoveFlowOutputInput {
	s.OutputArn = &v
	return s
}

// The result of a successful RemoveFlowOutput request including the flow ARN
// and the output ARN that was removed.
type RemoveFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the output you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN of the output that was removed.
	OutputArn *string `locationName:"outputArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputOutput) SetFlowArn(v string) *RemoveFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputOutput) SetOutputArn(v string) *RemoveFlowOutputOutput {
	s.OutputArn = &v
	return s
}

type RemoveFlowSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// SourceArn is a required field
	SourceArn *string `location:"uri" locationName:"sourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowSourceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowSourceInput) SetFlowArn(v string) *RemoveFlowSourceInput {
	s.FlowArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *RemoveFlowSourceInput) SetSourceArn(v string) *RemoveFlowSourceInput {
	s.SourceArn = &v
	return s
}

// The result of a successful RemoveFlowSource request including the flow ARN
// and the source ARN that was removed.
type RemoveFlowSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the source you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN of the source that was removed.
	SourceArn *string `locationName:"sourceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowSourceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowSourceOutput) SetFlowArn(v string) *RemoveFlowSourceOutput {
	s.FlowArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *RemoveFlowSourceOutput) SetSourceArn(v string) *RemoveFlowSourceOutput {
	s.SourceArn = &v
	return s
}

type RemoveFlowVpcInterfaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// VpcInterfaceName is a required field
	VpcInterfaceName *string `location:"uri" locationName:"vpcInterfaceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowVpcInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowVpcInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowVpcInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowVpcInterfaceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.VpcInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcInterfaceName"))
	}
	if s.VpcInterfaceName != nil && len(*s.VpcInterfaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcInterfaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowVpcInterfaceInput) SetFlowArn(v string) *RemoveFlowVpcInterfaceInput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *RemoveFlowVpcInterfaceInput) SetVpcInterfaceName(v string) *RemoveFlowVpcInterfaceInput {
	s.VpcInterfaceName = &v
	return s
}

// The result of a successful RemoveFlowVpcInterface request including the flow
// ARN and the VPC interface name that was removed.
type RemoveFlowVpcInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the VPC interface you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// IDs of network interfaces associated with the removed VPC interface that
	// Media Connect was unable to remove.
	NonDeletedNetworkInterfaceIds []*string `locationName:"nonDeletedNetworkInterfaceIds" type:"list"`

	// The name of the VPC interface that was removed.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowVpcInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveFlowVpcInterfaceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetFlowArn(v string) *RemoveFlowVpcInterfaceOutput {
	s.FlowArn = &v
	return s
}

// SetNonDeletedNetworkInterfaceIds sets the NonDeletedNetworkInterfaceIds field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetNonDeletedNetworkInterfaceIds(v []*string) *RemoveFlowVpcInterfaceOutput {
	s.NonDeletedNetworkInterfaceIds = v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetVpcInterfaceName(v string) *RemoveFlowVpcInterfaceOutput {
	s.VpcInterfaceName = &v
	return s
}

// A pricing agreement for a discounted rate for a specific outbound bandwidth
// that your MediaConnect account will use each month over a specific time period.
// The discounted rate in the reservation applies to outbound bandwidth for
// all flows from your account until your account reaches the amount of bandwidth
// in your reservation. If you use more outbound bandwidth than the agreed upon
// amount in a single month, the overage is charged at the on-demand rate.
type Reservation struct {
	_ struct{} `type:"structure"`

	// The type of currency that is used for billing. The currencyCode used for
	// your reservation is US dollars.
	//
	// CurrencyCode is a required field
	CurrencyCode *string `locationName:"currencyCode" type:"string" required:"true"`

	// The length of time that this reservation is active. MediaConnect defines
	// this value in the offering.
	//
	// Duration is a required field
	Duration *int64 `locationName:"duration" type:"integer" required:"true"`

	// The unit of measurement for the duration of the reservation. MediaConnect
	// defines this value in the offering.
	//
	// DurationUnits is a required field
	DurationUnits *string `locationName:"durationUnits" type:"string" required:"true" enum:"DurationUnits"`

	// The day and time that this reservation expires. This value is calculated
	// based on the start date and time that you set and the offering's duration.
	//
	// End is a required field
	End *string `locationName:"end" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
	//
	// OfferingArn is a required field
	OfferingArn *string `locationName:"offeringArn" type:"string" required:"true"`

	// A description of the offering. MediaConnect defines this value in the offering.
	//
	// OfferingDescription is a required field
	OfferingDescription *string `locationName:"offeringDescription" type:"string" required:"true"`

	// The cost of a single unit. This value, in combination with priceUnits, makes
	// up the rate. MediaConnect defines this value in the offering.
	//
	// PricePerUnit is a required field
	PricePerUnit *string `locationName:"pricePerUnit" type:"string" required:"true"`

	// The unit of measurement that is used for billing. This value, in combination
	// with pricePerUnit, makes up the rate. MediaConnect defines this value in
	// the offering.
	//
	// PriceUnits is a required field
	PriceUnits *string `locationName:"priceUnits" type:"string" required:"true" enum:"PriceUnits"`

	// The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation
	// when you purchase an offering.
	//
	// ReservationArn is a required field
	ReservationArn *string `locationName:"reservationArn" type:"string" required:"true"`

	// The name that you assigned to the reservation when you purchased the offering.
	//
	// ReservationName is a required field
	ReservationName *string `locationName:"reservationName" type:"string" required:"true"`

	// The status of your reservation.
	//
	// ReservationState is a required field
	ReservationState *string `locationName:"reservationState" type:"string" required:"true" enum:"ReservationState"`

	// A definition of the amount of outbound bandwidth that you would be reserving
	// if you purchase the offering. MediaConnect defines the values that make up
	// the resourceSpecification in the offering.
	//
	// ResourceSpecification is a required field
	ResourceSpecification *ResourceSpecification `locationName:"resourceSpecification" type:"structure" required:"true"`

	// The day and time that the reservation becomes active. You set this value
	// when you purchase the offering.
	//
	// Start is a required field
	Start *string `locationName:"start" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Reservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Reservation) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *Reservation) SetCurrencyCode(v string) *Reservation {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Reservation) SetDuration(v int64) *Reservation {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *Reservation) SetDurationUnits(v string) *Reservation {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *Reservation) SetEnd(v string) *Reservation {
	s.End = &v
	return s
}

// SetOfferingArn sets the OfferingArn field's value.
func (s *Reservation) SetOfferingArn(v string) *Reservation {
	s.OfferingArn = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *Reservation) SetOfferingDescription(v string) *Reservation {
	s.OfferingDescription = &v
	return s
}

// SetPricePerUnit sets the PricePerUnit field's value.
func (s *Reservation) SetPricePerUnit(v string) *Reservation {
	s.PricePerUnit = &v
	return s
}

// SetPriceUnits sets the PriceUnits field's value.
func (s *Reservation) SetPriceUnits(v string) *Reservation {
	s.PriceUnits = &v
	return s
}

// SetReservationArn sets the ReservationArn field's value.
func (s *Reservation) SetReservationArn(v string) *Reservation {
	s.ReservationArn = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *Reservation) SetReservationName(v string) *Reservation {
	s.ReservationName = &v
	return s
}

// SetReservationState sets the ReservationState field's value.
func (s *Reservation) SetReservationState(v string) *Reservation {
	s.ReservationState = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *Reservation) SetResourceSpecification(v *ResourceSpecification) *Reservation {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *Reservation) SetStart(v string) *Reservation {
	s.Start = &v
	return s
}

// A definition of what is being billed for, including the type and amount.
type ResourceSpecification struct {
	_ struct{} `type:"structure"`

	// The amount of outbound bandwidth that is discounted in the offering.
	ReservedBitrate *int64 `locationName:"reservedBitrate" type:"integer"`

	// The type of resource and the unit that is being billed for.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSpecification) GoString() string {
	return s.String()
}

// SetReservedBitrate sets the ReservedBitrate field's value.
func (s *ResourceSpecification) SetReservedBitrate(v int64) *ResourceSpecification {
	s.ReservedBitrate = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSpecification) SetResourceType(v string) *ResourceSpecification {
	s.ResourceType = &v
	return s
}

type RevokeFlowEntitlementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.EntitlementArn != nil && len(*s.EntitlementArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntitlementArn", 1))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementInput) SetEntitlementArn(v string) *RevokeFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementInput) SetFlowArn(v string) *RevokeFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// The result of a successful RevokeFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the ARN of the entitlement that
// was revoked.
type RevokeFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entitlement that was revoked.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The ARN of the flow that the entitlement was revoked from.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementOutput) SetEntitlementArn(v string) *RevokeFlowEntitlementOutput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementOutput) SetFlowArn(v string) *RevokeFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The source configuration for cloud flows receiving a stream from a bridge.
type SetGatewayBridgeSourceRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the bridge feeding this flow.
	//
	// BridgeArn is a required field
	BridgeArn *string `locationName:"bridgeArn" type:"string" required:"true"`

	// The name of the VPC interface attachment to use for this bridge source.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetGatewayBridgeSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetGatewayBridgeSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetGatewayBridgeSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetGatewayBridgeSourceRequest"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *SetGatewayBridgeSourceRequest) SetBridgeArn(v string) *SetGatewayBridgeSourceRequest {
	s.BridgeArn = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *SetGatewayBridgeSourceRequest) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *SetGatewayBridgeSourceRequest {
	s.VpcInterfaceAttachment = v
	return s
}

// The settings for the source of the flow.
type SetSourceRequest struct {
	_ struct{} `type:"structure"`

	// The type of encryption that is used on the content ingested from this source.
	// Allowable encryption types: static-key.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The source configuration for cloud flows receiving a stream from a bridge.
	GatewayBridgeSource *SetGatewayBridgeSourceRequest `locationName:"gatewayBridgeSource" type:"structure"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based,
	// Zixi-based, and Fujitsu-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The size of the buffer (in milliseconds) to use to sync incoming source data.
	MaxSyncBuffer *int64 `locationName:"maxSyncBuffer" type:"integer"`

	// The media streams that are associated with the source, and the parameters
	// for those associations.
	MediaStreamSourceConfigurations []*MediaStreamSourceConfigurationRequest `locationName:"mediaStreamSourceConfigurations" type:"list"`

	// The minimum latency in milliseconds for SRT-based streams. In streams that
	// use the SRT protocol, this value that you set on your MediaConnect source
	// or output represents the minimal potential latency of that connection. The
	// latency of the stream is set to the highest number between the sender’s
	// minimum latency and the receiver’s minimum latency.
	MinLatency *int64 `locationName:"minLatency" type:"integer"`

	// The name of the source.
	Name *string `locationName:"name" type:"string"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The IP address that the flow communicates with to initiate connection with
	// the sender.
	SenderIpAddress *string `locationName:"senderIpAddress" type:"string"`

	// Source IP or domain name for SRT-caller protocol.
	SourceListenerAddress *string `locationName:"sourceListenerAddress" type:"string"`

	// Source port for SRT-caller protocol.
	SourceListenerPort *int64 `locationName:"sourceListenerPort" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface to use for this source.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSourceRequest"}
	if s.Decryption != nil {
		if err := s.Decryption.Validate(); err != nil {
			invalidParams.AddNested("Decryption", err.(request.ErrInvalidParams))
		}
	}
	if s.GatewayBridgeSource != nil {
		if err := s.GatewayBridgeSource.Validate(); err != nil {
			invalidParams.AddNested("GatewayBridgeSource", err.(request.ErrInvalidParams))
		}
	}
	if s.MediaStreamSourceConfigurations != nil {
		for i, v := range s.MediaStreamSourceConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreamSourceConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *SetSourceRequest) SetDecryption(v *Encryption) *SetSourceRequest {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *SetSourceRequest) SetDescription(v string) *SetSourceRequest {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *SetSourceRequest) SetEntitlementArn(v string) *SetSourceRequest {
	s.EntitlementArn = &v
	return s
}

// SetGatewayBridgeSource sets the GatewayBridgeSource field's value.
func (s *SetSourceRequest) SetGatewayBridgeSource(v *SetGatewayBridgeSourceRequest) *SetSourceRequest {
	s.GatewayBridgeSource = v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *SetSourceRequest) SetIngestPort(v int64) *SetSourceRequest {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *SetSourceRequest) SetMaxBitrate(v int64) *SetSourceRequest {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *SetSourceRequest) SetMaxLatency(v int64) *SetSourceRequest {
	s.MaxLatency = &v
	return s
}

// SetMaxSyncBuffer sets the MaxSyncBuffer field's value.
func (s *SetSourceRequest) SetMaxSyncBuffer(v int64) *SetSourceRequest {
	s.MaxSyncBuffer = &v
	return s
}

// SetMediaStreamSourceConfigurations sets the MediaStreamSourceConfigurations field's value.
func (s *SetSourceRequest) SetMediaStreamSourceConfigurations(v []*MediaStreamSourceConfigurationRequest) *SetSourceRequest {
	s.MediaStreamSourceConfigurations = v
	return s
}

// SetMinLatency sets the MinLatency field's value.
func (s *SetSourceRequest) SetMinLatency(v int64) *SetSourceRequest {
	s.MinLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *SetSourceRequest) SetName(v string) *SetSourceRequest {
	s.Name = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *SetSourceRequest) SetProtocol(v string) *SetSourceRequest {
	s.Protocol = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *SetSourceRequest) SetSenderControlPort(v int64) *SetSourceRequest {
	s.SenderControlPort = &v
	return s
}

// SetSenderIpAddress sets the SenderIpAddress field's value.
func (s *SetSourceRequest) SetSenderIpAddress(v string) *SetSourceRequest {
	s.SenderIpAddress = &v
	return s
}

// SetSourceListenerAddress sets the SourceListenerAddress field's value.
func (s *SetSourceRequest) SetSourceListenerAddress(v string) *SetSourceRequest {
	s.SourceListenerAddress = &v
	return s
}

// SetSourceListenerPort sets the SourceListenerPort field's value.
func (s *SetSourceRequest) SetSourceListenerPort(v int64) *SetSourceRequest {
	s.SourceListenerPort = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *SetSourceRequest) SetStreamId(v string) *SetSourceRequest {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *SetSourceRequest) SetVpcInterfaceName(v string) *SetSourceRequest {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *SetSourceRequest) SetWhitelistCidr(v string) *SetSourceRequest {
	s.WhitelistCidr = &v
	return s
}

// The settings for the source of the flow.
type Source struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to content that comes
	// from another AWS account. The entitlement is set by the content originator
	// and the ARN is generated as part of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The source configuration for cloud flows receiving a stream from a bridge.
	GatewayBridgeSource *GatewayBridgeSource `locationName:"gatewayBridgeSource" type:"structure"`

	// The IP address that the flow will be listening on for incoming content.
	IngestIp *string `locationName:"ingestIp" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The media streams that are associated with the source, and the parameters
	// for those associations.
	MediaStreamSourceConfigurations []*MediaStreamSourceConfiguration `locationName:"mediaStreamSourceConfigurations" type:"list"`

	// The name of the source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The IP address that the flow communicates with to initiate connection with
	// the sender.
	SenderIpAddress *string `locationName:"senderIpAddress" type:"string"`

	// The ARN of the source.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" type:"string" required:"true"`

	// Attributes related to the transport stream that are used in the source.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC interface that is used for this source.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Source) SetDataTransferSubscriberFeePercent(v int64) *Source {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDecryption sets the Decryption field's value.
func (s *Source) SetDecryption(v *Encryption) *Source {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Source) SetDescription(v string) *Source {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Source) SetEntitlementArn(v string) *Source {
	s.EntitlementArn = &v
	return s
}

// SetGatewayBridgeSource sets the GatewayBridgeSource field's value.
func (s *Source) SetGatewayBridgeSource(v *GatewayBridgeSource) *Source {
	s.GatewayBridgeSource = v
	return s
}

// SetIngestIp sets the IngestIp field's value.
func (s *Source) SetIngestIp(v string) *Source {
	s.IngestIp = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *Source) SetIngestPort(v int64) *Source {
	s.IngestPort = &v
	return s
}

// SetMediaStreamSourceConfigurations sets the MediaStreamSourceConfigurations field's value.
func (s *Source) SetMediaStreamSourceConfigurations(v []*MediaStreamSourceConfiguration) *Source {
	s.MediaStreamSourceConfigurations = v
	return s
}

// SetName sets the Name field's value.
func (s *Source) SetName(v string) *Source {
	s.Name = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *Source) SetSenderControlPort(v int64) *Source {
	s.SenderControlPort = &v
	return s
}

// SetSenderIpAddress sets the SenderIpAddress field's value.
func (s *Source) SetSenderIpAddress(v string) *Source {
	s.SenderIpAddress = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Source) SetSourceArn(v string) *Source {
	s.SourceArn = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Source) SetTransport(v *Transport) *Source {
	s.Transport = v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *Source) SetVpcInterfaceName(v string) *Source {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *Source) SetWhitelistCidr(v string) *Source {
	s.WhitelistCidr = &v
	return s
}

// The priority you want to assign to a source. You can have a primary stream
// and a backup stream or two equally prioritized streams.
type SourcePriority struct {
	_ struct{} `type:"structure"`

	// The name of the source you choose as the primary source for this flow.
	PrimarySource *string `locationName:"primarySource" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourcePriority) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourcePriority) GoString() string {
	return s.String()
}

// SetPrimarySource sets the PrimarySource field's value.
func (s *SourcePriority) SetPrimarySource(v string) *SourcePriority {
	s.PrimarySource = &v
	return s
}

type StartFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowInput) SetFlowArn(v string) *StartFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StartFlow request.
type StartFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you started.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StartFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowOutput) SetFlowArn(v string) *StartFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartFlowOutput) SetStatus(v string) *StartFlowOutput {
	s.Status = &v
	return s
}

type StopFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowInput) SetFlowArn(v string) *StopFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StopFlow request.
type StopFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you stopped.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StopFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowOutput) SetFlowArn(v string) *StopFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopFlowOutput) SetStatus(v string) *StopFlowOutput {
	s.Status = &v
	return s
}

// The tags to add to the resource. Tag keys can have a maximum character length
// of 128 characters, and tag values can have a maximum length of 256 characters.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A map from tag keys to values. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Attributes related to the transport stream that are used in a source or output.
type Transport struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based,
	// Zixi-based, and Fujitsu-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The size of the buffer (in milliseconds) to use to sync incoming source data.
	MaxSyncBuffer *int64 `locationName:"maxSyncBuffer" type:"integer"`

	// The minimum latency in milliseconds for SRT-based streams. In streams that
	// use the SRT protocol, this value that you set on your MediaConnect source
	// or output represents the minimal potential latency of that connection. The
	// latency of the stream is set to the highest number between the sender’s
	// minimum latency and the receiver’s minimum latency.
	MinLatency *int64 `locationName:"minLatency" type:"integer"`

	// The protocol that is used by the source or output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The remote ID for the Zixi-pull stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The IP address that the flow communicates with to initiate connection with
	// the sender.
	SenderIpAddress *string `locationName:"senderIpAddress" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// Source IP or domain name for SRT-caller protocol.
	SourceListenerAddress *string `locationName:"sourceListenerAddress" type:"string"`

	// Source port for SRT-caller protocol.
	SourceListenerPort *int64 `locationName:"sourceListenerPort" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transport) GoString() string {
	return s.String()
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *Transport) SetCidrAllowList(v []*string) *Transport {
	s.CidrAllowList = v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *Transport) SetMaxBitrate(v int64) *Transport {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *Transport) SetMaxLatency(v int64) *Transport {
	s.MaxLatency = &v
	return s
}

// SetMaxSyncBuffer sets the MaxSyncBuffer field's value.
func (s *Transport) SetMaxSyncBuffer(v int64) *Transport {
	s.MaxSyncBuffer = &v
	return s
}

// SetMinLatency sets the MinLatency field's value.
func (s *Transport) SetMinLatency(v int64) *Transport {
	s.MinLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Transport) SetProtocol(v string) *Transport {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *Transport) SetRemoteId(v string) *Transport {
	s.RemoteId = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *Transport) SetSenderControlPort(v int64) *Transport {
	s.SenderControlPort = &v
	return s
}

// SetSenderIpAddress sets the SenderIpAddress field's value.
func (s *Transport) SetSenderIpAddress(v string) *Transport {
	s.SenderIpAddress = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *Transport) SetSmoothingLatency(v int64) *Transport {
	s.SmoothingLatency = &v
	return s
}

// SetSourceListenerAddress sets the SourceListenerAddress field's value.
func (s *Transport) SetSourceListenerAddress(v string) *Transport {
	s.SourceListenerAddress = &v
	return s
}

// SetSourceListenerPort sets the SourceListenerPort field's value.
func (s *Transport) SetSourceListenerPort(v int64) *Transport {
	s.SourceListenerPort = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *Transport) SetStreamId(v string) *Transport {
	s.StreamId = &v
	return s
}

// The metadata of the transport stream in the current flow's source.
type TransportMediaInfo struct {
	_ struct{} `type:"structure"`

	// The list of transport stream programs in the current flow's source.
	//
	// Programs is a required field
	Programs []*TransportStreamProgram `locationName:"programs" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportMediaInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportMediaInfo) GoString() string {
	return s.String()
}

// SetPrograms sets the Programs field's value.
func (s *TransportMediaInfo) SetPrograms(v []*TransportStreamProgram) *TransportMediaInfo {
	s.Programs = v
	return s
}

// The metadata of an elementary transport stream.
type TransportStream struct {
	_ struct{} `type:"structure"`

	// The number of channels in the audio stream.
	Channels *int64 `locationName:"channels" type:"integer"`

	// The codec used by the stream.
	Codec *string `locationName:"codec" type:"string"`

	// The frame rate used by the video stream.
	FrameRate *string `locationName:"frameRate" type:"string"`

	// The frame resolution used by the video stream.
	FrameResolution *FrameResolution `locationName:"frameResolution" type:"structure"`

	// The Packet ID (PID) as it is reported in the Program Map Table.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`

	// The sample rate used by the audio stream.
	SampleRate *int64 `locationName:"sampleRate" type:"integer"`

	// The sample bit size used by the audio stream.
	SampleSize *int64 `locationName:"sampleSize" type:"integer"`

	// The Stream Type as it is reported in the Program Map Table.
	//
	// StreamType is a required field
	StreamType *string `locationName:"streamType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportStream) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *TransportStream) SetChannels(v int64) *TransportStream {
	s.Channels = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *TransportStream) SetCodec(v string) *TransportStream {
	s.Codec = &v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *TransportStream) SetFrameRate(v string) *TransportStream {
	s.FrameRate = &v
	return s
}

// SetFrameResolution sets the FrameResolution field's value.
func (s *TransportStream) SetFrameResolution(v *FrameResolution) *TransportStream {
	s.FrameResolution = v
	return s
}

// SetPid sets the Pid field's value.
func (s *TransportStream) SetPid(v int64) *TransportStream {
	s.Pid = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *TransportStream) SetSampleRate(v int64) *TransportStream {
	s.SampleRate = &v
	return s
}

// SetSampleSize sets the SampleSize field's value.
func (s *TransportStream) SetSampleSize(v int64) *TransportStream {
	s.SampleSize = &v
	return s
}

// SetStreamType sets the StreamType field's value.
func (s *TransportStream) SetStreamType(v string) *TransportStream {
	s.StreamType = &v
	return s
}

// The metadata of a single transport stream program.
type TransportStreamProgram struct {
	_ struct{} `type:"structure"`

	// The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the
	// Program Association Table.
	//
	// PcrPid is a required field
	PcrPid *int64 `locationName:"pcrPid" type:"integer" required:"true"`

	// The program name as it is reported in the Program Association Table.
	ProgramName *string `locationName:"programName" type:"string"`

	// The program number as it is reported in the Program Association Table.
	//
	// ProgramNumber is a required field
	ProgramNumber *int64 `locationName:"programNumber" type:"integer" required:"true"`

	// The program Packet ID (PID) as it is reported in the Program Association
	// Table.
	//
	// ProgramPid is a required field
	ProgramPid *int64 `locationName:"programPid" type:"integer" required:"true"`

	// The list of elementary transport streams in the program. The list includes
	// video, audio, and data streams.
	//
	// Streams is a required field
	Streams []*TransportStream `locationName:"streams" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportStreamProgram) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransportStreamProgram) GoString() string {
	return s.String()
}

// SetPcrPid sets the PcrPid field's value.
func (s *TransportStreamProgram) SetPcrPid(v int64) *TransportStreamProgram {
	s.PcrPid = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *TransportStreamProgram) SetProgramName(v string) *TransportStreamProgram {
	s.ProgramName = &v
	return s
}

// SetProgramNumber sets the ProgramNumber field's value.
func (s *TransportStreamProgram) SetProgramNumber(v int64) *TransportStreamProgram {
	s.ProgramNumber = &v
	return s
}

// SetProgramPid sets the ProgramPid field's value.
func (s *TransportStreamProgram) SetProgramPid(v int64) *TransportStreamProgram {
	s.ProgramPid = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *TransportStreamProgram) SetStreams(v []*TransportStream) *TransportStreamProgram {
	s.Streams = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Update the flow source of the bridge.
type UpdateBridgeFlowSourceRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the cloud flow to use as a source of this bridge.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The name of the VPC interface attachment to use for this source.
	FlowVpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"flowVpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeFlowSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeFlowSourceRequest) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateBridgeFlowSourceRequest) SetFlowArn(v string) *UpdateBridgeFlowSourceRequest {
	s.FlowArn = &v
	return s
}

// SetFlowVpcInterfaceAttachment sets the FlowVpcInterfaceAttachment field's value.
func (s *UpdateBridgeFlowSourceRequest) SetFlowVpcInterfaceAttachment(v *VpcInterfaceAttachment) *UpdateBridgeFlowSourceRequest {
	s.FlowVpcInterfaceAttachment = v
	return s
}

// Update an existing bridge.
type UpdateBridgeInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	EgressGatewayBridge *UpdateEgressGatewayBridgeRequest `locationName:"egressGatewayBridge" type:"structure"`

	IngressGatewayBridge *UpdateIngressGatewayBridgeRequest `locationName:"ingressGatewayBridge" type:"structure"`

	// The settings for source failover.
	SourceFailoverConfig *UpdateFailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBridgeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBridgeInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeInput) SetBridgeArn(v string) *UpdateBridgeInput {
	s.BridgeArn = &v
	return s
}

// SetEgressGatewayBridge sets the EgressGatewayBridge field's value.
func (s *UpdateBridgeInput) SetEgressGatewayBridge(v *UpdateEgressGatewayBridgeRequest) *UpdateBridgeInput {
	s.EgressGatewayBridge = v
	return s
}

// SetIngressGatewayBridge sets the IngressGatewayBridge field's value.
func (s *UpdateBridgeInput) SetIngressGatewayBridge(v *UpdateIngressGatewayBridgeRequest) *UpdateBridgeInput {
	s.IngressGatewayBridge = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *UpdateBridgeInput) SetSourceFailoverConfig(v *UpdateFailoverConfig) *UpdateBridgeInput {
	s.SourceFailoverConfig = v
	return s
}

// Update an existing network output.
type UpdateBridgeNetworkOutputRequest struct {
	_ struct{} `type:"structure"`

	// The network output IP Address.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// The network output's gateway network name.
	NetworkName *string `locationName:"networkName" type:"string"`

	// The network output port.
	Port *int64 `locationName:"port" type:"integer"`

	// The network output protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The network output TTL.
	Ttl *int64 `locationName:"ttl" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeNetworkOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeNetworkOutputRequest) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *UpdateBridgeNetworkOutputRequest) SetIpAddress(v string) *UpdateBridgeNetworkOutputRequest {
	s.IpAddress = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *UpdateBridgeNetworkOutputRequest) SetNetworkName(v string) *UpdateBridgeNetworkOutputRequest {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateBridgeNetworkOutputRequest) SetPort(v int64) *UpdateBridgeNetworkOutputRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateBridgeNetworkOutputRequest) SetProtocol(v string) *UpdateBridgeNetworkOutputRequest {
	s.Protocol = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *UpdateBridgeNetworkOutputRequest) SetTtl(v int64) *UpdateBridgeNetworkOutputRequest {
	s.Ttl = &v
	return s
}

// Update the network source of the bridge.
type UpdateBridgeNetworkSourceRequest struct {
	_ struct{} `type:"structure"`

	// The network source multicast IP.
	MulticastIp *string `locationName:"multicastIp" type:"string"`

	// The network source's gateway network name.
	NetworkName *string `locationName:"networkName" type:"string"`

	// The network source port.
	Port *int64 `locationName:"port" type:"integer"`

	// The network source protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeNetworkSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeNetworkSourceRequest) GoString() string {
	return s.String()
}

// SetMulticastIp sets the MulticastIp field's value.
func (s *UpdateBridgeNetworkSourceRequest) SetMulticastIp(v string) *UpdateBridgeNetworkSourceRequest {
	s.MulticastIp = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *UpdateBridgeNetworkSourceRequest) SetNetworkName(v string) *UpdateBridgeNetworkSourceRequest {
	s.NetworkName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateBridgeNetworkSourceRequest) SetPort(v int64) *UpdateBridgeNetworkSourceRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateBridgeNetworkSourceRequest) SetProtocol(v string) *UpdateBridgeNetworkSourceRequest {
	s.Protocol = &v
	return s
}

// The bridge has been successfully updated.
type UpdateBridgeOutput struct {
	_ struct{} `type:"structure"`

	// A Bridge is the connection between your datacenter's Instances and the AWS
	// cloud. A bridge can be used to send video from the AWS cloud to your datacenter
	// or from your datacenter to the AWS cloud.
	Bridge *Bridge `locationName:"bridge" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutput) GoString() string {
	return s.String()
}

// SetBridge sets the Bridge field's value.
func (s *UpdateBridgeOutput) SetBridge(v *Bridge) *UpdateBridgeOutput {
	s.Bridge = v
	return s
}

// Update an existing bridge output.
type UpdateBridgeOutputInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// Update an existing network output.
	NetworkOutput *UpdateBridgeNetworkOutputRequest `locationName:"networkOutput" type:"structure"`

	// OutputName is a required field
	OutputName *string `location:"uri" locationName:"outputName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBridgeOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBridgeOutputInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.OutputName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputName"))
	}
	if s.OutputName != nil && len(*s.OutputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeOutputInput) SetBridgeArn(v string) *UpdateBridgeOutputInput {
	s.BridgeArn = &v
	return s
}

// SetNetworkOutput sets the NetworkOutput field's value.
func (s *UpdateBridgeOutputInput) SetNetworkOutput(v *UpdateBridgeNetworkOutputRequest) *UpdateBridgeOutputInput {
	s.NetworkOutput = v
	return s
}

// SetOutputName sets the OutputName field's value.
func (s *UpdateBridgeOutputInput) SetOutputName(v string) *UpdateBridgeOutputInput {
	s.OutputName = &v
	return s
}

// The result of a successful UpdateBridgeOutput request.
type UpdateBridgeOutputOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The output that you updated.
	Output *BridgeOutput_ `locationName:"output" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeOutputOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeOutputOutput) SetBridgeArn(v string) *UpdateBridgeOutputOutput {
	s.BridgeArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *UpdateBridgeOutputOutput) SetOutput(v *BridgeOutput_) *UpdateBridgeOutputOutput {
	s.Output = v
	return s
}

// Update the bridge source.
type UpdateBridgeSourceInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// Update the flow source of the bridge.
	FlowSource *UpdateBridgeFlowSourceRequest `locationName:"flowSource" type:"structure"`

	// Update the network source of the bridge.
	NetworkSource *UpdateBridgeNetworkSourceRequest `locationName:"networkSource" type:"structure"`

	// SourceName is a required field
	SourceName *string `location:"uri" locationName:"sourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBridgeSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBridgeSourceInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.SourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceName"))
	}
	if s.SourceName != nil && len(*s.SourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeSourceInput) SetBridgeArn(v string) *UpdateBridgeSourceInput {
	s.BridgeArn = &v
	return s
}

// SetFlowSource sets the FlowSource field's value.
func (s *UpdateBridgeSourceInput) SetFlowSource(v *UpdateBridgeFlowSourceRequest) *UpdateBridgeSourceInput {
	s.FlowSource = v
	return s
}

// SetNetworkSource sets the NetworkSource field's value.
func (s *UpdateBridgeSourceInput) SetNetworkSource(v *UpdateBridgeNetworkSourceRequest) *UpdateBridgeSourceInput {
	s.NetworkSource = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *UpdateBridgeSourceInput) SetSourceName(v string) *UpdateBridgeSourceInput {
	s.SourceName = &v
	return s
}

// The result of a successful UpdateBridgeSource request.
type UpdateBridgeSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The bridge's source.
	Source *BridgeSource `locationName:"source" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeSourceOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeSourceOutput) SetBridgeArn(v string) *UpdateBridgeSourceOutput {
	s.BridgeArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateBridgeSourceOutput) SetSource(v *BridgeSource) *UpdateBridgeSourceOutput {
	s.Source = v
	return s
}

// Update the state of a bridge. ACTIVE or STANDBY.
type UpdateBridgeStateInput struct {
	_ struct{} `type:"structure"`

	// BridgeArn is a required field
	BridgeArn *string `location:"uri" locationName:"bridgeArn" type:"string" required:"true"`

	// DesiredState is a required field
	DesiredState *string `locationName:"desiredState" type:"string" required:"true" enum:"DesiredState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBridgeStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBridgeStateInput"}
	if s.BridgeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BridgeArn"))
	}
	if s.BridgeArn != nil && len(*s.BridgeArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BridgeArn", 1))
	}
	if s.DesiredState == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeStateInput) SetBridgeArn(v string) *UpdateBridgeStateInput {
	s.BridgeArn = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *UpdateBridgeStateInput) SetDesiredState(v string) *UpdateBridgeStateInput {
	s.DesiredState = &v
	return s
}

// The bridge state has been updated.
type UpdateBridgeStateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the bridge.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The state of the bridge. ACTIVE or STANDBY.
	DesiredState *string `locationName:"desiredState" type:"string" enum:"DesiredState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBridgeStateOutput) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateBridgeStateOutput) SetBridgeArn(v string) *UpdateBridgeStateOutput {
	s.BridgeArn = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *UpdateBridgeStateOutput) SetDesiredState(v string) *UpdateBridgeStateOutput {
	s.DesiredState = &v
	return s
}

type UpdateEgressGatewayBridgeRequest struct {
	_ struct{} `type:"structure"`

	// Update an existing egress-type bridge.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEgressGatewayBridgeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEgressGatewayBridgeRequest) GoString() string {
	return s.String()
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *UpdateEgressGatewayBridgeRequest) SetMaxBitrate(v int64) *UpdateEgressGatewayBridgeRequest {
	s.MaxBitrate = &v
	return s
}

// Information about the encryption of the flow.
type UpdateEncryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	Algorithm *string `locationName:"algorithm" type:"string" enum:"Algorithm"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryption) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *UpdateEncryption) SetAlgorithm(v string) *UpdateEncryption {
	s.Algorithm = &v
	return s
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *UpdateEncryption) SetConstantInitializationVector(v string) *UpdateEncryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateEncryption) SetDeviceId(v string) *UpdateEncryption {
	s.DeviceId = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *UpdateEncryption) SetKeyType(v string) *UpdateEncryption {
	s.KeyType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *UpdateEncryption) SetRegion(v string) *UpdateEncryption {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateEncryption) SetResourceId(v string) *UpdateEncryption {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEncryption) SetRoleArn(v string) *UpdateEncryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *UpdateEncryption) SetSecretArn(v string) *UpdateEncryption {
	s.SecretArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UpdateEncryption) SetUrl(v string) *UpdateEncryption {
	s.Url = &v
	return s
}

// The settings for source failover.
type UpdateFailoverConfig struct {
	_ struct{} `type:"structure"`

	// The type of failover you choose for this flow. MERGE combines the source
	// streams into a single stream, allowing graceful recovery from any single-source
	// loss. FAILOVER allows switching between different streams.
	FailoverMode *string `locationName:"failoverMode" type:"string" enum:"FailoverMode"`

	// Recovery window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	// The priority you want to assign to a source. You can have a primary stream
	// and a backup stream or two equally prioritized streams.
	SourcePriority *SourcePriority `locationName:"sourcePriority" type:"structure"`

	State *string `locationName:"state" type:"string" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFailoverConfig) GoString() string {
	return s.String()
}

// SetFailoverMode sets the FailoverMode field's value.
func (s *UpdateFailoverConfig) SetFailoverMode(v string) *UpdateFailoverConfig {
	s.FailoverMode = &v
	return s
}

// SetRecoveryWindow sets the RecoveryWindow field's value.
func (s *UpdateFailoverConfig) SetRecoveryWindow(v int64) *UpdateFailoverConfig {
	s.RecoveryWindow = &v
	return s
}

// SetSourcePriority sets the SourcePriority field's value.
func (s *UpdateFailoverConfig) SetSourcePriority(v *SourcePriority) *UpdateFailoverConfig {
	s.SourcePriority = v
	return s
}

// SetState sets the State field's value.
func (s *UpdateFailoverConfig) SetState(v string) *UpdateFailoverConfig {
	s.State = &v
	return s
}

// The updates that you want to make to a specific entitlement.
type UpdateFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output associated with this
	// entitlement. Allowable encryption types: static-key, speke.
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// An indication of whether you want to enable the entitlement to allow access,
	// or disable it to stop streaming content to the subscriber’s flow temporarily.
	// If you don’t specify the entitlementStatus field in your request, MediaConnect
	// leaves the value unchanged.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	Subscribers []*string `locationName:"subscribers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.EntitlementArn != nil && len(*s.EntitlementArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntitlementArn", 1))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowEntitlementInput) SetDescription(v string) *UpdateFlowEntitlementInput {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowEntitlementInput) SetEncryption(v *UpdateEncryption) *UpdateFlowEntitlementInput {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowEntitlementInput) SetEntitlementArn(v string) *UpdateFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *UpdateFlowEntitlementInput) SetEntitlementStatus(v string) *UpdateFlowEntitlementInput {
	s.EntitlementStatus = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementInput) SetFlowArn(v string) *UpdateFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *UpdateFlowEntitlementInput) SetSubscribers(v []*string) *UpdateFlowEntitlementInput {
	s.Subscribers = v
	return s
}

// The result of a successful UpdateFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the updated entitlement configuration.
type UpdateFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The new configuration of the entitlement that you updated.
	Entitlement *Entitlement `locationName:"entitlement" type:"structure"`

	// The ARN of the flow that this entitlement was granted on.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlement sets the Entitlement field's value.
func (s *UpdateFlowEntitlementOutput) SetEntitlement(v *Entitlement) *UpdateFlowEntitlementOutput {
	s.Entitlement = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementOutput) SetFlowArn(v string) *UpdateFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// Updates an existing flow.
type UpdateFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// Update maintenance setting for a flow
	Maintenance *UpdateMaintenance `locationName:"maintenance" type:"structure"`

	// The settings for source failover.
	SourceFailoverConfig *UpdateFailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowInput) SetFlowArn(v string) *UpdateFlowInput {
	s.FlowArn = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *UpdateFlowInput) SetMaintenance(v *UpdateMaintenance) *UpdateFlowInput {
	s.Maintenance = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *UpdateFlowInput) SetSourceFailoverConfig(v *UpdateFailoverConfig) *UpdateFlowInput {
	s.SourceFailoverConfig = v
	return s
}

// Update a media stream on a flow.
type UpdateFlowMediaStreamInput struct {
	_ struct{} `type:"structure"`

	// The attributes that you want to assign to the media stream.
	Attributes *MediaStreamAttributesRequest `locationName:"attributes" type:"structure"`

	// The sample rate (in Hz) for the stream. If the media stream type is video
	// or ancillary data, set this value to 90000. If the media stream type is audio,
	// set this value to either 48000 or 96000.
	ClockRate *int64 `locationName:"clockRate" type:"integer"`

	// Description
	Description *string `locationName:"description" type:"string"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// MediaStreamName is a required field
	MediaStreamName *string `location:"uri" locationName:"mediaStreamName" type:"string" required:"true"`

	// The type of media stream.
	MediaStreamType *string `locationName:"mediaStreamType" type:"string" enum:"MediaStreamType"`

	// The resolution of the video.
	VideoFormat *string `locationName:"videoFormat" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowMediaStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowMediaStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowMediaStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowMediaStreamInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.MediaStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaStreamName"))
	}
	if s.MediaStreamName != nil && len(*s.MediaStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateFlowMediaStreamInput) SetAttributes(v *MediaStreamAttributesRequest) *UpdateFlowMediaStreamInput {
	s.Attributes = v
	return s
}

// SetClockRate sets the ClockRate field's value.
func (s *UpdateFlowMediaStreamInput) SetClockRate(v int64) *UpdateFlowMediaStreamInput {
	s.ClockRate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowMediaStreamInput) SetDescription(v string) *UpdateFlowMediaStreamInput {
	s.Description = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowMediaStreamInput) SetFlowArn(v string) *UpdateFlowMediaStreamInput {
	s.FlowArn = &v
	return s
}

// SetMediaStreamName sets the MediaStreamName field's value.
func (s *UpdateFlowMediaStreamInput) SetMediaStreamName(v string) *UpdateFlowMediaStreamInput {
	s.MediaStreamName = &v
	return s
}

// SetMediaStreamType sets the MediaStreamType field's value.
func (s *UpdateFlowMediaStreamInput) SetMediaStreamType(v string) *UpdateFlowMediaStreamInput {
	s.MediaStreamType = &v
	return s
}

// SetVideoFormat sets the VideoFormat field's value.
func (s *UpdateFlowMediaStreamInput) SetVideoFormat(v string) *UpdateFlowMediaStreamInput {
	s.VideoFormat = &v
	return s
}

// The result of a successful UpdateFlowMediaStream request.
type UpdateFlowMediaStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the media stream that you updated.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The media stream that you updated.
	MediaStream *MediaStream `locationName:"mediaStream" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowMediaStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowMediaStreamOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowMediaStreamOutput) SetFlowArn(v string) *UpdateFlowMediaStreamOutput {
	s.FlowArn = &v
	return s
}

// SetMediaStream sets the MediaStream field's value.
func (s *UpdateFlowMediaStreamOutput) SetMediaStream(v *MediaStream) *UpdateFlowMediaStreamOutput {
	s.MediaStream = v
	return s
}

// The result of a successful UpdateFlow request. Updates an existing flow.
type UpdateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *UpdateFlowOutput) SetFlow(v *Flow) *UpdateFlowOutput {
	s.Flow = v
	return s
}

// The updates that you want to make to an existing output of an existing flow.
type UpdateFlowOutputInput struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key). Allowable encryption types: static-key.
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based,
	// Zixi-based, and Fujitsu-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The media streams that are associated with the output, and the parameters
	// for those associations.
	MediaStreamOutputConfigurations []*MediaStreamOutputConfigurationRequest `locationName:"mediaStreamOutputConfigurations" type:"list"`

	// The minimum latency in milliseconds for SRT-based streams. In streams that
	// use the SRT protocol, this value that you set on your MediaConnect source
	// or output represents the minimal potential latency of that connection. The
	// latency of the stream is set to the highest number between the sender’s
	// minimum latency and the receiver’s minimum latency.
	MinLatency *int64 `locationName:"minLatency" type:"integer"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`

	// An indication of whether the output should transmit data or not. If you don't
	// specify the outputStatus field in your request, MediaConnect leaves the value
	// unchanged.
	OutputStatus *string `locationName:"outputStatus" type:"string" enum:"OutputStatus"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The remote ID for the Zixi-pull stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The IP address that the flow communicates with to initiate connection with
	// the sender.
	SenderIpAddress *string `locationName:"senderIpAddress" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}
	if s.OutputArn != nil && len(*s.OutputArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputArn", 1))
	}
	if s.MediaStreamOutputConfigurations != nil {
		for i, v := range s.MediaStreamOutputConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreamOutputConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *UpdateFlowOutputInput) SetCidrAllowList(v []*string) *UpdateFlowOutputInput {
	s.CidrAllowList = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowOutputInput) SetDescription(v string) *UpdateFlowOutputInput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UpdateFlowOutputInput) SetDestination(v string) *UpdateFlowOutputInput {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowOutputInput) SetEncryption(v *UpdateEncryption) *UpdateFlowOutputInput {
	s.Encryption = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputInput) SetFlowArn(v string) *UpdateFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowOutputInput) SetMaxLatency(v int64) *UpdateFlowOutputInput {
	s.MaxLatency = &v
	return s
}

// SetMediaStreamOutputConfigurations sets the MediaStreamOutputConfigurations field's value.
func (s *UpdateFlowOutputInput) SetMediaStreamOutputConfigurations(v []*MediaStreamOutputConfigurationRequest) *UpdateFlowOutputInput {
	s.MediaStreamOutputConfigurations = v
	return s
}

// SetMinLatency sets the MinLatency field's value.
func (s *UpdateFlowOutputInput) SetMinLatency(v int64) *UpdateFlowOutputInput {
	s.MinLatency = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *UpdateFlowOutputInput) SetOutputArn(v string) *UpdateFlowOutputInput {
	s.OutputArn = &v
	return s
}

// SetOutputStatus sets the OutputStatus field's value.
func (s *UpdateFlowOutputInput) SetOutputStatus(v string) *UpdateFlowOutputInput {
	s.OutputStatus = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateFlowOutputInput) SetPort(v int64) *UpdateFlowOutputInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowOutputInput) SetProtocol(v string) *UpdateFlowOutputInput {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *UpdateFlowOutputInput) SetRemoteId(v string) *UpdateFlowOutputInput {
	s.RemoteId = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *UpdateFlowOutputInput) SetSenderControlPort(v int64) *UpdateFlowOutputInput {
	s.SenderControlPort = &v
	return s
}

// SetSenderIpAddress sets the SenderIpAddress field's value.
func (s *UpdateFlowOutputInput) SetSenderIpAddress(v string) *UpdateFlowOutputInput {
	s.SenderIpAddress = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *UpdateFlowOutputInput) SetSmoothingLatency(v int64) *UpdateFlowOutputInput {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowOutputInput) SetStreamId(v string) *UpdateFlowOutputInput {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *UpdateFlowOutputInput) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *UpdateFlowOutputInput {
	s.VpcInterfaceAttachment = v
	return s
}

// The result of a successful UpdateFlowOutput request including the flow ARN
// and the updated output.
type UpdateFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the updated output.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The new settings of the output that you updated.
	Output *Output `locationName:"output" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputOutput) SetFlowArn(v string) *UpdateFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *UpdateFlowOutputOutput) SetOutput(v *Output) *UpdateFlowOutputOutput {
	s.Output = v
	return s
}

// The updates that you want to make to an existing source of an existing flow.
type UpdateFlowSourceInput struct {
	_ struct{} `type:"structure"`

	// The type of encryption used on the content ingested from this source. Allowable
	// encryption types: static-key.
	Decryption *UpdateEncryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The source configuration for cloud flows receiving a stream from a bridge.
	GatewayBridgeSource *UpdateGatewayBridgeSourceRequest `locationName:"gatewayBridgeSource" type:"structure"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based,
	// Zixi-based, and Fujitsu-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The size of the buffer (in milliseconds) to use to sync incoming source data.
	MaxSyncBuffer *int64 `locationName:"maxSyncBuffer" type:"integer"`

	// The media streams that are associated with the source, and the parameters
	// for those associations.
	MediaStreamSourceConfigurations []*MediaStreamSourceConfigurationRequest `locationName:"mediaStreamSourceConfigurations" type:"list"`

	// The minimum latency in milliseconds for SRT-based streams. In streams that
	// use the SRT protocol, this value that you set on your MediaConnect source
	// or output represents the minimal potential latency of that connection. The
	// latency of the stream is set to the highest number between the sender’s
	// minimum latency and the receiver’s minimum latency.
	MinLatency *int64 `locationName:"minLatency" type:"integer"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The port that the flow uses to send outbound requests to initiate connection
	// with the sender.
	SenderControlPort *int64 `locationName:"senderControlPort" type:"integer"`

	// The IP address that the flow communicates with to initiate connection with
	// the sender.
	SenderIpAddress *string `locationName:"senderIpAddress" type:"string"`

	// SourceArn is a required field
	SourceArn *string `location:"uri" locationName:"sourceArn" type:"string" required:"true"`

	// Source IP or domain name for SRT-caller protocol.
	SourceListenerAddress *string `locationName:"sourceListenerAddress" type:"string"`

	// Source port for SRT-caller protocol.
	SourceListenerPort *int64 `locationName:"sourceListenerPort" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi and SRT caller-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface to use for this source.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowSourceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}
	if s.MediaStreamSourceConfigurations != nil {
		for i, v := range s.MediaStreamSourceConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaStreamSourceConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *UpdateFlowSourceInput) SetDecryption(v *UpdateEncryption) *UpdateFlowSourceInput {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowSourceInput) SetDescription(v string) *UpdateFlowSourceInput {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowSourceInput) SetEntitlementArn(v string) *UpdateFlowSourceInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceInput) SetFlowArn(v string) *UpdateFlowSourceInput {
	s.FlowArn = &v
	return s
}

// SetGatewayBridgeSource sets the GatewayBridgeSource field's value.
func (s *UpdateFlowSourceInput) SetGatewayBridgeSource(v *UpdateGatewayBridgeSourceRequest) *UpdateFlowSourceInput {
	s.GatewayBridgeSource = v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *UpdateFlowSourceInput) SetIngestPort(v int64) *UpdateFlowSourceInput {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *UpdateFlowSourceInput) SetMaxBitrate(v int64) *UpdateFlowSourceInput {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowSourceInput) SetMaxLatency(v int64) *UpdateFlowSourceInput {
	s.MaxLatency = &v
	return s
}

// SetMaxSyncBuffer sets the MaxSyncBuffer field's value.
func (s *UpdateFlowSourceInput) SetMaxSyncBuffer(v int64) *UpdateFlowSourceInput {
	s.MaxSyncBuffer = &v
	return s
}

// SetMediaStreamSourceConfigurations sets the MediaStreamSourceConfigurations field's value.
func (s *UpdateFlowSourceInput) SetMediaStreamSourceConfigurations(v []*MediaStreamSourceConfigurationRequest) *UpdateFlowSourceInput {
	s.MediaStreamSourceConfigurations = v
	return s
}

// SetMinLatency sets the MinLatency field's value.
func (s *UpdateFlowSourceInput) SetMinLatency(v int64) *UpdateFlowSourceInput {
	s.MinLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowSourceInput) SetProtocol(v string) *UpdateFlowSourceInput {
	s.Protocol = &v
	return s
}

// SetSenderControlPort sets the SenderControlPort field's value.
func (s *UpdateFlowSourceInput) SetSenderControlPort(v int64) *UpdateFlowSourceInput {
	s.SenderControlPort = &v
	return s
}

// SetSenderIpAddress sets the SenderIpAddress field's value.
func (s *UpdateFlowSourceInput) SetSenderIpAddress(v string) *UpdateFlowSourceInput {
	s.SenderIpAddress = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *UpdateFlowSourceInput) SetSourceArn(v string) *UpdateFlowSourceInput {
	s.SourceArn = &v
	return s
}

// SetSourceListenerAddress sets the SourceListenerAddress field's value.
func (s *UpdateFlowSourceInput) SetSourceListenerAddress(v string) *UpdateFlowSourceInput {
	s.SourceListenerAddress = &v
	return s
}

// SetSourceListenerPort sets the SourceListenerPort field's value.
func (s *UpdateFlowSourceInput) SetSourceListenerPort(v int64) *UpdateFlowSourceInput {
	s.SourceListenerPort = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowSourceInput) SetStreamId(v string) *UpdateFlowSourceInput {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *UpdateFlowSourceInput) SetVpcInterfaceName(v string) *UpdateFlowSourceInput {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *UpdateFlowSourceInput) SetWhitelistCidr(v string) *UpdateFlowSourceInput {
	s.WhitelistCidr = &v
	return s
}

// The result of a successful UpdateFlowSource request. The response includes
// the ARN of the flow that was updated and the updated source configuration.
type UpdateFlowSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you want to update.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The settings for the source of the flow.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowSourceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceOutput) SetFlowArn(v string) *UpdateFlowSourceOutput {
	s.FlowArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateFlowSourceOutput) SetSource(v *Source) *UpdateFlowSourceOutput {
	s.Source = v
	return s
}

// The source configuration for cloud flows receiving a stream from a bridge.
type UpdateGatewayBridgeSourceRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the bridge feeding this flow.
	BridgeArn *string `locationName:"bridgeArn" type:"string"`

	// The name of the VPC interface attachment to use for this bridge source.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayBridgeSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayBridgeSourceRequest) GoString() string {
	return s.String()
}

// SetBridgeArn sets the BridgeArn field's value.
func (s *UpdateGatewayBridgeSourceRequest) SetBridgeArn(v string) *UpdateGatewayBridgeSourceRequest {
	s.BridgeArn = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *UpdateGatewayBridgeSourceRequest) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *UpdateGatewayBridgeSourceRequest {
	s.VpcInterfaceAttachment = v
	return s
}

// The state update that you want to make to an existing gateway instance.
type UpdateGatewayInstanceInput struct {
	_ struct{} `type:"structure"`

	// The availability of the instance to host new bridges. The bridgePlacement
	// property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can
	// be deployed to this instance. If it is AVAILABLE, new bridges can be added
	// to this instance.
	BridgePlacement *string `locationName:"bridgePlacement" type:"string" enum:"BridgePlacement"`

	// GatewayInstanceArn is a required field
	GatewayInstanceArn *string `location:"uri" locationName:"gatewayInstanceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInstanceInput"}
	if s.GatewayInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayInstanceArn"))
	}
	if s.GatewayInstanceArn != nil && len(*s.GatewayInstanceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayInstanceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBridgePlacement sets the BridgePlacement field's value.
func (s *UpdateGatewayInstanceInput) SetBridgePlacement(v string) *UpdateGatewayInstanceInput {
	s.BridgePlacement = &v
	return s
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *UpdateGatewayInstanceInput) SetGatewayInstanceArn(v string) *UpdateGatewayInstanceInput {
	s.GatewayInstanceArn = &v
	return s
}

// The result of a successful UpdateGatewayInstance request.
type UpdateGatewayInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The availability of the instance to host new bridges. The bridgePlacement
	// property can be LOCKED or AVAILABLE. If it is LOCKED, no new bridges can
	// be deployed to this instance. If it is AVAILABLE, new bridges can be added
	// to this instance.
	BridgePlacement *string `locationName:"bridgePlacement" type:"string" enum:"BridgePlacement"`

	// The Amazon Resource Name (ARN) of the instance.
	GatewayInstanceArn *string `locationName:"gatewayInstanceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayInstanceOutput) GoString() string {
	return s.String()
}

// SetBridgePlacement sets the BridgePlacement field's value.
func (s *UpdateGatewayInstanceOutput) SetBridgePlacement(v string) *UpdateGatewayInstanceOutput {
	s.BridgePlacement = &v
	return s
}

// SetGatewayInstanceArn sets the GatewayInstanceArn field's value.
func (s *UpdateGatewayInstanceOutput) SetGatewayInstanceArn(v string) *UpdateGatewayInstanceOutput {
	s.GatewayInstanceArn = &v
	return s
}

type UpdateIngressGatewayBridgeRequest struct {
	_ struct{} `type:"structure"`

	// The maximum expected bitrate (in bps).
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum number of expected outputs.
	MaxOutputs *int64 `locationName:"maxOutputs" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressGatewayBridgeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIngressGatewayBridgeRequest) GoString() string {
	return s.String()
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *UpdateIngressGatewayBridgeRequest) SetMaxBitrate(v int64) *UpdateIngressGatewayBridgeRequest {
	s.MaxBitrate = &v
	return s
}

// SetMaxOutputs sets the MaxOutputs field's value.
func (s *UpdateIngressGatewayBridgeRequest) SetMaxOutputs(v int64) *UpdateIngressGatewayBridgeRequest {
	s.MaxOutputs = &v
	return s
}

// Update maintenance setting for a flow
type UpdateMaintenance struct {
	_ struct{} `type:"structure"`

	// A day of a week when the maintenance will happen. use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
	MaintenanceDay *string `locationName:"maintenanceDay" type:"string" enum:"MaintenanceDay"`

	// A scheduled date in ISO UTC format when the maintenance will happen. Use
	// YYYY-MM-DD format. Example: 2021-01-30.
	MaintenanceScheduledDate *string `locationName:"maintenanceScheduledDate" type:"string"`

	// UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes
	// must be 00. Example: 13:00. The default value is 02:00.
	MaintenanceStartHour *string `locationName:"maintenanceStartHour" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMaintenance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMaintenance) GoString() string {
	return s.String()
}

// SetMaintenanceDay sets the MaintenanceDay field's value.
func (s *UpdateMaintenance) SetMaintenanceDay(v string) *UpdateMaintenance {
	s.MaintenanceDay = &v
	return s
}

// SetMaintenanceScheduledDate sets the MaintenanceScheduledDate field's value.
func (s *UpdateMaintenance) SetMaintenanceScheduledDate(v string) *UpdateMaintenance {
	s.MaintenanceScheduledDate = &v
	return s
}

// SetMaintenanceStartHour sets the MaintenanceStartHour field's value.
func (s *UpdateMaintenance) SetMaintenanceStartHour(v string) *UpdateMaintenance {
	s.MaintenanceStartHour = &v
	return s
}

// The settings for a VPC Source.
type VpcInterface struct {
	_ struct{} `type:"structure"`

	// Immutable and has to be a unique against other VpcInterfaces in this Flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// IDs of the network interfaces created in customer's account by MediaConnect.
	//
	// NetworkInterfaceIds is a required field
	NetworkInterfaceIds []*string `locationName:"networkInterfaceIds" type:"list" required:"true"`

	// The type of network interface.
	//
	// NetworkInterfaceType is a required field
	NetworkInterfaceType *string `locationName:"networkInterfaceType" type:"string" required:"true" enum:"NetworkInterfaceType"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterface) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *VpcInterface) SetName(v string) *VpcInterface {
	s.Name = &v
	return s
}

// SetNetworkInterfaceIds sets the NetworkInterfaceIds field's value.
func (s *VpcInterface) SetNetworkInterfaceIds(v []*string) *VpcInterface {
	s.NetworkInterfaceIds = v
	return s
}

// SetNetworkInterfaceType sets the NetworkInterfaceType field's value.
func (s *VpcInterface) SetNetworkInterfaceType(v string) *VpcInterface {
	s.NetworkInterfaceType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *VpcInterface) SetRoleArn(v string) *VpcInterface {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcInterface) SetSecurityGroupIds(v []*string) *VpcInterface {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *VpcInterface) SetSubnetId(v string) *VpcInterface {
	s.SubnetId = &v
	return s
}

// The settings for attaching a VPC interface to an resource.
type VpcInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The name of the VPC interface to use for this resource.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterfaceAttachment) GoString() string {
	return s.String()
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *VpcInterfaceAttachment) SetVpcInterfaceName(v string) *VpcInterfaceAttachment {
	s.VpcInterfaceName = &v
	return s
}

// Desired VPC Interface for a Flow
type VpcInterfaceRequest struct {
	_ struct{} `type:"structure"`

	// The name of the VPC Interface. This value must be unique within the current
	// flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of network interface. If this value is not included in the request,
	// MediaConnect uses ENA as the networkInterfaceType.
	NetworkInterfaceType *string `locationName:"networkInterfaceType" type:"string" enum:"NetworkInterfaceType"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterfaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcInterfaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcInterfaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcInterfaceRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VpcInterfaceRequest) SetName(v string) *VpcInterfaceRequest {
	s.Name = &v
	return s
}

// SetNetworkInterfaceType sets the NetworkInterfaceType field's value.
func (s *VpcInterfaceRequest) SetNetworkInterfaceType(v string) *VpcInterfaceRequest {
	s.NetworkInterfaceType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *VpcInterfaceRequest) SetRoleArn(v string) *VpcInterfaceRequest {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcInterfaceRequest) SetSecurityGroupIds(v []*string) *VpcInterfaceRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *VpcInterfaceRequest) SetSubnetId(v string) *VpcInterfaceRequest {
	s.SubnetId = &v
	return s
}

const (
	// AlgorithmAes128 is a Algorithm enum value
	AlgorithmAes128 = "aes128"

	// AlgorithmAes192 is a Algorithm enum value
	AlgorithmAes192 = "aes192"

	// AlgorithmAes256 is a Algorithm enum value
	AlgorithmAes256 = "aes256"
)

// Algorithm_Values returns all elements of the Algorithm enum
func Algorithm_Values() []string {
	return []string{
		AlgorithmAes128,
		AlgorithmAes192,
		AlgorithmAes256,
	}
}

const (
	// BridgePlacementAvailable is a BridgePlacement enum value
	BridgePlacementAvailable = "AVAILABLE"

	// BridgePlacementLocked is a BridgePlacement enum value
	BridgePlacementLocked = "LOCKED"
)

// BridgePlacement_Values returns all elements of the BridgePlacement enum
func BridgePlacement_Values() []string {
	return []string{
		BridgePlacementAvailable,
		BridgePlacementLocked,
	}
}

const (
	// BridgeStateCreating is a BridgeState enum value
	BridgeStateCreating = "CREATING"

	// BridgeStateStandby is a BridgeState enum value
	BridgeStateStandby = "STANDBY"

	// BridgeStateStarting is a BridgeState enum value
	BridgeStateStarting = "STARTING"

	// BridgeStateDeploying is a BridgeState enum value
	BridgeStateDeploying = "DEPLOYING"

	// BridgeStateActive is a BridgeState enum value
	BridgeStateActive = "ACTIVE"

	// BridgeStateStopping is a BridgeState enum value
	BridgeStateStopping = "STOPPING"

	// BridgeStateDeleting is a BridgeState enum value
	BridgeStateDeleting = "DELETING"

	// BridgeStateDeleted is a BridgeState enum value
	BridgeStateDeleted = "DELETED"

	// BridgeStateStartFailed is a BridgeState enum value
	BridgeStateStartFailed = "START_FAILED"

	// BridgeStateStartPending is a BridgeState enum value
	BridgeStateStartPending = "START_PENDING"

	// BridgeStateStopFailed is a BridgeState enum value
	BridgeStateStopFailed = "STOP_FAILED"

	// BridgeStateUpdating is a BridgeState enum value
	BridgeStateUpdating = "UPDATING"
)

// BridgeState_Values returns all elements of the BridgeState enum
func BridgeState_Values() []string {
	return []string{
		BridgeStateCreating,
		BridgeStateStandby,
		BridgeStateStarting,
		BridgeStateDeploying,
		BridgeStateActive,
		BridgeStateStopping,
		BridgeStateDeleting,
		BridgeStateDeleted,
		BridgeStateStartFailed,
		BridgeStateStartPending,
		BridgeStateStopFailed,
		BridgeStateUpdating,
	}
}

const (
	// ColorimetryBt601 is a Colorimetry enum value
	ColorimetryBt601 = "BT601"

	// ColorimetryBt709 is a Colorimetry enum value
	ColorimetryBt709 = "BT709"

	// ColorimetryBt2020 is a Colorimetry enum value
	ColorimetryBt2020 = "BT2020"

	// ColorimetryBt2100 is a Colorimetry enum value
	ColorimetryBt2100 = "BT2100"

	// ColorimetrySt20651 is a Colorimetry enum value
	ColorimetrySt20651 = "ST2065-1"

	// ColorimetrySt20653 is a Colorimetry enum value
	ColorimetrySt20653 = "ST2065-3"

	// ColorimetryXyz is a Colorimetry enum value
	ColorimetryXyz = "XYZ"
)

// Colorimetry_Values returns all elements of the Colorimetry enum
func Colorimetry_Values() []string {
	return []string{
		ColorimetryBt601,
		ColorimetryBt709,
		ColorimetryBt2020,
		ColorimetryBt2100,
		ColorimetrySt20651,
		ColorimetrySt20653,
		ColorimetryXyz,
	}
}

const (
	// ConnectionStatusConnected is a ConnectionStatus enum value
	ConnectionStatusConnected = "CONNECTED"

	// ConnectionStatusDisconnected is a ConnectionStatus enum value
	ConnectionStatusDisconnected = "DISCONNECTED"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusConnected,
		ConnectionStatusDisconnected,
	}
}

const (
	// DesiredStateActive is a DesiredState enum value
	DesiredStateActive = "ACTIVE"

	// DesiredStateStandby is a DesiredState enum value
	DesiredStateStandby = "STANDBY"

	// DesiredStateDeleted is a DesiredState enum value
	DesiredStateDeleted = "DELETED"
)

// DesiredState_Values returns all elements of the DesiredState enum
func DesiredState_Values() []string {
	return []string{
		DesiredStateActive,
		DesiredStateStandby,
		DesiredStateDeleted,
	}
}

const (
	// DurationUnitsMonths is a DurationUnits enum value
	DurationUnitsMonths = "MONTHS"
)

// DurationUnits_Values returns all elements of the DurationUnits enum
func DurationUnits_Values() []string {
	return []string{
		DurationUnitsMonths,
	}
}

const (
	// EncoderProfileMain is a EncoderProfile enum value
	EncoderProfileMain = "main"

	// EncoderProfileHigh is a EncoderProfile enum value
	EncoderProfileHigh = "high"
)

// EncoderProfile_Values returns all elements of the EncoderProfile enum
func EncoderProfile_Values() []string {
	return []string{
		EncoderProfileMain,
		EncoderProfileHigh,
	}
}

const (
	// EncodingNameJxsv is a EncodingName enum value
	EncodingNameJxsv = "jxsv"

	// EncodingNameRaw is a EncodingName enum value
	EncodingNameRaw = "raw"

	// EncodingNameSmpte291 is a EncodingName enum value
	EncodingNameSmpte291 = "smpte291"

	// EncodingNamePcm is a EncodingName enum value
	EncodingNamePcm = "pcm"
)

// EncodingName_Values returns all elements of the EncodingName enum
func EncodingName_Values() []string {
	return []string{
		EncodingNameJxsv,
		EncodingNameRaw,
		EncodingNameSmpte291,
		EncodingNamePcm,
	}
}

const (
	// EntitlementStatusEnabled is a EntitlementStatus enum value
	EntitlementStatusEnabled = "ENABLED"

	// EntitlementStatusDisabled is a EntitlementStatus enum value
	EntitlementStatusDisabled = "DISABLED"
)

// EntitlementStatus_Values returns all elements of the EntitlementStatus enum
func EntitlementStatus_Values() []string {
	return []string{
		EntitlementStatusEnabled,
		EntitlementStatusDisabled,
	}
}

const (
	// FailoverModeMerge is a FailoverMode enum value
	FailoverModeMerge = "MERGE"

	// FailoverModeFailover is a FailoverMode enum value
	FailoverModeFailover = "FAILOVER"
)

// FailoverMode_Values returns all elements of the FailoverMode enum
func FailoverMode_Values() []string {
	return []string{
		FailoverModeMerge,
		FailoverModeFailover,
	}
}

const (
	// GatewayStateCreating is a GatewayState enum value
	GatewayStateCreating = "CREATING"

	// GatewayStateActive is a GatewayState enum value
	GatewayStateActive = "ACTIVE"

	// GatewayStateUpdating is a GatewayState enum value
	GatewayStateUpdating = "UPDATING"

	// GatewayStateError is a GatewayState enum value
	GatewayStateError = "ERROR"

	// GatewayStateDeleting is a GatewayState enum value
	GatewayStateDeleting = "DELETING"

	// GatewayStateDeleted is a GatewayState enum value
	GatewayStateDeleted = "DELETED"
)

// GatewayState_Values returns all elements of the GatewayState enum
func GatewayState_Values() []string {
	return []string{
		GatewayStateCreating,
		GatewayStateActive,
		GatewayStateUpdating,
		GatewayStateError,
		GatewayStateDeleting,
		GatewayStateDeleted,
	}
}

const (
	// InstanceStateRegistering is a InstanceState enum value
	InstanceStateRegistering = "REGISTERING"

	// InstanceStateActive is a InstanceState enum value
	InstanceStateActive = "ACTIVE"

	// InstanceStateDeregistering is a InstanceState enum value
	InstanceStateDeregistering = "DEREGISTERING"

	// InstanceStateDeregistered is a InstanceState enum value
	InstanceStateDeregistered = "DEREGISTERED"

	// InstanceStateRegistrationError is a InstanceState enum value
	InstanceStateRegistrationError = "REGISTRATION_ERROR"

	// InstanceStateDeregistrationError is a InstanceState enum value
	InstanceStateDeregistrationError = "DEREGISTRATION_ERROR"
)

// InstanceState_Values returns all elements of the InstanceState enum
func InstanceState_Values() []string {
	return []string{
		InstanceStateRegistering,
		InstanceStateActive,
		InstanceStateDeregistering,
		InstanceStateDeregistered,
		InstanceStateRegistrationError,
		InstanceStateDeregistrationError,
	}
}

const (
	// KeyTypeSpeke is a KeyType enum value
	KeyTypeSpeke = "speke"

	// KeyTypeStaticKey is a KeyType enum value
	KeyTypeStaticKey = "static-key"

	// KeyTypeSrtPassword is a KeyType enum value
	KeyTypeSrtPassword = "srt-password"
)

// KeyType_Values returns all elements of the KeyType enum
func KeyType_Values() []string {
	return []string{
		KeyTypeSpeke,
		KeyTypeStaticKey,
		KeyTypeSrtPassword,
	}
}

const (
	// MaintenanceDayMonday is a MaintenanceDay enum value
	MaintenanceDayMonday = "Monday"

	// MaintenanceDayTuesday is a MaintenanceDay enum value
	MaintenanceDayTuesday = "Tuesday"

	// MaintenanceDayWednesday is a MaintenanceDay enum value
	MaintenanceDayWednesday = "Wednesday"

	// MaintenanceDayThursday is a MaintenanceDay enum value
	MaintenanceDayThursday = "Thursday"

	// MaintenanceDayFriday is a MaintenanceDay enum value
	MaintenanceDayFriday = "Friday"

	// MaintenanceDaySaturday is a MaintenanceDay enum value
	MaintenanceDaySaturday = "Saturday"

	// MaintenanceDaySunday is a MaintenanceDay enum value
	MaintenanceDaySunday = "Sunday"
)

// MaintenanceDay_Values returns all elements of the MaintenanceDay enum
func MaintenanceDay_Values() []string {
	return []string{
		MaintenanceDayMonday,
		MaintenanceDayTuesday,
		MaintenanceDayWednesday,
		MaintenanceDayThursday,
		MaintenanceDayFriday,
		MaintenanceDaySaturday,
		MaintenanceDaySunday,
	}
}

const (
	// MediaStreamTypeVideo is a MediaStreamType enum value
	MediaStreamTypeVideo = "video"

	// MediaStreamTypeAudio is a MediaStreamType enum value
	MediaStreamTypeAudio = "audio"

	// MediaStreamTypeAncillaryData is a MediaStreamType enum value
	MediaStreamTypeAncillaryData = "ancillary-data"
)

// MediaStreamType_Values returns all elements of the MediaStreamType enum
func MediaStreamType_Values() []string {
	return []string{
		MediaStreamTypeVideo,
		MediaStreamTypeAudio,
		MediaStreamTypeAncillaryData,
	}
}

const (
	// NetworkInterfaceTypeEna is a NetworkInterfaceType enum value
	NetworkInterfaceTypeEna = "ena"

	// NetworkInterfaceTypeEfa is a NetworkInterfaceType enum value
	NetworkInterfaceTypeEfa = "efa"
)

// NetworkInterfaceType_Values returns all elements of the NetworkInterfaceType enum
func NetworkInterfaceType_Values() []string {
	return []string{
		NetworkInterfaceTypeEna,
		NetworkInterfaceTypeEfa,
	}
}

const (
	// OutputStatusEnabled is a OutputStatus enum value
	OutputStatusEnabled = "ENABLED"

	// OutputStatusDisabled is a OutputStatus enum value
	OutputStatusDisabled = "DISABLED"
)

// OutputStatus_Values returns all elements of the OutputStatus enum
func OutputStatus_Values() []string {
	return []string{
		OutputStatusEnabled,
		OutputStatusDisabled,
	}
}

const (
	// PriceUnitsHourly is a PriceUnits enum value
	PriceUnitsHourly = "HOURLY"
)

// PriceUnits_Values returns all elements of the PriceUnits enum
func PriceUnits_Values() []string {
	return []string{
		PriceUnitsHourly,
	}
}

const (
	// ProtocolZixiPush is a Protocol enum value
	ProtocolZixiPush = "zixi-push"

	// ProtocolRtpFec is a Protocol enum value
	ProtocolRtpFec = "rtp-fec"

	// ProtocolRtp is a Protocol enum value
	ProtocolRtp = "rtp"

	// ProtocolZixiPull is a Protocol enum value
	ProtocolZixiPull = "zixi-pull"

	// ProtocolRist is a Protocol enum value
	ProtocolRist = "rist"

	// ProtocolSt2110Jpegxs is a Protocol enum value
	ProtocolSt2110Jpegxs = "st2110-jpegxs"

	// ProtocolCdi is a Protocol enum value
	ProtocolCdi = "cdi"

	// ProtocolSrtListener is a Protocol enum value
	ProtocolSrtListener = "srt-listener"

	// ProtocolSrtCaller is a Protocol enum value
	ProtocolSrtCaller = "srt-caller"

	// ProtocolFujitsuQos is a Protocol enum value
	ProtocolFujitsuQos = "fujitsu-qos"

	// ProtocolUdp is a Protocol enum value
	ProtocolUdp = "udp"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolZixiPush,
		ProtocolRtpFec,
		ProtocolRtp,
		ProtocolZixiPull,
		ProtocolRist,
		ProtocolSt2110Jpegxs,
		ProtocolCdi,
		ProtocolSrtListener,
		ProtocolSrtCaller,
		ProtocolFujitsuQos,
		ProtocolUdp,
	}
}

const (
	// RangeNarrow is a Range enum value
	RangeNarrow = "NARROW"

	// RangeFull is a Range enum value
	RangeFull = "FULL"

	// RangeFullprotect is a Range enum value
	RangeFullprotect = "FULLPROTECT"
)

// Range_Values returns all elements of the Range enum
func Range_Values() []string {
	return []string{
		RangeNarrow,
		RangeFull,
		RangeFullprotect,
	}
}

const (
	// ReservationStateActive is a ReservationState enum value
	ReservationStateActive = "ACTIVE"

	// ReservationStateExpired is a ReservationState enum value
	ReservationStateExpired = "EXPIRED"

	// ReservationStateProcessing is a ReservationState enum value
	ReservationStateProcessing = "PROCESSING"

	// ReservationStateCanceled is a ReservationState enum value
	ReservationStateCanceled = "CANCELED"
)

// ReservationState_Values returns all elements of the ReservationState enum
func ReservationState_Values() []string {
	return []string{
		ReservationStateActive,
		ReservationStateExpired,
		ReservationStateProcessing,
		ReservationStateCanceled,
	}
}

const (
	// ResourceTypeMbpsOutboundBandwidth is a ResourceType enum value
	ResourceTypeMbpsOutboundBandwidth = "Mbps_Outbound_Bandwidth"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeMbpsOutboundBandwidth,
	}
}

const (
	// ScanModeProgressive is a ScanMode enum value
	ScanModeProgressive = "progressive"

	// ScanModeInterlace is a ScanMode enum value
	ScanModeInterlace = "interlace"

	// ScanModeProgressiveSegmentedFrame is a ScanMode enum value
	ScanModeProgressiveSegmentedFrame = "progressive-segmented-frame"
)

// ScanMode_Values returns all elements of the ScanMode enum
func ScanMode_Values() []string {
	return []string{
		ScanModeProgressive,
		ScanModeInterlace,
		ScanModeProgressiveSegmentedFrame,
	}
}

const (
	// SourceTypeOwned is a SourceType enum value
	SourceTypeOwned = "OWNED"

	// SourceTypeEntitled is a SourceType enum value
	SourceTypeEntitled = "ENTITLED"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeOwned,
		SourceTypeEntitled,
	}
}

const (
	// StateEnabled is a State enum value
	StateEnabled = "ENABLED"

	// StateDisabled is a State enum value
	StateDisabled = "DISABLED"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateEnabled,
		StateDisabled,
	}
}

const (
	// StatusStandby is a Status enum value
	StatusStandby = "STANDBY"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"

	// StatusStarting is a Status enum value
	StatusStarting = "STARTING"

	// StatusStopping is a Status enum value
	StatusStopping = "STOPPING"

	// StatusError is a Status enum value
	StatusError = "ERROR"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusStandby,
		StatusActive,
		StatusUpdating,
		StatusDeleting,
		StatusStarting,
		StatusStopping,
		StatusError,
	}
}

const (
	// TcsSdr is a Tcs enum value
	TcsSdr = "SDR"

	// TcsPq is a Tcs enum value
	TcsPq = "PQ"

	// TcsHlg is a Tcs enum value
	TcsHlg = "HLG"

	// TcsLinear is a Tcs enum value
	TcsLinear = "LINEAR"

	// TcsBt2100linpq is a Tcs enum value
	TcsBt2100linpq = "BT2100LINPQ"

	// TcsBt2100linhlg is a Tcs enum value
	TcsBt2100linhlg = "BT2100LINHLG"

	// TcsSt20651 is a Tcs enum value
	TcsSt20651 = "ST2065-1"

	// TcsSt4281 is a Tcs enum value
	TcsSt4281 = "ST428-1"

	// TcsDensity is a Tcs enum value
	TcsDensity = "DENSITY"
)

// Tcs_Values returns all elements of the Tcs enum
func Tcs_Values() []string {
	return []string{
		TcsSdr,
		TcsPq,
		TcsHlg,
		TcsLinear,
		TcsBt2100linpq,
		TcsBt2100linhlg,
		TcsSt20651,
		TcsSt4281,
		TcsDensity,
	}
}
