// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeAccessKeysCommon = "DescribeAccessKeys"

// DescribeAccessKeysCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAccessKeysCommon operation. The "output" return
// value will be populated with the DescribeAccessKeysCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAccessKeysCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAccessKeysCommon Send returns without error.
//
// See DescribeAccessKeysCommon for more information on using the DescribeAccessKeysCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeAccessKeysCommonRequest method.
//    req, resp := client.DescribeAccessKeysCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeAccessKeysCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeAccessKeysCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAccessKeysCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeAccessKeysCommon for usage and error information.
func (c *ROCKETMQ) DescribeAccessKeysCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeAccessKeysCommonRequest(input)
	return out, req.Send()
}

// DescribeAccessKeysCommonWithContext is the same as DescribeAccessKeysCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessKeysCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeAccessKeysCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeAccessKeysCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccessKeys = "DescribeAccessKeys"

// DescribeAccessKeysRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAccessKeys operation. The "output" return
// value will be populated with the DescribeAccessKeysCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAccessKeysCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAccessKeysCommon Send returns without error.
//
// See DescribeAccessKeys for more information on using the DescribeAccessKeys
// API call, and error handling.
//
//    // Example sending a request using the DescribeAccessKeysRequest method.
//    req, resp := client.DescribeAccessKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeAccessKeysRequest(input *DescribeAccessKeysInput) (req *request.Request, output *DescribeAccessKeysOutput) {
	op := &request.Operation{
		Name:       opDescribeAccessKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccessKeysInput{}
	}

	output = &DescribeAccessKeysOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAccessKeys API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeAccessKeys for usage and error information.
func (c *ROCKETMQ) DescribeAccessKeys(input *DescribeAccessKeysInput) (*DescribeAccessKeysOutput, error) {
	req, out := c.DescribeAccessKeysRequest(input)
	return out, req.Send()
}

// DescribeAccessKeysWithContext is the same as DescribeAccessKeys with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeAccessKeysWithContext(ctx volcengine.Context, input *DescribeAccessKeysInput, opts ...request.Option) (*DescribeAccessKeysOutput, error) {
	req, out := c.DescribeAccessKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessKeysInfoForDescribeAccessKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	AclConfigJson *string `type:"string" json:",omitempty"`

	Actived *bool `type:"boolean" json:",omitempty"`

	AllAuthority *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AccessKeysInfoForDescribeAccessKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeysInfoForDescribeAccessKeysOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetAccessKey(v string) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.AccessKey = &v
	return s
}

// SetAclConfigJson sets the AclConfigJson field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetAclConfigJson(v string) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.AclConfigJson = &v
	return s
}

// SetActived sets the Actived field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetActived(v bool) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.Actived = &v
	return s
}

// SetAllAuthority sets the AllAuthority field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetAllAuthority(v string) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.AllAuthority = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetCreateTime(v string) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AccessKeysInfoForDescribeAccessKeysOutput) SetDescription(v string) *AccessKeysInfoForDescribeAccessKeysOutput {
	s.Description = &v
	return s
}

type DescribeAccessKeysInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeAccessKeysInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccessKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessKeysInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *DescribeAccessKeysInput) SetAccessKey(v string) *DescribeAccessKeysInput {
	s.AccessKey = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeAccessKeysInput) SetInstanceId(v string) *DescribeAccessKeysInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAccessKeysInput) SetPageNumber(v int32) *DescribeAccessKeysInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAccessKeysInput) SetPageSize(v int32) *DescribeAccessKeysInput {
	s.PageSize = &v
	return s
}

type DescribeAccessKeysOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AccessKeysInfo []*AccessKeysInfoForDescribeAccessKeysOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeAccessKeysOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccessKeysOutput) GoString() string {
	return s.String()
}

// SetAccessKeysInfo sets the AccessKeysInfo field's value.
func (s *DescribeAccessKeysOutput) SetAccessKeysInfo(v []*AccessKeysInfoForDescribeAccessKeysOutput) *DescribeAccessKeysOutput {
	s.AccessKeysInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeAccessKeysOutput) SetTotal(v int32) *DescribeAccessKeysOutput {
	s.Total = &v
	return s
}
