// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rabbitmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribePluginsCommon = "DescribePlugins"

// DescribePluginsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribePluginsCommon operation. The "output" return
// value will be populated with the DescribePluginsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribePluginsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribePluginsCommon Send returns without error.
//
// See DescribePluginsCommon for more information on using the DescribePluginsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribePluginsCommonRequest method.
//    req, resp := client.DescribePluginsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RABBITMQ) DescribePluginsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribePluginsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribePluginsCommon API operation for RABBITMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RABBITMQ's
// API operation DescribePluginsCommon for usage and error information.
func (c *RABBITMQ) DescribePluginsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribePluginsCommonRequest(input)
	return out, req.Send()
}

// DescribePluginsCommonWithContext is the same as DescribePluginsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePluginsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RABBITMQ) DescribePluginsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribePluginsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlugins = "DescribePlugins"

// DescribePluginsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribePlugins operation. The "output" return
// value will be populated with the DescribePluginsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribePluginsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribePluginsCommon Send returns without error.
//
// See DescribePlugins for more information on using the DescribePlugins
// API call, and error handling.
//
//    // Example sending a request using the DescribePluginsRequest method.
//    req, resp := client.DescribePluginsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RABBITMQ) DescribePluginsRequest(input *DescribePluginsInput) (req *request.Request, output *DescribePluginsOutput) {
	op := &request.Operation{
		Name:       opDescribePlugins,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePluginsInput{}
	}

	output = &DescribePluginsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribePlugins API operation for RABBITMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RABBITMQ's
// API operation DescribePlugins for usage and error information.
func (c *RABBITMQ) DescribePlugins(input *DescribePluginsInput) (*DescribePluginsOutput, error) {
	req, out := c.DescribePluginsRequest(input)
	return out, req.Send()
}

// DescribePluginsWithContext is the same as DescribePlugins with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlugins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RABBITMQ) DescribePluginsWithContext(ctx volcengine.Context, input *DescribePluginsInput, opts ...request.Option) (*DescribePluginsOutput, error) {
	req, out := c.DescribePluginsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribePluginsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribePluginsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePluginsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePluginsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePluginsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribePluginsInput) SetInstanceId(v string) *DescribePluginsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribePluginsInput) SetPageNumber(v int32) *DescribePluginsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribePluginsInput) SetPageSize(v int32) *DescribePluginsInput {
	s.PageSize = &v
	return s
}

type DescribePluginsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	PluginsInfo []*PluginsInfoForDescribePluginsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribePluginsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePluginsOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribePluginsOutput) SetInstanceId(v string) *DescribePluginsOutput {
	s.InstanceId = &v
	return s
}

// SetPluginsInfo sets the PluginsInfo field's value.
func (s *DescribePluginsOutput) SetPluginsInfo(v []*PluginsInfoForDescribePluginsOutput) *DescribePluginsOutput {
	s.PluginsInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribePluginsOutput) SetTotal(v int32) *DescribePluginsOutput {
	s.Total = &v
	return s
}

type PluginsInfoForDescribePluginsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisablePrompt *string `type:"string" json:",omitempty"`

	EnablePrompt *string `type:"string" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	NeedRebootOnChange *bool `type:"boolean" json:",omitempty"`

	PluginName *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Version *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PluginsInfoForDescribePluginsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PluginsInfoForDescribePluginsOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetDescription(v string) *PluginsInfoForDescribePluginsOutput {
	s.Description = &v
	return s
}

// SetDisablePrompt sets the DisablePrompt field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetDisablePrompt(v string) *PluginsInfoForDescribePluginsOutput {
	s.DisablePrompt = &v
	return s
}

// SetEnablePrompt sets the EnablePrompt field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetEnablePrompt(v string) *PluginsInfoForDescribePluginsOutput {
	s.EnablePrompt = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetEnabled(v bool) *PluginsInfoForDescribePluginsOutput {
	s.Enabled = &v
	return s
}

// SetNeedRebootOnChange sets the NeedRebootOnChange field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetNeedRebootOnChange(v bool) *PluginsInfoForDescribePluginsOutput {
	s.NeedRebootOnChange = &v
	return s
}

// SetPluginName sets the PluginName field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetPluginName(v string) *PluginsInfoForDescribePluginsOutput {
	s.PluginName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetPort(v int32) *PluginsInfoForDescribePluginsOutput {
	s.Port = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PluginsInfoForDescribePluginsOutput) SetVersion(v string) *PluginsInfoForDescribePluginsOutput {
	s.Version = &v
	return s
}
