// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRestoreToNewInstanceCommon = "RestoreToNewInstance"

// RestoreToNewInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreToNewInstanceCommon operation. The "output" return
// value will be populated with the RestoreToNewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreToNewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreToNewInstanceCommon Send returns without error.
//
// See RestoreToNewInstanceCommon for more information on using the RestoreToNewInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the RestoreToNewInstanceCommonRequest method.
//    req, resp := client.RestoreToNewInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) RestoreToNewInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRestoreToNewInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreToNewInstanceCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation RestoreToNewInstanceCommon for usage and error information.
func (c *MONGODB) RestoreToNewInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RestoreToNewInstanceCommonRequest(input)
	return out, req.Send()
}

// RestoreToNewInstanceCommonWithContext is the same as RestoreToNewInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreToNewInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) RestoreToNewInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RestoreToNewInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreToNewInstance = "RestoreToNewInstance"

// RestoreToNewInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreToNewInstance operation. The "output" return
// value will be populated with the RestoreToNewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreToNewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreToNewInstanceCommon Send returns without error.
//
// See RestoreToNewInstance for more information on using the RestoreToNewInstance
// API call, and error handling.
//
//    // Example sending a request using the RestoreToNewInstanceRequest method.
//    req, resp := client.RestoreToNewInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) RestoreToNewInstanceRequest(input *RestoreToNewInstanceInput) (req *request.Request, output *RestoreToNewInstanceOutput) {
	op := &request.Operation{
		Name:       opRestoreToNewInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreToNewInstanceInput{}
	}

	output = &RestoreToNewInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreToNewInstance API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation RestoreToNewInstance for usage and error information.
func (c *MONGODB) RestoreToNewInstance(input *RestoreToNewInstanceInput) (*RestoreToNewInstanceOutput, error) {
	req, out := c.RestoreToNewInstanceRequest(input)
	return out, req.Send()
}

// RestoreToNewInstanceWithContext is the same as RestoreToNewInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreToNewInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) RestoreToNewInstanceWithContext(ctx volcengine.Context, input *RestoreToNewInstanceInput, opts ...request.Option) (*RestoreToNewInstanceOutput, error) {
	req, out := c.RestoreToNewInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RestoreToNewInstanceInput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	BackupId *string `type:"string"`

	ChargeType *string `type:"string" enum:"EnumOfChargeTypeForRestoreToNewInstanceInput"`

	DBEngine *string `type:"string" enum:"EnumOfDBEngineForRestoreToNewInstanceInput"`

	DBEngineVersion *string `type:"string" enum:"EnumOfDBEngineVersionForRestoreToNewInstanceInput"`

	InstanceName *string `type:"string"`

	InstanceType *string `type:"string" enum:"EnumOfInstanceTypeForRestoreToNewInstanceInput"`

	MongosNodeNumber *int32 `type:"int32"`

	MongosNodeSpec *string `type:"string"`

	NodeNumber *int32 `type:"int32"`

	// NodeSpec is a required field
	NodeSpec *string `type:"string" required:"true"`

	Number *int32 `type:"int32"`

	Period *int32 `type:"int32"`

	PeriodUnit *string `type:"string" enum:"EnumOfPeriodUnitForRestoreToNewInstanceInput"`

	ProjectName *string `type:"string"`

	RestoreTime *string `type:"string"`

	ShardNumber *int32 `type:"int32"`

	// SrcDBInstanceId is a required field
	SrcDBInstanceId *string `type:"string" required:"true"`

	// StorageSpaceGB is a required field
	StorageSpaceGB *int32 `type:"int32" required:"true"`

	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`

	SuperAccountName *string `type:"string"`

	SuperAccountPassword *string `type:"string"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`

	// ZoneId is a required field
	ZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreToNewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreToNewInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreToNewInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreToNewInstanceInput"}
	if s.NodeSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeSpec"))
	}
	if s.SrcDBInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SrcDBInstanceId"))
	}
	if s.StorageSpaceGB == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSpaceGB"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.ZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *RestoreToNewInstanceInput) SetAutoRenew(v bool) *RestoreToNewInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *RestoreToNewInstanceInput) SetBackupId(v string) *RestoreToNewInstanceInput {
	s.BackupId = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *RestoreToNewInstanceInput) SetChargeType(v string) *RestoreToNewInstanceInput {
	s.ChargeType = &v
	return s
}

// SetDBEngine sets the DBEngine field's value.
func (s *RestoreToNewInstanceInput) SetDBEngine(v string) *RestoreToNewInstanceInput {
	s.DBEngine = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *RestoreToNewInstanceInput) SetDBEngineVersion(v string) *RestoreToNewInstanceInput {
	s.DBEngineVersion = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *RestoreToNewInstanceInput) SetInstanceName(v string) *RestoreToNewInstanceInput {
	s.InstanceName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RestoreToNewInstanceInput) SetInstanceType(v string) *RestoreToNewInstanceInput {
	s.InstanceType = &v
	return s
}

// SetMongosNodeNumber sets the MongosNodeNumber field's value.
func (s *RestoreToNewInstanceInput) SetMongosNodeNumber(v int32) *RestoreToNewInstanceInput {
	s.MongosNodeNumber = &v
	return s
}

// SetMongosNodeSpec sets the MongosNodeSpec field's value.
func (s *RestoreToNewInstanceInput) SetMongosNodeSpec(v string) *RestoreToNewInstanceInput {
	s.MongosNodeSpec = &v
	return s
}

// SetNodeNumber sets the NodeNumber field's value.
func (s *RestoreToNewInstanceInput) SetNodeNumber(v int32) *RestoreToNewInstanceInput {
	s.NodeNumber = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *RestoreToNewInstanceInput) SetNodeSpec(v string) *RestoreToNewInstanceInput {
	s.NodeSpec = &v
	return s
}

// SetNumber sets the Number field's value.
func (s *RestoreToNewInstanceInput) SetNumber(v int32) *RestoreToNewInstanceInput {
	s.Number = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *RestoreToNewInstanceInput) SetPeriod(v int32) *RestoreToNewInstanceInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *RestoreToNewInstanceInput) SetPeriodUnit(v string) *RestoreToNewInstanceInput {
	s.PeriodUnit = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *RestoreToNewInstanceInput) SetProjectName(v string) *RestoreToNewInstanceInput {
	s.ProjectName = &v
	return s
}

// SetRestoreTime sets the RestoreTime field's value.
func (s *RestoreToNewInstanceInput) SetRestoreTime(v string) *RestoreToNewInstanceInput {
	s.RestoreTime = &v
	return s
}

// SetShardNumber sets the ShardNumber field's value.
func (s *RestoreToNewInstanceInput) SetShardNumber(v int32) *RestoreToNewInstanceInput {
	s.ShardNumber = &v
	return s
}

// SetSrcDBInstanceId sets the SrcDBInstanceId field's value.
func (s *RestoreToNewInstanceInput) SetSrcDBInstanceId(v string) *RestoreToNewInstanceInput {
	s.SrcDBInstanceId = &v
	return s
}

// SetStorageSpaceGB sets the StorageSpaceGB field's value.
func (s *RestoreToNewInstanceInput) SetStorageSpaceGB(v int32) *RestoreToNewInstanceInput {
	s.StorageSpaceGB = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *RestoreToNewInstanceInput) SetSubnetId(v string) *RestoreToNewInstanceInput {
	s.SubnetId = &v
	return s
}

// SetSuperAccountName sets the SuperAccountName field's value.
func (s *RestoreToNewInstanceInput) SetSuperAccountName(v string) *RestoreToNewInstanceInput {
	s.SuperAccountName = &v
	return s
}

// SetSuperAccountPassword sets the SuperAccountPassword field's value.
func (s *RestoreToNewInstanceInput) SetSuperAccountPassword(v string) *RestoreToNewInstanceInput {
	s.SuperAccountPassword = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *RestoreToNewInstanceInput) SetVpcId(v string) *RestoreToNewInstanceInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *RestoreToNewInstanceInput) SetZoneId(v string) *RestoreToNewInstanceInput {
	s.ZoneId = &v
	return s
}

type RestoreToNewInstanceOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string"`

	OrderNO *string `type:"string"`
}

// String returns the string representation
func (s RestoreToNewInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreToNewInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *RestoreToNewInstanceOutput) SetInstanceId(v string) *RestoreToNewInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetOrderNO sets the OrderNO field's value.
func (s *RestoreToNewInstanceOutput) SetOrderNO(v string) *RestoreToNewInstanceOutput {
	s.OrderNO = &v
	return s
}

const (
	// EnumOfChargeTypeForRestoreToNewInstanceInputNotEnabled is a EnumOfChargeTypeForRestoreToNewInstanceInput enum value
	EnumOfChargeTypeForRestoreToNewInstanceInputNotEnabled = "NotEnabled"

	// EnumOfChargeTypeForRestoreToNewInstanceInputPostPaid is a EnumOfChargeTypeForRestoreToNewInstanceInput enum value
	EnumOfChargeTypeForRestoreToNewInstanceInputPostPaid = "PostPaid"

	// EnumOfChargeTypeForRestoreToNewInstanceInputPrepaid is a EnumOfChargeTypeForRestoreToNewInstanceInput enum value
	EnumOfChargeTypeForRestoreToNewInstanceInputPrepaid = "Prepaid"
)

const (
	// EnumOfDBEngineForRestoreToNewInstanceInputMongoDb is a EnumOfDBEngineForRestoreToNewInstanceInput enum value
	EnumOfDBEngineForRestoreToNewInstanceInputMongoDb = "MongoDB"
)

const (
	// EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb40 is a EnumOfDBEngineVersionForRestoreToNewInstanceInput enum value
	EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb40 = "MongoDB_4_0"

	// EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb42 is a EnumOfDBEngineVersionForRestoreToNewInstanceInput enum value
	EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb42 = "MongoDB_4_2"

	// EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb44 is a EnumOfDBEngineVersionForRestoreToNewInstanceInput enum value
	EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb44 = "MongoDB_4_4"

	// EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb50 is a EnumOfDBEngineVersionForRestoreToNewInstanceInput enum value
	EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb50 = "MongoDB_5_0"

	// EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb60 is a EnumOfDBEngineVersionForRestoreToNewInstanceInput enum value
	EnumOfDBEngineVersionForRestoreToNewInstanceInputMongoDb60 = "MongoDB_6_0"
)

const (
	// EnumOfInstanceTypeForRestoreToNewInstanceInputReplicaSet is a EnumOfInstanceTypeForRestoreToNewInstanceInput enum value
	EnumOfInstanceTypeForRestoreToNewInstanceInputReplicaSet = "ReplicaSet"

	// EnumOfInstanceTypeForRestoreToNewInstanceInputShardedCluster is a EnumOfInstanceTypeForRestoreToNewInstanceInput enum value
	EnumOfInstanceTypeForRestoreToNewInstanceInputShardedCluster = "ShardedCluster"
)

const (
	// EnumOfPeriodUnitForRestoreToNewInstanceInputYear is a EnumOfPeriodUnitForRestoreToNewInstanceInput enum value
	EnumOfPeriodUnitForRestoreToNewInstanceInputYear = "Year"

	// EnumOfPeriodUnitForRestoreToNewInstanceInputMonth is a EnumOfPeriodUnitForRestoreToNewInstanceInput enum value
	EnumOfPeriodUnitForRestoreToNewInstanceInputMonth = "Month"
)
