// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opReEncryptCommon = "ReEncrypt"

// ReEncryptCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ReEncryptCommon operation. The "output" return
// value will be populated with the ReEncryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReEncryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReEncryptCommon Send returns without error.
//
// See ReEncryptCommon for more information on using the ReEncryptCommon
// API call, and error handling.
//
//    // Example sending a request using the ReEncryptCommonRequest method.
//    req, resp := client.ReEncryptCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ReEncryptCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opReEncryptCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReEncryptCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ReEncryptCommon for usage and error information.
func (c *KMS) ReEncryptCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ReEncryptCommonRequest(input)
	return out, req.Send()
}

// ReEncryptCommonWithContext is the same as ReEncryptCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ReEncryptCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReEncryptCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ReEncryptCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReEncrypt = "ReEncrypt"

// ReEncryptRequest generates a "volcengine/request.Request" representing the
// client's request for the ReEncrypt operation. The "output" return
// value will be populated with the ReEncryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ReEncryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after ReEncryptCommon Send returns without error.
//
// See ReEncrypt for more information on using the ReEncrypt
// API call, and error handling.
//
//    // Example sending a request using the ReEncryptRequest method.
//    req, resp := client.ReEncryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ReEncryptRequest(input *ReEncryptInput) (req *request.Request, output *ReEncryptOutput) {
	op := &request.Operation{
		Name:       opReEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReEncryptInput{}
	}

	output = &ReEncryptOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ReEncrypt API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ReEncrypt for usage and error information.
func (c *KMS) ReEncrypt(input *ReEncryptInput) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	return out, req.Send()
}

// ReEncryptWithContext is the same as ReEncrypt with the addition of
// the ability to pass a context and additional request options.
//
// See ReEncrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ReEncryptWithContext(ctx volcengine.Context, input *ReEncryptInput, opts ...request.Option) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ReEncryptInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CiphertextBlob is a required field
	CiphertextBlob *string `min:"19" type:"string" json:",omitempty" required:"true"`

	NewEncryptionContext map[string]*string `type:"map" json:",omitempty"`

	NewKeyID *string `type:"string" json:",omitempty"`

	NewKeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	NewKeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	OldEncryptionContext map[string]*string `type:"map" json:",omitempty"`
}

// String returns the string representation
func (s ReEncryptInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReEncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReEncryptInput"}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(*s.CiphertextBlob) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 19))
	}
	if s.NewKeyName != nil && len(*s.NewKeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NewKeyName", 2))
	}
	if s.NewKeyName != nil && len(*s.NewKeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("NewKeyName", 31, *s.NewKeyName))
	}
	if s.NewKeyringName != nil && len(*s.NewKeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NewKeyringName", 2))
	}
	if s.NewKeyringName != nil && len(*s.NewKeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("NewKeyringName", 31, *s.NewKeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *ReEncryptInput) SetCiphertextBlob(v string) *ReEncryptInput {
	s.CiphertextBlob = &v
	return s
}

// SetNewEncryptionContext sets the NewEncryptionContext field's value.
func (s *ReEncryptInput) SetNewEncryptionContext(v map[string]*string) *ReEncryptInput {
	s.NewEncryptionContext = v
	return s
}

// SetNewKeyID sets the NewKeyID field's value.
func (s *ReEncryptInput) SetNewKeyID(v string) *ReEncryptInput {
	s.NewKeyID = &v
	return s
}

// SetNewKeyName sets the NewKeyName field's value.
func (s *ReEncryptInput) SetNewKeyName(v string) *ReEncryptInput {
	s.NewKeyName = &v
	return s
}

// SetNewKeyringName sets the NewKeyringName field's value.
func (s *ReEncryptInput) SetNewKeyringName(v string) *ReEncryptInput {
	s.NewKeyringName = &v
	return s
}

// SetOldEncryptionContext sets the OldEncryptionContext field's value.
func (s *ReEncryptInput) SetOldEncryptionContext(v map[string]*string) *ReEncryptInput {
	s.OldEncryptionContext = v
	return s
}

type ReEncryptOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CiphertextBlob *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ReEncryptOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *ReEncryptOutput) SetCiphertextBlob(v string) *ReEncryptOutput {
	s.CiphertextBlob = &v
	return s
}
