// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAsymmetricVerifyCommon = "AsymmetricVerify"

// AsymmetricVerifyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricVerifyCommon operation. The "output" return
// value will be populated with the AsymmetricVerifyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricVerifyCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricVerifyCommon Send returns without error.
//
// See AsymmetricVerifyCommon for more information on using the AsymmetricVerifyCommon
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricVerifyCommonRequest method.
//    req, resp := client.AsymmetricVerifyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricVerifyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAsymmetricVerifyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricVerifyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricVerifyCommon for usage and error information.
func (c *KMS) AsymmetricVerifyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AsymmetricVerifyCommonRequest(input)
	return out, req.Send()
}

// AsymmetricVerifyCommonWithContext is the same as AsymmetricVerifyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricVerifyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricVerifyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AsymmetricVerifyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAsymmetricVerify = "AsymmetricVerify"

// AsymmetricVerifyRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricVerify operation. The "output" return
// value will be populated with the AsymmetricVerifyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricVerifyCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricVerifyCommon Send returns without error.
//
// See AsymmetricVerify for more information on using the AsymmetricVerify
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricVerifyRequest method.
//    req, resp := client.AsymmetricVerifyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricVerifyRequest(input *AsymmetricVerifyInput) (req *request.Request, output *AsymmetricVerifyOutput) {
	op := &request.Operation{
		Name:       opAsymmetricVerify,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AsymmetricVerifyInput{}
	}

	output = &AsymmetricVerifyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricVerify API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricVerify for usage and error information.
func (c *KMS) AsymmetricVerify(input *AsymmetricVerifyInput) (*AsymmetricVerifyOutput, error) {
	req, out := c.AsymmetricVerifyRequest(input)
	return out, req.Send()
}

// AsymmetricVerifyWithContext is the same as AsymmetricVerify with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricVerify for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricVerifyWithContext(ctx volcengine.Context, input *AsymmetricVerifyInput, opts ...request.Option) (*AsymmetricVerifyOutput, error) {
	req, out := c.AsymmetricVerifyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AsymmetricVerifyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Algorithm is a required field
	Algorithm *string `type:"string" json:",omitempty" required:"true"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	// Message is a required field
	Message *string `type:"string" json:",omitempty" required:"true"`

	MessageType *string `type:"string" json:",omitempty"`

	// Signature is a required field
	Signature *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s AsymmetricVerifyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricVerifyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AsymmetricVerifyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AsymmetricVerifyInput"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Signature == nil {
		invalidParams.Add(request.NewErrParamRequired("Signature"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AsymmetricVerifyInput) SetAlgorithm(v string) *AsymmetricVerifyInput {
	s.Algorithm = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricVerifyInput) SetKeyID(v string) *AsymmetricVerifyInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AsymmetricVerifyInput) SetKeyName(v string) *AsymmetricVerifyInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *AsymmetricVerifyInput) SetKeyringName(v string) *AsymmetricVerifyInput {
	s.KeyringName = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AsymmetricVerifyInput) SetMessage(v string) *AsymmetricVerifyInput {
	s.Message = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *AsymmetricVerifyInput) SetMessageType(v string) *AsymmetricVerifyInput {
	s.MessageType = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *AsymmetricVerifyInput) SetSignature(v string) *AsymmetricVerifyInput {
	s.Signature = &v
	return s
}

type AsymmetricVerifyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	KeyID *string `type:"string" json:",omitempty"`

	SignatureValid *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AsymmetricVerifyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricVerifyOutput) GoString() string {
	return s.String()
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricVerifyOutput) SetKeyID(v string) *AsymmetricVerifyOutput {
	s.KeyID = &v
	return s
}

// SetSignatureValid sets the SignatureValid field's value.
func (s *AsymmetricVerifyOutput) SetSignatureValid(v bool) *AsymmetricVerifyOutput {
	s.SignatureValid = &v
	return s
}
