// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAsymmetricDecryptCommon = "AsymmetricDecrypt"

// AsymmetricDecryptCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricDecryptCommon operation. The "output" return
// value will be populated with the AsymmetricDecryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricDecryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricDecryptCommon Send returns without error.
//
// See AsymmetricDecryptCommon for more information on using the AsymmetricDecryptCommon
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricDecryptCommonRequest method.
//    req, resp := client.AsymmetricDecryptCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricDecryptCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAsymmetricDecryptCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricDecryptCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricDecryptCommon for usage and error information.
func (c *KMS) AsymmetricDecryptCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AsymmetricDecryptCommonRequest(input)
	return out, req.Send()
}

// AsymmetricDecryptCommonWithContext is the same as AsymmetricDecryptCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricDecryptCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricDecryptCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AsymmetricDecryptCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAsymmetricDecrypt = "AsymmetricDecrypt"

// AsymmetricDecryptRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricDecrypt operation. The "output" return
// value will be populated with the AsymmetricDecryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricDecryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricDecryptCommon Send returns without error.
//
// See AsymmetricDecrypt for more information on using the AsymmetricDecrypt
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricDecryptRequest method.
//    req, resp := client.AsymmetricDecryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricDecryptRequest(input *AsymmetricDecryptInput) (req *request.Request, output *AsymmetricDecryptOutput) {
	op := &request.Operation{
		Name:       opAsymmetricDecrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AsymmetricDecryptInput{}
	}

	output = &AsymmetricDecryptOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricDecrypt API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricDecrypt for usage and error information.
func (c *KMS) AsymmetricDecrypt(input *AsymmetricDecryptInput) (*AsymmetricDecryptOutput, error) {
	req, out := c.AsymmetricDecryptRequest(input)
	return out, req.Send()
}

// AsymmetricDecryptWithContext is the same as AsymmetricDecrypt with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricDecrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricDecryptWithContext(ctx volcengine.Context, input *AsymmetricDecryptInput, opts ...request.Option) (*AsymmetricDecryptOutput, error) {
	req, out := c.AsymmetricDecryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AsymmetricDecryptInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Algorithm is a required field
	Algorithm *string `type:"string" json:",omitempty" required:"true"`

	// CiphertextBlob is a required field
	CiphertextBlob *string `min:"1" max:"4096" type:"string" json:",omitempty" required:"true"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AsymmetricDecryptInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricDecryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AsymmetricDecryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AsymmetricDecryptInput"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(*s.CiphertextBlob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 1))
	}
	if s.CiphertextBlob != nil && len(*s.CiphertextBlob) > 4096 {
		invalidParams.Add(request.NewErrParamMaxLen("CiphertextBlob", 4096, *s.CiphertextBlob))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AsymmetricDecryptInput) SetAlgorithm(v string) *AsymmetricDecryptInput {
	s.Algorithm = &v
	return s
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *AsymmetricDecryptInput) SetCiphertextBlob(v string) *AsymmetricDecryptInput {
	s.CiphertextBlob = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricDecryptInput) SetKeyID(v string) *AsymmetricDecryptInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AsymmetricDecryptInput) SetKeyName(v string) *AsymmetricDecryptInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *AsymmetricDecryptInput) SetKeyringName(v string) *AsymmetricDecryptInput {
	s.KeyringName = &v
	return s
}

type AsymmetricDecryptOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	KeyID *string `type:"string" json:",omitempty"`

	Plaintext *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AsymmetricDecryptOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricDecryptOutput) GoString() string {
	return s.String()
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricDecryptOutput) SetKeyID(v string) *AsymmetricDecryptOutput {
	s.KeyID = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *AsymmetricDecryptOutput) SetPlaintext(v string) *AsymmetricDecryptOutput {
	s.Plaintext = &v
	return s
}
