// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDetachRolePolicyCommon = "DetachRolePolicy"

// DetachRolePolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DetachRolePolicyCommon operation. The "output" return
// value will be populated with the DetachRolePolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DetachRolePolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after DetachRolePolicyCommon Send returns without error.
//
// See DetachRolePolicyCommon for more information on using the DetachRolePolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the DetachRolePolicyCommonRequest method.
//    req, resp := client.DetachRolePolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) DetachRolePolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDetachRolePolicyCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DetachRolePolicyCommon API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation DetachRolePolicyCommon for usage and error information.
func (c *IAM) DetachRolePolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DetachRolePolicyCommonRequest(input)
	return out, req.Send()
}

// DetachRolePolicyCommonWithContext is the same as DetachRolePolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DetachRolePolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) DetachRolePolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DetachRolePolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachRolePolicy = "DetachRolePolicy"

// DetachRolePolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the DetachRolePolicy operation. The "output" return
// value will be populated with the DetachRolePolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DetachRolePolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after DetachRolePolicyCommon Send returns without error.
//
// See DetachRolePolicy for more information on using the DetachRolePolicy
// API call, and error handling.
//
//    // Example sending a request using the DetachRolePolicyRequest method.
//    req, resp := client.DetachRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) DetachRolePolicyRequest(input *DetachRolePolicyInput) (req *request.Request, output *DetachRolePolicyOutput) {
	op := &request.Operation{
		Name:       opDetachRolePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachRolePolicyInput{}
	}

	output = &DetachRolePolicyOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DetachRolePolicy API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation DetachRolePolicy for usage and error information.
func (c *IAM) DetachRolePolicy(input *DetachRolePolicyInput) (*DetachRolePolicyOutput, error) {
	req, out := c.DetachRolePolicyRequest(input)
	return out, req.Send()
}

// DetachRolePolicyWithContext is the same as DetachRolePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachRolePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) DetachRolePolicyWithContext(ctx volcengine.Context, input *DetachRolePolicyInput, opts ...request.Option) (*DetachRolePolicyOutput, error) {
	req, out := c.DetachRolePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DetachRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// PolicyName is a required field
	PolicyName *string `min:"1" max:"64" type:"string" required:"true"`

	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"EnumOfPolicyTypeForDetachRolePolicyInput"`

	// RoleName is a required field
	RoleName *string `min:"1" max:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachRolePolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachRolePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyName != nil && len(*s.PolicyName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("PolicyName", 64, *s.PolicyName))
	}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}
	if s.RoleName != nil && len(*s.RoleName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("RoleName", 64, *s.RoleName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DetachRolePolicyInput) SetPolicyName(v string) *DetachRolePolicyInput {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *DetachRolePolicyInput) SetPolicyType(v string) *DetachRolePolicyInput {
	s.PolicyType = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *DetachRolePolicyInput) SetRoleName(v string) *DetachRolePolicyInput {
	s.RoleName = &v
	return s
}

type DetachRolePolicyOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DetachRolePolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfPolicyTypeForDetachRolePolicyInputSystem is a EnumOfPolicyTypeForDetachRolePolicyInput enum value
	EnumOfPolicyTypeForDetachRolePolicyInputSystem = "System"

	// EnumOfPolicyTypeForDetachRolePolicyInputCustom is a EnumOfPolicyTypeForDetachRolePolicyInput enum value
	EnumOfPolicyTypeForDetachRolePolicyInputCustom = "Custom"
)
